/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.xmi;

import de.julielab.jcore.consumer.xmi.XMIDBWriter;
import de.julielab.xmlData.dataBase.DataBaseConnector;
import de.julielab.xmlData.dataBase.util.CoStoSysSQLRuntimeException;
import de.julielab.xmlData.dataBase.util.TableSchemaMismatchException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationTableManager {
    public static final String ANNOTATION_LIST_TABLE = "_annotation_tables";
    public static final String TABLE_NAME = "tablename";
    private static final Logger log = LoggerFactory.getLogger(AnnotationTableManager.class);
    private DataBaseConnector dbc;
    private String documentTableSchema;
    private String annotationTableSchema;
    private Boolean storeAll;
    private String dbDocumentTableName;
    private String annotationStorageSchema;
    private Boolean storeBaseDocument;
    private List<String> obsoleteAnnotationTables;
    private List<String> annotationsToStore;

    public AnnotationTableManager(DataBaseConnector dbc, String rawDocumentTableName, List<String> annotationsToStore, String documentTableSchema, String annotationTableSchema, Boolean storeAll, Boolean storeBaseDocument, String annotationStorageSchema) throws TableSchemaMismatchException {
        this.dbc = dbc;
        this.annotationsToStore = annotationsToStore;
        this.documentTableSchema = documentTableSchema;
        this.annotationTableSchema = annotationTableSchema;
        this.storeAll = storeAll;
        this.storeBaseDocument = storeBaseDocument;
        this.dbDocumentTableName = this.getEffectiveDocumentTableName(rawDocumentTableName);
        this.annotationStorageSchema = annotationStorageSchema;
        this.createTable(rawDocumentTableName, documentTableSchema);
        for (String annotation : annotationsToStore) {
            this.createTable(annotation, annotationTableSchema);
        }
        this.createAnnotationListTable();
    }

    public String convertAnnotationTypeToTableName(String tableNameParameter, boolean storeAll) {
        if (storeAll || tableNameParameter.equals(this.dbDocumentTableName)) {
            return this.getEffectiveDocumentTableName(tableNameParameter);
        }
        String effectiveTableName = tableNameParameter.contains(":") ? tableNameParameter.substring(tableNameParameter.indexOf(58) + 1) : tableNameParameter;
        effectiveTableName = effectiveTableName.replace(".", "_");
        String schema = tableNameParameter.contains(":") ? tableNameParameter.substring(0, tableNameParameter.indexOf(46)) : this.annotationStorageSchema;
        return schema + "." + effectiveTableName;
    }

    String getEffectiveDocumentTableName(String documentTableParameter) {
        if (documentTableParameter.contains(".")) {
            return documentTableParameter;
        }
        return this.dbc.getActiveDataPGSchema() + "." + documentTableParameter;
    }

    List<String> getObsoleteAnnotationTableNames() {
        if (!this.storeBaseDocument.booleanValue()) {
            return Collections.emptyList();
        }
        if (null == this.obsoleteAnnotationTables) {
            this.obsoleteAnnotationTables = new ArrayList<String>();
            try {
                Connection conn = this.dbc.obtainConnection();
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT tablename FROM " + this.dbc.getActiveDataPGSchema() + "." + ANNOTATION_LIST_TABLE);
                while (rs.next()) {
                    this.obsoleteAnnotationTables.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            HashSet<String> annotationsToStoreTableNameSet = new HashSet<String>();
            for (String annotationTypeToStore : this.annotationsToStore) {
                annotationsToStoreTableNameSet.add(this.convertAnnotationTypeToTableName(annotationTypeToStore, false));
            }
            Iterator<String> it = this.obsoleteAnnotationTables.iterator();
            while (it.hasNext()) {
                String tablename = it.next();
                if (!annotationsToStoreTableNameSet.contains(tablename)) continue;
                it.remove();
            }
        }
        return this.obsoleteAnnotationTables;
    }

    void createTable(String tableName, String schema) throws TableSchemaMismatchException {
        String effectiveTableName = this.convertAnnotationTypeToTableName(tableName, this.storeAll);
        if (this.getEffectiveDocumentTableName(tableName).equals(this.dbDocumentTableName)) {
            effectiveTableName = this.dbDocumentTableName;
        }
        try {
            if (!this.dbc.tableExists(effectiveTableName)) {
                log.info("Creating table '{}' with schema '{}' (columns: {}).", new Object[]{effectiveTableName, schema, this.dbc.getFieldConfiguration(schema).getColumns()});
                String pgSchema = this.getTableSchema(effectiveTableName);
                if (!this.dbc.schemaExists(pgSchema)) {
                    this.dbc.createSchema(pgSchema);
                }
                if (this.storeAll.booleanValue()) {
                    this.dbc.createTable(effectiveTableName, schema, "Created by " + XMIDBWriter.class.getName() + " on " + new Date());
                } else if (!effectiveTableName.equals(this.dbDocumentTableName)) {
                    this.dbc.createTable(effectiveTableName, this.dbDocumentTableName, schema, "Created by " + XMIDBWriter.class.getName() + " on " + new Date() + " to store annotations of type\"" + tableName + "\" for the documents stored in table \"" + this.dbDocumentTableName + "\".");
                } else {
                    this.dbc.createTable(effectiveTableName, schema, "Created by " + XMIDBWriter.class.getName() + " on " + new Date() + " to store the base documents without linguistic or semantic annotations. Those are stored in the tables named after the annotation type they are storing in this Postgres schema.");
                }
            }
            String tableSchemaNameToCheck = effectiveTableName.equals(this.dbDocumentTableName) ? this.documentTableSchema : this.annotationTableSchema;
            this.dbc.checkTableDefinition(effectiveTableName, tableSchemaNameToCheck);
            if (!effectiveTableName.equals(this.dbDocumentTableName)) {
                this.addAnnotationTableToList(effectiveTableName);
            }
        }
        catch (CoStoSysSQLRuntimeException e) {
            log.warn("SQLException was thrown when creating tables. Possibly it is a concurrency issue and it has been tried to create the tables although they had already been created by another process in the meantime. Error was: {}", (Throwable)e);
        }
    }

    private String getTableSchema(String effectiveTableName) {
        int dotIndex = effectiveTableName.indexOf(46);
        if (dotIndex < 0) {
            return null;
        }
        return effectiveTableName.substring(0, dotIndex);
    }

    void addAnnotationTableToList(String tablename) {
        block3: {
            try {
                Connection conn = this.dbc.obtainConnection();
                conn.setAutoCommit(true);
                Statement stmt = conn.createStatement();
                String template = "INSERT INTO %s VALUES('%s')";
                String sql = String.format(template, this.dbc.getActiveDataPGSchema() + "." + ANNOTATION_LIST_TABLE, tablename);
                stmt.execute(sql);
            }
            catch (PSQLException e) {
                log.debug("Tried to add already existing annotation table to annotation list: \"{}\", ignoring.", (Object)tablename);
            }
            catch (SQLException e) {
                e.printStackTrace();
                SQLException ne = e.getNextException();
                if (null == ne) break block3;
                ne.printStackTrace();
            }
        }
    }

    private void createAnnotationListTable() {
        block3: {
            if (!this.dbc.tableExists(this.dbc.getActiveDataPGSchema() + "." + ANNOTATION_LIST_TABLE)) {
                try {
                    Connection conn = this.dbc.obtainConnection();
                    conn.setAutoCommit(true);
                    Statement stmt = conn.createStatement();
                    String sql = String.format("CREATE TABLE %s (%s text PRIMARY KEY)", this.dbc.getActiveDataPGSchema() + "." + ANNOTATION_LIST_TABLE, TABLE_NAME);
                    stmt.execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null == ne) break block3;
                    ne.printStackTrace();
                }
            }
        }
    }
}

