/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility.index;

import de.julielab.jcore.utility.index.IndexTermGenerator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.uima.cas.CASException;
import org.apache.uima.jcas.tcas.Annotation;

public class TermGenerators {
    public static IndexTermGenerator<String> nGramTermGenerator(int n) {
        return a -> {
            String text = a.getCoveredText();
            return IntStream.range(0, text.length()).mapToObj(i -> {
                if (i + n <= text.length()) {
                    return text.substring(i, i + n);
                }
                return null;
            }).filter(s -> s != null);
        };
    }

    public static IndexTermGenerator<String> edgeNGramTermGenerator(int n) {
        return a -> {
            String text = a.getCoveredText();
            return IntStream.range(0, n).mapToObj(i -> {
                if (i < text.length()) {
                    return text.substring(0, i + 1);
                }
                return null;
            }).filter(s -> s != null);
        };
    }

    public static IndexTermGenerator<String> prefixTermGenerator(int maxLength) {
        return a -> {
            try {
                String documentText = a.getCAS().getJCas().getDocumentText();
                return documentText.substring(a.getBegin(), a.getBegin() + Math.min(maxLength, a.getEnd() - a.getBegin()));
            }
            catch (CASException e) {
                e.printStackTrace();
                return Stream.empty();
            }
        };
    }

    public static IndexTermGenerator<String> suffixTermGenerator(int maxLength) {
        return a -> {
            try {
                String documentText = a.getCAS().getJCas().getDocumentText();
                return documentText.substring(Math.max(a.getEnd() - maxLength, a.getBegin()), a.getEnd());
            }
            catch (CASException e) {
                e.printStackTrace();
                return Stream.empty();
            }
        };
    }

    public static IndexTermGenerator<String> exactPrefixTermGenerator(int length) {
        return a -> {
            try {
                String documentText = a.getCAS().getJCas().getDocumentText();
                if (a.getEnd() - a.getBegin() >= length) {
                    return documentText.substring(a.getBegin(), a.getBegin() + length);
                }
            }
            catch (CASException e) {
                e.printStackTrace();
            }
            return Stream.empty();
        };
    }

    public static IndexTermGenerator<String> exactSuffixTermGenerator(int length) {
        return a -> {
            try {
                String documentText = a.getCAS().getJCas().getDocumentText();
                if (a.getEnd() - a.getBegin() >= length) {
                    return documentText.substring(Math.max(a.getEnd() - length, a.getBegin()), a.getEnd());
                }
            }
            catch (CASException e) {
                e.printStackTrace();
            }
            return Stream.empty();
        };
    }

    public static LongOffsetIndexTermGenerator longOffsetTermGenerator() {
        return new LongOffsetIndexTermGenerator();
    }

    public static class LongOffsetIndexTermGenerator
    implements IndexTermGenerator<Long> {
        @Override
        public Object generateIndexTerms(Annotation a) {
            return this.forOffsets(a.getBegin(), a.getEnd());
        }

        public Long forOffsets(int begin, int end) {
            return (long)begin << 32 | (long)end;
        }
    }
}

