/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility.index;

import de.julielab.jcore.utility.JCoReTools;
import de.julielab.jcore.utility.index.Comparators;
import de.julielab.jcore.utility.index.JCoReAnnotationIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class JCoReCoverIndex<E extends Annotation>
implements JCoReAnnotationIndex<E> {
    private List<E> index = new ArrayList();
    private boolean frozen;

    public JCoReCoverIndex() {
    }

    public JCoReCoverIndex(JCas jcas, int type) {
        this(jcas, jcas.getCasType(type));
    }

    public JCoReCoverIndex(JCas jcas, Type type) {
        this();
        this.index(jcas, type);
        this.freeze();
    }

    public void freeze() {
        this.frozen = true;
        Collections.sort(this.index, Comparators.beginOffsetComparator());
    }

    public void melt() {
        this.frozen = false;
    }

    @Override
    public void index(JCas jCas, int type) {
        this.index(jCas, jCas.getCasType(type));
    }

    @Override
    public void index(JCas jCas, Type type) {
        for (Annotation annotation : jCas.getAnnotationIndex(type)) {
            this.index((E)annotation);
        }
    }

    @Override
    public void index(E annotation) {
        if (this.frozen) {
            throw new IllegalStateException("This index is frozen and cannot except further items.");
        }
        this.index.add(annotation);
    }

    public Stream<E> search(Annotation a) {
        return this.search(a.getBegin(), a.getEnd());
    }

    public Stream<E> search(int begin, int end) {
        if (!this.frozen) {
            throw new IllegalStateException("This index is not frozen and cannot be used yet. Freeze the index before searching.");
        }
        if (this.index.isEmpty()) {
            return Stream.empty();
        }
        int lowerIndex = this.insertionPoint(JCoReTools.binarySearch(this.index, a -> a.getBegin(), begin));
        int upperIndex = this.insertionPoint(JCoReTools.binarySearch(this.index, a -> a.getBegin(), end));
        return this.index.subList(lowerIndex, upperIndex).stream().filter(a -> a.getEnd() <= end);
    }

    private int insertionPoint(int i) {
        return i < 0 ? -(i + 1) : i;
    }

    @Override
    public void add(E a) {
        this.index(a);
    }
}

