/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeClass;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCoReFeaturePath
implements FeaturePath {
    private String[] featurePath;
    private String[] featureBaseNames;
    private Feature[] features;
    private List<Set<Feature>> featureCandidates;
    private int[] arrayIndexes;
    private Type currentType;
    private Matcher arrayIndexMatcher = Pattern.compile("\\[-?[0-9]+\\]").matcher("");
    private String featurePathString;
    private Map<Class<?>, Method> getterMap;
    private Map<Class<?>, Method> setterMap;
    private Map<?, ?> replacements;
    private Set<FeatureStructure> alreadyReplaced;
    private boolean replaceUnmappedValues;
    private Object defaultReplacementValue;
    private boolean featurePathChanged;
    private String builtInFunction;
    private static final Logger log = LoggerFactory.getLogger(JCoReFeaturePath.class);

    public int size() {
        if (null != this.features) {
            return this.features.length;
        }
        return 0;
    }

    public Feature getFeature(int i) {
        if (null != this.features) {
            return this.features[i];
        }
        return null;
    }

    public void addFeature(Feature feat) {
        throw new UnsupportedOperationException();
    }

    public void initialize(String featurePath) throws CASException {
        log.debug("Initializing with feature path \"{}\".", (Object)featurePath);
        this.featurePathChanged = null == this.featurePathString || !this.featurePathString.equals(featurePath);
        this.featurePathString = featurePath;
        if (!this.featurePathString.startsWith("/")) {
            this.featurePathString = "/" + this.featurePathString;
        }
        this.featurePath = featurePath.trim().substring(1).split("/");
        log.debug("Initializing feature path with these path elements: {}", (Object)Arrays.toString(this.featurePath));
        String[] builtInFunctionSplit = this.featurePath[this.featurePath.length - 1].split(":");
        if (builtInFunctionSplit.length > 1) {
            this.featurePath[this.featurePath.length - 1] = builtInFunctionSplit[0];
            if (this.featurePath.length == 1 && this.featurePath[0].trim().length() == 0) {
                this.featurePath = new String[0];
            }
            this.builtInFunction = builtInFunctionSplit[1];
            log.debug("Found in-built function {} to apply on the feature structure pointed to by the feature path.", (Object)this.builtInFunction);
        }
        this.getterMap = new HashMap();
        this.setterMap = new HashMap();
        this.alreadyReplaced = new HashSet<FeatureStructure>();
        this.replaceUnmappedValues = false;
    }

    public void initialize(String featurePath, Map<?, ?> replacements) throws CASException {
        this.initialize(featurePath);
        this.replacements = replacements;
    }

    public void typeInit(Type featurePathType) throws CASException {
        if (this.featurePathChanged || null == this.currentType || !this.currentType.equals(featurePathType)) {
            log.debug("Initializing internal structure for feature path {} on type {}.", (Object)this.featurePathString, (Object)featurePathType.getName());
            Type currentFeatureType = featurePathType;
            this.features = new Feature[this.featurePath.length];
            this.featureBaseNames = new String[this.featurePath.length];
            this.arrayIndexes = new int[this.featurePath.length];
            this.featureCandidates = new ArrayList<Set<Feature>>(this.featurePath.length);
            for (int i = 0; i < this.featurePath.length; ++i) {
                String featureName = this.featurePath[i];
                this.arrayIndexes[i] = Integer.MIN_VALUE;
                this.featureCandidates.add(null);
                this.arrayIndexMatcher.reset(featureName);
                try {
                    if (this.arrayIndexMatcher.find()) {
                        String indexSpecification = this.arrayIndexMatcher.group();
                        String indexString = indexSpecification.substring(1, indexSpecification.length() - 1);
                        this.arrayIndexes[i] = Integer.parseInt(indexString);
                        if (this.arrayIndexes[i] == Integer.MIN_VALUE) {
                            throw new IllegalArgumentException("The negative array index " + this.arrayIndexes[i] + " is not allowed because Integer.MIN_VALUE is used to identify non-specified array indexes.");
                        }
                        featureName = featureName.substring(0, featureName.length() - indexSpecification.length());
                        log.debug("Identified array index {} for feature {}.", (Object)indexString, (Object)featureName);
                    }
                    this.featureBaseNames[i] = featureName;
                    Feature feature = currentFeatureType.getFeatureByBaseName(featureName);
                    if (null == feature) {
                        log.debug("Feature \"{}\" is not defined for type \"{}\". It is checked whether the feature is defined on one or more subtypes.", (Object)featureName, (Object)currentFeatureType);
                        TypeSystem typeSystem = ((TypeImpl)featurePathType).getTypeSystem();
                        Set<Feature> featuresOfSubtypes = this.searchFeatureInSubtypes(featureName, currentFeatureType, typeSystem);
                        if (featuresOfSubtypes.size() == 1) {
                            feature = featuresOfSubtypes.iterator().next();
                        } else {
                            this.featureCandidates.set(i, featuresOfSubtypes);
                        }
                        if (null == feature && featuresOfSubtypes.isEmpty()) {
                            throw new CASException("UNDEFINED_FEATURE", new Object[]{featureName, currentFeatureType});
                        }
                    }
                    if (null == feature) continue;
                    this.features[i] = feature;
                    if (feature.getRange().isPrimitive()) {
                        log.trace("Feature {} identified as primitive-valued.", (Object)featureName);
                        currentFeatureType = feature.getRange();
                    } else if (feature.getRange().isArray()) {
                        log.trace("Feature {} identified as array-valued.", (Object)featureName);
                        currentFeatureType = feature.getRange().getComponentType();
                    } else {
                        log.trace("Feature {} identified as FeatureStructure-valued.", (Object)featureName);
                        currentFeatureType = feature.getRange();
                    }
                    log.debug("Determined type \"{}\" for feature \"{}\".", (Object)currentFeatureType, (Object)featureName);
                    continue;
                }
                catch (Exception e) {
                    log.error("Error happened while initializing feature path \"{}\" on type \"{}\". Path element index: {} (\"{}\").", new Object[]{this.featurePathString, featurePathType, i, featureName});
                    throw e;
                }
            }
            this.currentType = featurePathType;
            this.featurePathChanged = false;
        }
    }

    private Set<Feature> searchFeatureInSubtypes(String featureName, Type type, TypeSystem typeSystem) {
        HashSet<Feature> returnFeatures = new HashSet<Feature>();
        List subtypes = typeSystem.getDirectSubtypes(type);
        if (0 == subtypes.size()) {
            return Collections.emptySet();
        }
        for (Type subtype : subtypes) {
            Feature foundFeature = subtype.getFeatureByBaseName(featureName);
            if (null != foundFeature) {
                log.debug("Determined feature \"{}\" to actually belong to subtype \"{}\" (and possible others).", (Object)featureName, (Object)type);
                returnFeatures.add(foundFeature);
            }
            returnFeatures.addAll(this.searchFeatureInSubtypes(featureName, subtype, typeSystem));
        }
        return returnFeatures;
    }

    public Object replaceValue(FeatureStructure fs) {
        return this.getValue(fs, 0, this.replacements);
    }

    public Object getValue(FeatureStructure fs, int startFeatureIndex) {
        return this.getValue(fs, startFeatureIndex, null);
    }

    private Object getValue(FeatureStructure fs, int startFeatureIndex, Map<?, ?> replacements) {
        int i;
        if (fs == null) {
            throw new IllegalArgumentException("Passed FeatureStructure may not be null but it is.");
        }
        FeatureStructure featureValue = null;
        try {
            if (startFeatureIndex == 0) {
                this.typeInit(fs.getType());
            }
            FeatureStructure currentFs = fs;
            for (i = startFeatureIndex; i < this.features.length; ++i) {
                Feature currentFeature = this.features[i];
                log.trace("Now traversing feature {} on type {}, beginning at position {} of the feature path.", new Object[]{currentFeature, fs.getType(), startFeatureIndex});
                if (null == currentFeature) {
                    currentFeature = currentFs.getType().getFeatureByBaseName(this.featureBaseNames[i]);
                }
                if (null == currentFeature) {
                    throw new CASException("UNDEFINED_FEATURE", new Object[]{this.featureBaseNames[i], currentFs.getType()});
                }
                if (currentFeature.getRange().isPrimitive()) {
                    if (i < this.features.length - 1) {
                        log.warn("The value of the feature \"{}\" is primitive. However, the feature path \"{}\" has not yet come to an end. The current feature value is returned, the rest of the feature path is ignored.");
                        break;
                    }
                    featureValue = this.getFeatureValueFromFeatureStructure(currentFs, currentFeature, replacements);
                    log.trace("Feature {} identified as primitive-valued. The value is: \"{}\"", (Object)currentFeature, (Object)featureValue);
                    continue;
                }
                if (currentFeature.getRange().isArray()) {
                    log.trace("Feature {} identified as array-valued.", (Object)currentFeature);
                    FeatureStructure array = currentFs.getFeatureValue(currentFeature);
                    if (null == array) break;
                    Class<?> arrayClass = array.getClass();
                    int index = this.arrayIndexes[i];
                    if (arrayClass.equals(FSArray.class)) {
                        log.trace("Value of feature  {} is a {}.", (Object)currentFeature, (Object)arrayClass.getSimpleName());
                        FSArray fsArray = (FSArray)array;
                        if (index >= fsArray.size()) {
                            log.trace("Array index is {} which is greater than the array has entries. Nothing is returned for this feature structure.", (Object)index);
                            break;
                        }
                        if (index == Integer.MIN_VALUE) {
                            log.trace("No particular index to access has been given. Returning values for all elements in the array.");
                            FeatureStructure valueList = new ArrayList();
                            for (int j = 0; j < fsArray.size(); ++j) {
                                FeatureStructure element = fsArray.get(j);
                                if (null == element) {
                                    log.trace("Element at position {} was null, skipping this element.", (Object)j);
                                    continue;
                                }
                                if (i == this.features.length - 1) {
                                    valueList.add(element);
                                    log.trace("Retrieved value \"{}\" for element at position {}. This is the end of the feature path.", (Object)element, (Object)j);
                                    continue;
                                }
                                Object elementValue = this.getValue(element, i + 1, replacements);
                                log.trace("Retrieved value \"{}\" for element no {}.", elementValue, (Object)j);
                                if (null != elementValue && elementValue.getClass() == ArrayList.class) {
                                    log.trace("Adding values to result list.");
                                    ArrayList remainderPathValues = (ArrayList)elementValue;
                                    valueList.addAll(remainderPathValues);
                                    continue;
                                }
                                log.trace("Adding value to result list.");
                                valueList.add(elementValue);
                            }
                            featureValue = valueList;
                            break;
                        }
                        int effectiveIndex = index;
                        if (effectiveIndex < 0) {
                            effectiveIndex = fsArray.size() + index;
                        }
                        if (effectiveIndex < 0 || effectiveIndex >= fsArray.size()) {
                            log.trace("Array index {} is out of bounds for array found for feature, returning null", (Object)effectiveIndex, (Object)currentFeature);
                            return null;
                        }
                        FeatureStructure arrayElement = fsArray.get(effectiveIndex);
                        if (i < this.features.length - 1) {
                            currentFs = arrayElement;
                            continue;
                        }
                        featureValue = arrayElement;
                        if (null == replacements) continue;
                        throw new IllegalArgumentException("Replacements of feature values is only supported for primitive feature types. However, the feature path " + this.featurePathString + " points to the feature value " + featureValue);
                    }
                    if (!arrayClass.equals(StringArray.class)) continue;
                    log.trace("Value of feature  {} is a {}.", (Object)currentFeature, (Object)arrayClass.getSimpleName());
                    CommonArrayFS sa = (CommonArrayFS)array;
                    try {
                        featureValue = this.getArrayValue(sa, index, replacements);
                        this.alreadyReplaced.add(currentFs);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (i < this.features.length - 1) {
                    currentFs = currentFs.getFeatureValue(currentFeature);
                    continue;
                }
                featureValue = currentFs.getFeatureValue(currentFeature);
            }
        }
        catch (CASException e) {
            throw new RuntimeException(e);
        }
        if (this.builtInFunction != null && featureValue != null) {
            if (List.class.isAssignableFrom(featureValue.getClass())) {
                List valueList = (List)featureValue;
                for (i = 0; i < valueList.size(); ++i) {
                    Object value = valueList.get(i);
                    Object functionValue = null;
                    functionValue = this.applyBuiltInFunction(value);
                    if (functionValue == null) continue;
                    valueList.set(i, functionValue);
                }
            } else if (featureValue instanceof FeatureStructure) {
                featureValue = this.applyBuiltInFunction(featureValue);
            }
        } else if (this.builtInFunction != null && this.featurePath.length == 0) {
            featureValue = this.applyBuiltInFunction(fs);
        }
        return featureValue;
    }

    private Object applyBuiltInFunction(Object value) {
        String functionValue = null;
        if (value instanceof Annotation) {
            if (this.builtInFunction.equals("coveredText()")) {
                functionValue = ((Annotation)value).getCoveredText();
            } else if (this.builtInFunction.equals("typeName()")) {
                functionValue = value.getClass().getName();
            } else {
                throw new NotImplementedException("Built-in function " + this.builtInFunction + " is currently not supported by the JCoReFeaturePath");
            }
        }
        return functionValue;
    }

    private Object getArrayValue(CommonArrayFS sa, int index, Map<?, ?> replacements) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<Object> featureValue;
        Method getter = this.getterMap.get(sa.getClass());
        if (null == getter) {
            getter = sa.getClass().getDeclaredMethod("get", Integer.TYPE);
            this.getterMap.put(sa.getClass(), getter);
        }
        Method setter = null;
        if (null != replacements && null == (setter = this.setterMap.get(sa.getClass()))) {
            setter = sa.getClass().getDeclaredMethod("set", Integer.TYPE, getter.getReturnType());
            this.setterMap.put(sa.getClass(), setter);
        }
        if (index >= sa.size()) {
            log.trace("Array index is {} which is greater than the array has entries. Nothing is returned for this feature structure.", (Object)index);
            return null;
        }
        if (index == Integer.MIN_VALUE) {
            log.trace("No particular index to access has been given. Returning values for all elements in the array.");
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (int j = 0; j < sa.size(); ++j) {
                Object value = this.getArrayElement(sa, replacements, getter, setter, j);
                valueList.add(value);
            }
            featureValue = valueList;
        } else {
            featureValue = this.getArrayElement(sa, replacements, getter, setter, index);
        }
        return featureValue;
    }

    protected Object getArrayElement(CommonArrayFS sa, Map<?, ?> replacements, Method getter, Method setter, int index) throws IllegalAccessException, InvocationTargetException {
        int effectiveIndex = index;
        if (effectiveIndex < 0) {
            effectiveIndex = sa.size() + effectiveIndex;
        }
        if (effectiveIndex < 0 || effectiveIndex > sa.size()) {
            return null;
        }
        Object value = getter.invoke((Object)sa, effectiveIndex);
        if (null != replacements && !this.alreadyReplaced.contains(sa)) {
            Object replacement = replacements.get(value);
            if (null == replacement && !this.replaceUnmappedValues) {
                log.trace("Value {} for array position {} is not replaced because there was no replacement entry (i.e. the replacement is null) and null value replacement is switched off.", new Object[]{value, effectiveIndex});
            } else {
                if (null == replacement) {
                    replacement = this.defaultReplacementValue;
                    log.trace("No mapped value found for feature value {}, using default value {} instead.", value, this.defaultReplacementValue);
                }
                log.trace("Replacing array value at position {}: {} --> {}", new Object[]{effectiveIndex, value, replacement});
                value = replacement;
                setter.invoke((Object)sa, effectiveIndex, value);
            }
        }
        return value;
    }

    protected Object getFeatureValueFromFeatureStructure(FeatureStructure fs, Feature feature, Map<?, ?> replacements) {
        Object featureValue;
        if (null == fs) {
            throw new IllegalArgumentException("Passed FeatureStucture was null");
        }
        Type rangeType = feature.getRange();
        switch (rangeType.getName()) {
            case "uima.cas.String": {
                featureValue = fs.getFeatureValueAsString(feature);
                break;
            }
            case "uima.cas.Integer": {
                featureValue = fs.getIntValue(feature);
                break;
            }
            case "uima.cas.Boolean": {
                featureValue = fs.getBooleanValue(feature);
                break;
            }
            case "uima.cas.Float": {
                featureValue = Float.valueOf(fs.getFloatValue(feature));
                break;
            }
            case "uima.cas.Double": {
                featureValue = fs.getDoubleValue(feature);
                break;
            }
            case "uima.cas.Byte": {
                featureValue = fs.getByteValue(feature);
                break;
            }
            case "uima.cas.Long": {
                featureValue = fs.getLongValue(feature);
                break;
            }
            case "uima.cas.Short": {
                featureValue = fs.getShortValue(feature);
                break;
            }
            default: {
                throw new IllegalArgumentException("The type " + rangeType + " is currently not supported as feature value type.");
            }
        }
        if (null != replacements && !this.alreadyReplaced.contains(fs)) {
            Object replacement = replacements.get(featureValue);
            if (null == replacement && !this.replaceUnmappedValues) {
                log.trace("Value {} for feature {} is not replaced because there was no replacement entry (i.e. the replacement is null) and null value replacement is switched off.", new Object[]{featureValue, feature.getName()});
            } else {
                if (null == replacement) {
                    replacement = this.defaultReplacementValue;
                    log.trace("No mapped value found for feature value {}, using default value {} instead.", featureValue, this.defaultReplacementValue);
                }
                log.trace("Replacing value for feature {}: {} --> {}", new Object[]{feature.getName(), featureValue, replacement});
                featureValue = replacement;
                fs.setFeatureValueFromString(feature, null != featureValue ? String.valueOf(featureValue) : null);
                this.alreadyReplaced.add(fs);
            }
        } else if (null != replacements && this.alreadyReplaced.contains(fs)) {
            log.trace("Value {} for feature {} is not replaced because the respective feature structure {} was already subject to a replacement.", new Object[]{featureValue, feature.getName(), fs.toString()});
        } else {
            log.trace("No replacement because replacements are null: {}", replacements);
        }
        return featureValue;
    }

    public String[] getValueAsStringArray(FeatureStructure fs, boolean doReplacements) {
        Object value = this.getValue(fs, 0, doReplacements ? this.replacements : null);
        return this.getValueAsStringArray(value);
    }

    public String[] getValueAsStringArray(FeatureStructure fs) {
        Object value = this.getValue(fs, 0);
        return this.getValueAsStringArray(value);
    }

    private String[] getValueAsStringArray(Object value) {
        if (null == value) {
            return null;
        }
        if (value.getClass() == ArrayList.class) {
            List objectValues = (List)value;
            String[] stringValues = new String[objectValues.size()];
            for (int i = 0; i < objectValues.size(); ++i) {
                String stringValue;
                stringValues[i] = stringValue = this.getObjectValueAsString(objectValues.get(i));
            }
            return stringValues;
        }
        String[] stringValue = new String[]{this.getObjectValueAsString(value)};
        return stringValue;
    }

    public List<String> getValueAsStringList(FeatureStructure fs, boolean doReplacements) {
        Object value = this.getValue(fs, 0, doReplacements ? this.replacements : null);
        return this.getValueAsStringList(value);
    }

    public List<String> getValueAsStringList(FeatureStructure fs) {
        Object value = this.getValue(fs, 0);
        return this.getValueAsStringList(value);
    }

    private List<String> getValueAsStringList(Object value) {
        if (null == value) {
            return null;
        }
        if (value.getClass() == ArrayList.class) {
            List objectValues = (List)value;
            ArrayList<String> stringValues = new ArrayList<String>(objectValues.size());
            for (int i = 0; i < objectValues.size(); ++i) {
                String stringValue = this.getObjectValueAsString(objectValues.get(i));
                stringValues.add(stringValue);
            }
            return stringValues;
        }
        ArrayList<String> stringValue = new ArrayList<String>();
        stringValue.add(this.getObjectValueAsString(value));
        return stringValue;
    }

    protected String getObjectValueAsString(Object objectValue) {
        if (null == objectValue) {
            return null;
        }
        String stringValue = null;
        if (objectValue.getClass() == String.class) {
            stringValue = (String)objectValue;
        } else if (objectValue instanceof Number) {
            stringValue = String.valueOf(objectValue);
        }
        return stringValue;
    }

    public String getValueAsString(FeatureStructure fs) {
        return this.getValueAsString(fs, false);
    }

    public String getValueAsString(FeatureStructure fs, boolean doReplacements) {
        Object value = this.getValue(fs, 0, doReplacements ? this.replacements : null);
        if (null == value) {
            return null;
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            List objectValues = (List)value;
            ArrayList<String> stringValues = new ArrayList<String>();
            for (int i = 0; i < objectValues.size(); ++i) {
                Object objectValue = objectValues.get(i);
                String stringValue = null;
                if (objectValue.getClass() == String.class) {
                    stringValue = (String)objectValue;
                } else if (objectValue instanceof Number) {
                    stringValue = String.valueOf(objectValue);
                }
                stringValues.add(stringValue);
            }
            return StringUtils.join(stringValues, (String)", ");
        }
        if (value instanceof Number) {
            return String.valueOf(value);
        }
        return (String)value;
    }

    public void setReplaceUnmappedValues(boolean replaceWithNullValues) {
        this.replaceUnmappedValues = replaceWithNullValues;
    }

    public boolean getReplaceUnmappedValues() {
        return this.replaceUnmappedValues;
    }

    public String ll_getValueAsString(int fsRef, LowLevelCAS llCas) {
        return null;
    }

    public Type getType(FeatureStructure fs) {
        return null;
    }

    public TypeClass getTypClass(FeatureStructure fs) {
        return null;
    }

    public String getFeaturePath() {
        return null;
    }

    public String getStringValue(FeatureStructure fs) {
        return null;
    }

    public Integer getIntValue(FeatureStructure fs) {
        return null;
    }

    public Boolean getBooleanValue(FeatureStructure fs) {
        return null;
    }

    public Byte getByteValue(FeatureStructure fs) {
        return null;
    }

    public Double getDoubleValue(FeatureStructure fs) {
        return null;
    }

    public Float getFloatValue(FeatureStructure fs) {
        return null;
    }

    public Long getLongValue(FeatureStructure fs) {
        return null;
    }

    public Short getShortValue(FeatureStructure fs) {
        return null;
    }

    public FeatureStructure getFSValue(FeatureStructure fs) {
        return null;
    }

    public void loadReplacementsFromFile(String replacementsFile) throws FileNotFoundException, IOException {
        this.replacements = JCoReFeaturePath.readReplacementsFromFile(replacementsFile);
    }

    public static Map<String, String> readReplacementsFromFile(String replacementsFile) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(replacementsFile);){
            Map<String, String> map = JCoReFeaturePath.readReplacementsFromInputStream(fis);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readReplacementsFromInputStream(InputStream is) throws FileNotFoundException, IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            HashMap<String, String> replacements = new HashMap<String, String>();
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                String[] split = line.split("=");
                if (split.length != 2) {
                    throw new IllegalArgumentException("Format error in replacements file: Expected format is 'originalValue=replacementValue' but the input line '" + line + "' has " + split.length + " columns.");
                }
                replacements.put(split[0].trim(), split[1].trim());
            }
            HashMap<String, String> hashMap = replacements;
            return hashMap;
        }
    }

    public Object getDefaultReplacementValue() {
        return this.defaultReplacementValue;
    }

    public void setDefaultReplacementValue(Object defaultReplacementValue) {
        this.defaultReplacementValue = defaultReplacementValue;
    }

    public void clearReplacementCache() {
        this.alreadyReplaced.clear();
    }
}

