/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.NotImplementedException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;

public class JCoReFSListIterator<T extends FeatureStructure>
implements FSIterator<T> {
    private List<T> fsList;
    private int pos;

    public JCoReFSListIterator(List<T> list) {
        this.fsList = list;
        if (this.fsList == null) {
            this.fsList = Collections.emptyList();
        }
        this.pos = -1;
    }

    public boolean hasNext() {
        return !this.fsList.isEmpty() && this.pos < this.fsList.size() - 1 && this.pos + 1 >= 0;
    }

    public T next() {
        ++this.pos;
        if (this.isValid()) {
            return this.get();
        }
        return null;
    }

    public void remove() {
        this.fsList.remove(this.pos);
    }

    public boolean isValid() {
        return this.pos >= 0 && this.pos < this.fsList.size();
    }

    public T get() throws NoSuchElementException {
        if (this.pos < 0 || this.pos >= this.fsList.size()) {
            throw new NoSuchElementException("List size: " + this.fsList.size() + ", index: " + this.pos);
        }
        return (T)((FeatureStructure)this.fsList.get(this.pos));
    }

    public void moveToNext() {
        ++this.pos;
    }

    public void moveToPrevious() {
        --this.pos;
    }

    public void moveToFirst() {
        this.pos = 0;
    }

    public void moveToLast() {
        this.pos = this.fsList.size() - 1;
    }

    public void moveTo(FeatureStructure fs) {
        throw new NotImplementedException();
    }

    public FSIterator<T> copy() {
        return new JCoReFSListIterator<T>(this.fsList);
    }
}

