/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility;

import de.julielab.jcore.utility.JCoReAnnotationIndexMerger;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.uima.jcas.JCas;

public class JCoReCondensedDocumentText {
    private NavigableMap<Integer, Integer> condensedPos2SumCutMap;
    private NavigableMap<Integer, Integer> originalPos2SumCutMap;
    private String condensedText;
    private JCas cas;

    public JCas getCas() {
        return this.cas;
    }

    public JCoReCondensedDocumentText(JCas cas, Set<String> cutAwayTypes) throws ClassNotFoundException {
        this.cas = cas;
        this.buildMap(cas, cutAwayTypes);
    }

    public void buildMap(JCas cas, Set<String> cutAwayTypes) throws ClassNotFoundException {
        if (cutAwayTypes == null || cutAwayTypes.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.condensedPos2SumCutMap = new TreeMap<Integer, Integer>();
        this.condensedPos2SumCutMap.put(0, 0);
        this.originalPos2SumCutMap = new TreeMap<Integer, Integer>();
        this.originalPos2SumCutMap.put(0, 0);
        JCoReAnnotationIndexMerger merger = new JCoReAnnotationIndexMerger(cutAwayTypes, true, null, cas);
        int cutSum = 0;
        int lastBegin = 0;
        int lastEnd = -1;
        while (merger.incrementAnnotation()) {
            int end = merger.getCurrentEnd();
            int begin = merger.getCurrentBegin();
            if (lastEnd > 0 && begin > lastEnd) {
                int condensedPosition = lastEnd - (cutSum += lastEnd - lastBegin) + 1;
                this.condensedPos2SumCutMap.put(condensedPosition, cutSum);
                this.originalPos2SumCutMap.put(lastEnd, cutSum);
                lastBegin = begin;
                sb.append(cas.getDocumentText().substring(lastEnd, begin));
            } else if (lastEnd < 0) {
                lastBegin = begin;
                sb.append(cas.getDocumentText().substring(0, begin));
            }
            lastEnd = end;
        }
        if (lastEnd > 0) {
            int condensedPosition = lastEnd - (cutSum += lastEnd - lastBegin) + 1;
            this.condensedPos2SumCutMap.put(condensedPosition, cutSum);
            this.originalPos2SumCutMap.put(lastEnd, cutSum);
        }
        if (lastEnd == -1) {
            lastEnd = 0;
        }
        if (lastEnd < cas.getDocumentText().length()) {
            sb.append(cas.getDocumentText().substring(lastEnd, cas.getDocumentText().length()));
        }
        this.condensedText = sb.toString();
    }

    public int getOriginalOffsetForCondensedOffset(int condensedOffset) {
        if (this.condensedPos2SumCutMap == null) {
            return condensedOffset;
        }
        Map.Entry<Integer, Integer> floorEntry = this.condensedPos2SumCutMap.floorEntry(condensedOffset);
        return condensedOffset + floorEntry.getValue();
    }

    public int getCondensedOffsetForOriginalOffset(int originalOffset) {
        if (this.originalPos2SumCutMap == null) {
            return originalOffset;
        }
        Map.Entry<Integer, Integer> floorEntry = this.originalPos2SumCutMap.floorEntry(originalOffset);
        return originalOffset - floorEntry.getValue();
    }

    public String getCodensedText() {
        return this.condensedText != null ? this.condensedText : this.cas.getDocumentText();
    }
}

