/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility;

import de.julielab.jcore.types.Header;
import de.julielab.jcore.utility.JCoReUtilitiesException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCoReTools {
    private static final Logger log = LoggerFactory.getLogger(JCoReTools.class);
    public static final int DEFAULT_ADDITION_SIZE = 10;

    public static FSArray addToFSArray(FSArray array, FeatureStructure newElement) {
        return JCoReTools.addToFSArray(array, newElement, 10);
    }

    public static FSArray addToFSArray(FSArray array, FeatureStructure newElement, int additionSize) {
        int lastElementIndex;
        assert (additionSize > 0);
        FSArray outputArray = array;
        if (outputArray == null) {
            try {
                outputArray = new FSArray(newElement.getCAS().getJCas(), 1);
            }
            catch (CASException e1) {
                throw new JCoReUtilitiesException(e1);
            }
        }
        if (outputArray.get(lastElementIndex = outputArray.size() - 1) != null) {
            log.trace("Last element of passed array was not null, thus array is full and a new one is created.");
            try {
                FSArray array2 = new FSArray(outputArray.getCAS().getJCas(), outputArray.size() + additionSize);
                array2.copyFromArray(outputArray.toArray(), 0, 0, outputArray.size());
                array2.set(lastElementIndex + 1, newElement);
                outputArray = array2;
                log.trace("New array is of size {}.", (Object)array2.size());
                return array2;
            }
            catch (CASException e) {
                e.printStackTrace();
            }
        } else {
            log.trace("There is still room left over in the passed array, new element is appended after the last non-null element.");
        }
        while (lastElementIndex > 0 && outputArray.get(lastElementIndex - 1) == null) {
            --lastElementIndex;
        }
        log.trace("Last non-null element was found on index {}, adding new element on position {}.", (Object)(lastElementIndex - 1), (Object)lastElementIndex);
        outputArray.set(lastElementIndex, newElement);
        return outputArray;
    }

    public static FSArray addToFSArray(FSArray inputArray, Collection<? extends FeatureStructure> newElements) {
        FSArray array = inputArray;
        if (newElements == null || newElements.size() == 0) {
            return array;
        }
        if (array == null) {
            try {
                array = new FSArray(newElements.iterator().next().getCAS().getJCas(), 1);
            }
            catch (CASException e1) {
                throw new JCoReUtilitiesException(e1);
            }
        }
        try {
            int lastElementIndex = array.size() - 1;
            while (lastElementIndex >= 0 && array.get(lastElementIndex) == null) {
                --lastElementIndex;
            }
            FSArray ret = null;
            int requiredSpace = lastElementIndex + 1 + newElements.size();
            if (requiredSpace <= array.size()) {
                log.trace("Existing array has size {}. Since space for {} elements is required the passed array is kept.", (Object)array.size(), (Object)requiredSpace);
                ret = array;
            } else {
                log.trace("Passed array has size {} but there are {} elements overall, thus a new FSArray is created.", (Object)array.size(), (Object)requiredSpace);
                ret = new FSArray(array.getCAS().getJCas(), requiredSpace);
                int i = 0;
                while (i <= lastElementIndex) {
                    ret.set(i, array.get(i));
                    ++i;
                }
            }
            int currentIndex = lastElementIndex + 1;
            Iterator<? extends FeatureStructure> it = newElements.iterator();
            while (it.hasNext()) {
                ret.set(currentIndex, it.next());
                ++currentIndex;
            }
            return ret;
        }
        catch (CASException e) {
            throw new RuntimeException(e);
        }
    }

    public static FSArray copyFSArray(FSArray array) {
        FSArray output = null;
        try {
            output = new FSArray(array.getCAS().getJCas(), array.size());
            int i = 0;
            while (i < array.size()) {
                output.set(i, array.get(i));
                ++i;
            }
        }
        catch (CASException e) {
            throw new JCoReUtilitiesException(e);
        }
        return output;
    }

    public static StringArray addToStringArray(StringArray array, String element, JCas jcas) {
        try {
            StringArray newArray = null;
            if (array == null) {
                newArray = new StringArray(jcas, 1);
            } else {
                newArray = new StringArray(array.getCAS().getJCas(), array.size() + 1);
                newArray.copyFromArray(array.toArray(), 0, 0, array.size());
            }
            newArray.set(newArray.size() - 1, element);
            return newArray;
        }
        catch (CASException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StringArray addToStringArray(StringArray array, String[] elements, JCas jcas) {
        if (elements == null) {
            return null;
        }
        try {
            StringArray newArray = null;
            if (array == null) {
                newArray = new StringArray(jcas, elements.length);
                newArray.copyFromArray(elements, 0, 0, elements.length);
            } else {
                newArray = new StringArray(array.getCAS().getJCas(), array.size() + elements.length);
                newArray.copyFromArray(array.toArray(), 0, 0, array.size());
                newArray.copyFromArray(elements, 0, array.size(), elements.length);
            }
            return newArray;
        }
        catch (CASException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void printFSArray(FSArray array) {
        int i = 0;
        while (i < array.size()) {
            FeatureStructure fs = array.get(i);
            System.out.println("fs[" + i + "] =  " + fs);
            ++i;
        }
    }

    public static String getPubmedId(JCas aJCas) {
        AnnotationIndex headerIndex = aJCas.getAnnotationIndex(Header.type);
        Header header = (Header)headerIndex.iterator().next();
        String pubmedId = header.getDocId();
        return pubmedId;
    }

    public static CollectionReader getCollectionReader(String readerDescriptor) {
        CollectionReader collectionReader = null;
        try {
            CollectionReaderDescription readerDescription = UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(readerDescriptor));
            collectionReader = UIMAFramework.produceCollectionReader((ResourceSpecifier)readerDescription);
        }
        catch (IOException | InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        return collectionReader;
    }
}

