/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.txt;

import de.julielab.jcore.consumer.txt.IOUtils;
import de.julielab.jcore.types.Header;
import de.julielab.jcore.types.POSTag;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentenceTokenConsumer
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentenceTokenConsumer.class);
    public static final String PARAM_OUTPUT_DIR = "outDirectory";
    public static final String PARAM_DELIMITER = "delimiter";
    public static final String PARAM_MODE = "mode";
    public static final String PARAM_GZIP = "gzip";
    private static final String DEFAULT_DELIMITER = "";
    private static final boolean DEFAULT_PARAM_POS_TAG = false;
    @ConfigurationParameter(name="outDirectory", mandatory=true)
    private File directory;
    int docs = 0;
    @ConfigurationParameter(name="delimiter", mandatory=false)
    private String delimiter;
    @ConfigurationParameter(name="mode", mandatory=false, description="Possible values: TOKEN and DOCUMENT. The first prints out tokens with one sentence per line, the second just prints out the CAS document text without changing it in any way.")
    private Mode mode;
    @ConfigurationParameter(name="gzip", mandatory=false, defaultValue={"false"})
    private Boolean gzip;
    private boolean addPOSTAG;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        LOGGER.info("INITIALIZING TXT Consumer ...");
        String dirName = (String)aContext.getConfigParameterValue(PARAM_OUTPUT_DIR);
        this.directory = new File(dirName);
        if (!this.directory.exists()) {
            this.directory.mkdir();
        }
        LOGGER.info("Writing txt files to output directory '" + this.directory + "'");
        this.delimiter = (String)aContext.getConfigParameterValue(PARAM_DELIMITER);
        if (this.delimiter == null) {
            this.delimiter = DEFAULT_DELIMITER;
        }
        this.gzip = (Boolean)aContext.getConfigParameterValue(PARAM_GZIP);
        if (this.gzip == null) {
            this.gzip = false;
        }
        if (aContext.getConfigParameterValue(PARAM_DELIMITER) != null) {
            this.addPOSTAG = true;
            LOGGER.info("Adding POSTags ...");
        } else {
            this.addPOSTAG = false;
        }
        String mode = (String)aContext.getConfigParameterValue(PARAM_MODE);
        if (mode == null) {
            mode = Mode.TOKEN.name();
        }
        this.mode = Mode.valueOf(mode);
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LOGGER.trace("Processing next document ... ");
        try {
            String fileId = this.getDocID(jcas);
            if (fileId == null) {
                fileId = new Integer(this.docs++).toString();
            }
            if (this.mode == Mode.TOKEN) {
                FSIterator sentenceIterator = jcas.getAnnotationIndex(Sentence.type).iterator();
                AnnotationIndex tokenIndex = jcas.getAnnotationIndex(Token.type);
                ArrayList<String> sentences = new ArrayList<String>();
                while (sentenceIterator.hasNext()) {
                    Sentence sentence = (Sentence)sentenceIterator.next();
                    FSIterator tokIterator = tokenIndex.subiterator((AnnotationFS)sentence);
                    String sentenceText = DEFAULT_DELIMITER;
                    while (tokIterator.hasNext()) {
                        if (this.addPOSTAG) {
                            sentenceText = this.returnWithPOSTAG(tokIterator, sentenceText);
                            continue;
                        }
                        sentenceText = this.returnWithoutPOSTAG(tokIterator, sentenceText);
                    }
                    sentences.add(sentenceText);
                }
                this.writeSentences2File(fileId, sentences);
            } else if (this.mode == Mode.DOCUMENT) {
                File outputFile = new File(this.directory.getCanonicalPath() + File.separator + fileId + ".txt" + (this.gzip != false ? ".gz" : DEFAULT_DELIMITER));
                LOGGER.trace("Writing the verbatim CAS document text to {}", (Object)outputFile);
                IOUtils.arraylist_to_file(Arrays.asList(jcas.getDocumentText()), outputFile);
            }
        }
        catch (CASRuntimeException e) {
            e.printStackTrace();
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String returnWithoutPOSTAG(FSIterator tokIterator, String sentenceText) {
        Token token = (Token)tokIterator.next();
        String tokenText = token.getCoveredText();
        sentenceText = sentenceText.equals(DEFAULT_DELIMITER) ? tokenText : sentenceText + " " + tokenText;
        return sentenceText;
    }

    private String returnWithPOSTAG(FSIterator tokIterator, String sentenceText) {
        Token token = (Token)tokIterator.next();
        String tokenText = token.getCoveredText();
        POSTag posTag = null;
        FSArray postags = token.getPosTag();
        if (postags != null && postags.size() > 0) {
            posTag = (POSTag)postags.get(0);
        }
        String postagText = posTag.getValue();
        sentenceText = sentenceText.equals(DEFAULT_DELIMITER) ? tokenText + this.delimiter + postagText : sentenceText + " " + tokenText + this.delimiter + postagText;
        return sentenceText;
    }

    public String getDocID(JCas jcas) throws CASException {
        String docID = null;
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        for (Header h : indexes.getAnnotationIndex(Header.type)) {
            docID = h.getDocId();
        }
        return docID;
    }

    private void writeSentences2File(String fileId, ArrayList<String> sentences) {
        try {
            IOUtils.arraylist_to_file(sentences, new File(this.directory.getCanonicalPath() + File.separator + fileId + ".txt" + (this.gzip != false ? ".gz" : DEFAULT_DELIMITER)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static enum Mode {
        TOKEN,
        DOCUMENT;

    }
}

