/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.topics;

import de.julielab.java.utilities.FileUtilities;
import de.julielab.jcore.types.DocumentTopics;
import de.julielab.jcore.types.Header;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Topics Writer", description="Writes the topic weights, given the jcore-topic-indexing-ae running before, into a simple text file. Thus, the output consists of a sequency of double numbers encodes as strings, separated by tab characters. The topic ID is just the 0-based index of each number, from left to right in the written file. The first entry of each file is the document ID.")
@TypeCapability(inputs={"de.julielab.jcore.types.DocumentTopics"})
public class TopicsWriter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUT_DIR = "OutputDirectory";
    private static final Logger log = LoggerFactory.getLogger(TopicsWriter.class);
    private static int currentConsumerNumber = 0;
    @ConfigurationParameter(name="OutputDirectory", description="The directory to place the files into that contain topic weight assignments for the documents. For corpora larger than a few hundred documents, or even then, multiple files will be written, each containing a batch of document weights. At the end of processing, all these files can just be concatenated to get one large file with the topic weights of all documents.")
    private File outputDirectory;
    private String pid;
    private String hostName;
    private int consumerNumber;
    private Map<String, List<String>> outputCache = new HashMap<String, List<String>>();
    private int docNum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        this.outputDirectory = new File((String)aContext.getConfigParameterValue(PARAM_OUTPUT_DIR));
        this.pid = this.getPID();
        this.hostName = this.getHostName();
        String string = PARAM_OUTPUT_DIR;
        synchronized (PARAM_OUTPUT_DIR) {
            this.consumerNumber = currentConsumerNumber++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.docNum = 0;
            return;
        }
    }

    public void process(JCas aJCas) {
        String docId;
        Collection documentTopicAnnotations = JCasUtil.select((JCas)aJCas, DocumentTopics.class);
        try {
            docId = ((Header)JCasUtil.selectSingle((JCas)aJCas, Header.class)).getDocId();
        }
        catch (IllegalArgumentException e) {
            docId = "doc" + this.docNum;
        }
        for (DocumentTopics topics : documentTopicAnnotations) {
            String modelID = topics.getModelID();
            String modelVersion = topics.getModelVersion();
            String mapKey = modelID + "-" + modelVersion;
            List cacheForModel = this.outputCache.compute(mapKey, (key, list) -> list != null ? list : new ArrayList());
            String cacheLine = Stream.concat(Stream.of(docId), Arrays.stream(topics.getWeights().toArray()).mapToObj(String::valueOf)).collect(Collectors.joining("\t"));
            cacheForModel.add(cacheLine);
        }
        ++this.docNum;
    }

    public void batchProcessComplete() throws AnalysisEngineProcessException {
        super.batchProcessComplete();
        try {
            this.writeCache();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        try {
            this.writeCache();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private void writeCache() throws IOException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        for (String mapKey : this.outputCache.keySet()) {
            File file = new File(this.outputDirectory.getAbsolutePath() + File.separator + mapKey + "-" + this.hostName + "-" + this.pid + "-writer" + currentConsumerNumber + ".gz");
            BufferedWriter bw = FileUtilities.getWriterToFile((File)file);
            Throwable throwable = null;
            try {
                List<String> lines = this.outputCache.get(mapKey);
                for (String line : lines) {
                    bw.write(line);
                    bw.newLine();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bw == null) continue;
                if (throwable != null) {
                    try {
                        bw.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                bw.close();
            }
        }
    }

    private String getPID() {
        String id = ManagementFactory.getRuntimeMXBean().getName();
        return id.substring(0, id.indexOf(64));
    }

    private String getHostName() {
        String hostName;
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostName = address.getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
        return hostName;
    }
}

