/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.topicindexing;

import de.julielab.jcore.ae.topicindexing.ITopicModelProvider;
import de.julielab.topicmodeling.businessobjects.Model;
import de.julielab.topicmodeling.businessobjects.Topic;
import de.julielab.topicmodeling.services.MalletTopicModeling;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicModelProvider
implements ITopicModelProvider {
    private static final Logger log = LoggerFactory.getLogger(TopicModelProvider.class);
    private Model model;
    private File modelFile;
    private String modelSavePath;
    private boolean saveAllowed;
    private MalletTopicModeling tm;
    private int numTopicWords;
    private Object[][] topicWords;

    public void load(DataResource dataResource) throws ResourceInitializationException {
        this.modelFile = new File(dataResource.getUri());
        this.tm = new MalletTopicModeling();
        this.model = this.tm.readModel(this.modelFile.getAbsolutePath());
        if (this.model.pubmedIdModelId == null || this.model.pubmedIdModelId.isEmpty()) {
            this.model.pubmedIdModelId = new HashMap();
            for (Integer malletId : this.model.ModelIdpubmedId.keySet()) {
                this.model.pubmedIdModelId.put((String)this.model.ModelIdpubmedId.get(malletId), malletId);
            }
        }
        this.model.index = new HashMap();
        this.saveAllowed = true;
    }

    @Override
    public synchronized Object[][] getTopWords(int numwords) {
        if (numwords > this.numTopicWords) {
            this.topicWords = this.model.malletModel.getTopWords(numwords);
            this.numTopicWords = numwords;
        }
        return this.topicWords;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void setModelSavePath(String path) {
        if (this.modelSavePath != null && !this.modelSavePath.equals(path)) {
            throw new IllegalStateException("The model path is already set to \"" + this.modelSavePath + "\". The current call wants to set the path to \"" + this.modelSavePath + "\". This points to a programming error.");
        }
        this.modelSavePath = path;
    }

    @Override
    public void allowSave() {
        this.saveAllowed = true;
    }

    @Override
    public synchronized void saveModel() throws IOException {
        if (this.saveAllowed) {
            try {
                String filename = this.modelFile.getAbsolutePath() + "-" + InetAddress.getLocalHost().getHostName() + "-" + ManagementFactory.getRuntimeMXBean().getName();
                this.tm.saveModel(this.model, filename);
                log.info("Model with index of size {} is written to: {}", (Object)this.model.index.size(), (Object)filename);
            }
            catch (UnknownHostException e) {
                throw new IOException(e);
            }
            this.saveAllowed = false;
        }
    }

    @Override
    public synchronized void addToIndex(String docId, List<Topic> topicList) {
        this.model.index.put(docId, topicList);
    }
}

