/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.stanford.lemma;

import de.julielab.jcore.types.Lemma;
import de.julielab.jcore.types.POSTag;
import de.julielab.jcore.types.Token;
import edu.stanford.nlp.process.Morphology;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StanfordLemmatizer
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(StanfordLemmatizer.class);
    Morphology lemmatizer = new Morphology();

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        LOGGER.debug("[JCoRe Stanford Lemmatizer] processing document ...");
        for (Token token : aJCas.getAnnotationIndex(Token.type)) {
            int start = token.getBegin();
            int end = token.getEnd();
            String tokenStr = token.getCoveredText();
            String posTagStr = null;
            FSArray posTagArray = token.getPosTag();
            if (posTagArray == null || posTagArray.size() <= 0) continue;
            int i = 0;
            while (i < posTagArray.size()) {
                POSTag posTag = (POSTag)posTagArray.get(i);
                if (posTag != null) {
                    posTagStr = posTag.getValue();
                }
                ++i;
            }
            String lemmaStr = this.lemmatizer.lemma(tokenStr, posTagStr);
            Lemma lemma = new Lemma(aJCas);
            lemma.setBegin(start);
            lemma.setEnd(end);
            lemma.setValue(lemmaStr);
            lemma.setComponentId(((Object)((Object)this)).getClass().getName());
            token.setLemma(lemma);
        }
    }
}

