/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pubtator;

import de.julielab.java.utilities.FileUtilities;
import de.julielab.jcore.reader.pubtator.PubtatorDocument;
import de.julielab.jcore.reader.pubtator.PubtatorEntity;
import de.julielab.jcore.types.AbstractText;
import de.julielab.jcore.types.Chemical;
import de.julielab.jcore.types.Disease;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.Gene;
import de.julielab.jcore.types.GeneResourceEntry;
import de.julielab.jcore.types.Header;
import de.julielab.jcore.types.Organism;
import de.julielab.jcore.types.Title;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;

public class PubtatorReader
extends CollectionReader_ImplBase {
    private static final String COMPONENT_NAME = PubtatorReader.class.getCanonicalName();
    public static final String PARAM_INPUT = "Input";
    public static final String PARAM_ADD_ENTITIES = "AddEntities";
    @ConfigurationParameter(name="Input", mandatory=true)
    private File input;
    @ConfigurationParameter(name="AddEntities", mandatory=false)
    private boolean addEntities;
    private File[] inputFiles;
    private BufferedReader currentReader;
    private PubtatorDocument currentDocument = PubtatorDocument.EMPTY_DOCUMENT;
    private int index;
    private long completed = 0L;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        String inputDirectoryPath = (String)this.getConfigParameterValue(PARAM_INPUT);
        this.input = new File(inputDirectoryPath);
        this.addEntities = (Boolean)Optional.ofNullable(this.getConfigParameterValue(PARAM_ADD_ENTITIES)).orElseGet(() -> true);
        if (!this.input.exists()) {
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException("The path " + this.input.getAbsolutePath() + " does not exist."));
        }
        this.inputFiles = this.input.isDirectory() ? this.input.listFiles((f, s) -> s.endsWith(".txt") || s.endsWith(".txt.gz") || s.endsWith(".txt.gzip")) : new File[]{this.input};
        this.index = 0;
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        if (this.hasNext()) {
            try {
                JCas jcas = aCAS.getJCas();
                Header header = new Header(jcas);
                header.setDocId(this.currentDocument.getDocumentId());
                header.addToIndexes();
                jcas.setDocumentText(this.currentDocument.getTitle() + "\n" + this.currentDocument.getAbstractText());
                Title title = new Title(jcas, 0, this.currentDocument.getTitle().length());
                title.setTitleType("document");
                title.setComponentId(COMPONENT_NAME);
                title.addToIndexes();
                AbstractText abstractText = new AbstractText(jcas, title.getEnd() + 1, title.getEnd() + 1 + this.currentDocument.getAbstractText().length());
                abstractText.setComponentId(COMPONENT_NAME);
                abstractText.addToIndexes();
                if (this.addEntities) {
                    for (PubtatorEntity e : this.currentDocument.getEntities()) {
                        Disease a;
                        switch (e.getEntityType()) {
                            case "Chemical": {
                                Chemical chemical = new Chemical(jcas);
                                chemical.setNameOfSubstance(e.getText());
                                chemical.setRegistryNumber(e.getEntityId());
                                a = chemical;
                                break;
                            }
                            case "Disease": {
                                a = new Disease(jcas);
                                break;
                            }
                            case "Gene": {
                                Gene g = new Gene(jcas);
                                GeneResourceEntry geneResourceEntry = new GeneResourceEntry(jcas, e.getBegin(), e.getEnd());
                                geneResourceEntry.setEntryId(e.getEntityId());
                                geneResourceEntry.setSource("NCBI Gene");
                                FSArray geneEntryList = new FSArray(jcas, 1);
                                geneEntryList.set(0, (FeatureStructure)geneResourceEntry);
                                g.setResourceEntryList(geneEntryList);
                                a = g;
                                break;
                            }
                            case "Species": {
                                Organism o = new Organism(jcas);
                                GeneResourceEntry organismResourceEntry = new GeneResourceEntry(jcas, e.getBegin(), e.getEnd());
                                organismResourceEntry.setEntryId(e.getEntityId());
                                organismResourceEntry.setSource("NCBI Taxonomy");
                                FSArray organismEntryList = new FSArray(jcas, 1);
                                organismEntryList.set(0, (FeatureStructure)organismResourceEntry);
                                o.setResourceEntryList(organismEntryList);
                                a = o;
                                break;
                            }
                            default: {
                                EntityMention em = new EntityMention(jcas);
                                a = em;
                            }
                        }
                        if (a instanceof EntityMention) {
                            ((EntityMention)a).setSpecificType(e.getEntityType());
                        }
                        a.setBegin(e.getBegin());
                        a.setEnd(e.getEnd());
                        a.setComponentId(COMPONENT_NAME);
                        a.addToIndexes();
                    }
                }
            }
            catch (CASException e) {
                throw new CollectionException((Throwable)e);
            }
            this.currentDocument = PubtatorDocument.EMPTY_DOCUMENT;
            ++this.completed;
        }
    }

    public boolean hasNext() throws IOException, CollectionException {
        if (this.currentReader == null && this.index < this.inputFiles.length) {
            this.currentReader = FileUtilities.getReaderFromFile((File)this.inputFiles[this.index]);
        }
        if (this.currentDocument == PubtatorDocument.EMPTY_DOCUMENT) {
            this.currentDocument = PubtatorDocument.parseNextDocument(this.currentReader);
        }
        while (this.currentDocument == PubtatorDocument.EMPTY_DOCUMENT && this.index < this.inputFiles.length) {
            ++this.index;
            if (this.index >= this.inputFiles.length) continue;
            this.currentReader = FileUtilities.getReaderFromFile((File)this.inputFiles[this.index]);
            this.currentDocument = PubtatorDocument.parseNextDocument(this.currentReader);
        }
        return this.currentDocument != PubtatorDocument.EMPTY_DOCUMENT;
    }

    public Progress[] getProgress() {
        return new Progress[]{new Progress(){

            public long getCompleted() {
                return PubtatorReader.this.completed;
            }

            public long getTotal() {
                return 0L;
            }

            public String getUnit() {
                return "Documents";
            }

            public boolean isApproximate() {
                return true;
            }
        }};
    }

    public void close() throws IOException {
    }
}

