/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc.parser;

import com.ximpleware.NavException;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.jcore.reader.pmc.parser.DefaultElementParser;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingResult;
import de.julielab.jcore.reader.pmc.parser.NxmlDocumentParser;
import de.julielab.jcore.types.pubmed.InternalReference;
import java.util.Optional;
import org.apache.uima.jcas.tcas.Annotation;

public class XRefParser
extends DefaultElementParser {
    public XRefParser(NxmlDocumentParser nxmlDocumentParser) {
        super(nxmlDocumentParser);
        this.elementName = "xref";
    }

    @Override
    protected void parseElement(ElementParsingResult result) throws ElementParsingException {
        try {
            Optional<String> refType = this.getXPathValue("@ref-type");
            Optional<String> elementId = this.getXPathValue("@id");
            Optional<String> referencedId = this.getXPathValue("@rid");
            super.parseElement(result);
            InternalReference reference = new InternalReference(this.nxmlDocumentParser.cas);
            refType.ifPresent(t -> reference.setReftype(this.getJCoReReferenceType((String)t)));
            elementId.ifPresent(arg_0 -> ((InternalReference)reference).setId(arg_0));
            referencedId.ifPresent(arg_0 -> ((InternalReference)reference).setRefid(arg_0));
            result.setAnnotation((Annotation)reference);
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new ElementParsingException(e);
        }
    }

    private String getJCoReReferenceType(String pmcType) {
        switch (pmcType) {
            case "aff": {
                return "affiliation";
            }
            case "app": {
                return "appendix";
            }
            case "author-notes": {
                return "authornotes";
            }
            case "bibr": {
                return "bibliography";
            }
            case "boxed-text": {
                return "textbox";
            }
            case "chem": {
                return "chemical";
            }
            case "contrib": {
                return "contributor";
            }
            case "corresp": {
                return "correspondingauthor";
            }
            case "disp-formula": {
                return "displayformula";
            }
            case "fig": {
                return "figure";
            }
            case "fn": {
                return "footnote";
            }
            case "kwd": {
                return "keyword";
            }
            case "list": {
                return "list";
            }
            case "other": {
                return "other";
            }
            case "plate": {
                return "plate";
            }
            case "scheme": {
                return "scheme";
            }
            case "sec": {
                return "section";
            }
            case "statement": {
                return "statement";
            }
            case "supplementary-material": {
                return "supplementary";
            }
            case "table": {
                return "table";
            }
            case "table-fn": {
                return "tablefootnote";
            }
        }
        return "other";
    }
}

