/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc.parser;

import com.ximpleware.NavException;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.jcore.reader.pmc.PMCReader;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingResult;
import de.julielab.jcore.reader.pmc.parser.NxmlDocumentParser;
import de.julielab.jcore.reader.pmc.parser.NxmlElementParser;
import de.julielab.jcore.reader.pmc.parser.ParsingResult;
import de.julielab.jcore.types.AbstractSection;
import de.julielab.jcore.types.AbstractText;
import de.julielab.jcore.types.AuthorInfo;
import de.julielab.jcore.types.Date;
import de.julielab.jcore.types.Journal;
import de.julielab.jcore.types.Keyword;
import de.julielab.jcore.types.Title;
import de.julielab.jcore.types.pubmed.Header;
import de.julielab.jcore.types.pubmed.ManualDescriptor;
import de.julielab.jcore.types.pubmed.OtherID;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;

public class FrontParser
extends NxmlElementParser {
    public FrontParser(NxmlDocumentParser nxmlDocumentParser) {
        super(nxmlDocumentParser);
        this.elementName = "front";
    }

    @Override
    protected void parseElement(ElementParsingResult frontResult) throws ElementParsingException {
        try {
            this.parseXPath("/article/front/article-meta/title-group/article-title").ifPresent(r -> {
                ElementParsingResult er = (ElementParsingResult)r;
                Title articleTitle = (Title)er.getAnnotation();
                articleTitle.setTitleType("document");
                frontResult.addSubResult((ParsingResult)r);
            });
            this.parseXPath("/article/front/article-meta/abstract").ifPresent(r -> {
                ElementParsingResult er = (ElementParsingResult)r;
                AbstractText abstractText = (AbstractText)er.getAnnotation();
                List<AbstractSection> abstractSections = er.getSubResultAnnotations(AbstractSection.class);
                FSArray fsArray = new FSArray(this.nxmlDocumentParser.cas, abstractSections.size());
                IntStream.range(0, abstractSections.size()).forEach(i -> fsArray.set(i, (FeatureStructure)abstractSections.get(i)));
                abstractText.setStructuredAbstractParts(fsArray);
                frontResult.addSubResult((ParsingResult)r);
            });
            Optional<String> pmid = this.getXPathValue("/article/front/article-meta/article-id[@pub-id-type='pmid']");
            Optional<String> pmcid = this.getXPathValue("/article/front/article-meta/article-id[@pub-id-type='pmc']");
            Optional<String> doi = this.getXPathValue("/article/front/article-meta/article-id[@pub-id-type='doi']");
            String pubType = "";
            String pubDateFmt = "/article/front/article-meta/pub-date[@pub-type='%s']";
            if (this.xPathExists(String.format(pubDateFmt, "epub"))) {
                pubType = "epub";
            } else if (this.xPathExists(String.format(pubDateFmt, "ppub"))) {
                pubType = "ppub";
            } else if (this.xPathExists(String.format(pubDateFmt, "pmc-release"))) {
                pubType = "pmc-release";
            }
            Optional<String> year = this.getXPathValue(String.format("/article/front/article-meta/pub-date[@pub-type='%s']/year", pubType));
            Optional<String> month = this.getXPathValue(String.format("/article/front/article-meta/pub-date[@pub-type='%s']/month", pubType));
            Optional<String> day = this.getXPathValue(String.format("/article/front/article-meta/pub-date[@pub-type='%s']/day", pubType));
            Optional<String> journalTitle = this.nxmlDocumentParser.getTagset() == NxmlDocumentParser.Tagset.NLM_2_3 ? this.getXPathValue("/article/front/journal-meta/journal-title") : this.getXPathValue("/article/front/journal-meta/journal-title-group/journal-title");
            Optional<String> abbrevJournalTitle = this.nxmlDocumentParser.getTagset() == NxmlDocumentParser.Tagset.NLM_2_3 ? this.getXPathValue("/article/front/journal-meta/abbrev-journal-title") : this.getXPathValue("/article/front/journal-meta/journal-title-group/abbrev-journal-title");
            Optional<String> volume = this.getXPathValue("/article/front/article-meta/volume");
            Optional<String> issue = this.getXPathValue("/article/front/article-meta/issue");
            Optional<String> firstPage = this.getXPathValue("/article/front/article-meta/fpage");
            Optional<String> lastPage = this.getXPathValue("/article/front/article-meta/lpage");
            Optional<String> elocation = this.getXPathValue("/article/front/article-meta/elocation-id");
            Optional<String> issn = this.getXPathValue("/article/front/journal-meta/issn[@pub-type='ppub']");
            Optional<String> copyrightStatement = this.getXPathValue("/article/front/article-meta/permissions/copyright-statement");
            Optional<List<String>> keywords = this.getXPathValues("/article/front/article-meta/kwd-group/kwd");
            assert (volume.isPresent());
            Header header = new Header(this.nxmlDocumentParser.cas);
            header.setComponentId(PMCReader.class.getName());
            pmcid.ifPresent(arg_0 -> ((Header)header).setDocId(arg_0));
            pmid.ifPresent(p -> {
                OtherID otherID = new OtherID(this.nxmlDocumentParser.cas);
                otherID.setComponentId(PMCReader.class.getName());
                otherID.setId(p);
                otherID.setSource("PubMed");
                FSArray otherIDs = new FSArray(this.nxmlDocumentParser.cas, 1);
                otherIDs.set(0, (FeatureStructure)otherID);
                header.setOtherIDs(otherIDs);
            });
            doi.ifPresent(arg_0 -> ((Header)header).setDoi(arg_0));
            copyrightStatement.ifPresent(arg_0 -> ((Header)header).setCopyright(arg_0));
            Journal journal = new Journal(this.nxmlDocumentParser.cas);
            journal.setComponentId(PMCReader.class.getName());
            journalTitle.ifPresent(arg_0 -> ((Journal)journal).setTitle(arg_0));
            abbrevJournalTitle.ifPresent(arg_0 -> ((Journal)journal).setShortTitle(arg_0));
            volume.ifPresent(arg_0 -> ((Journal)journal).setVolume(arg_0));
            issue.ifPresent(arg_0 -> ((Journal)journal).setIssue(arg_0));
            issn.ifPresent(arg_0 -> ((Journal)journal).setISSN(arg_0));
            Object pages = null;
            if (firstPage.isPresent() && lastPage.isPresent()) {
                pages = firstPage.get() + "--" + lastPage.get();
            } else if (firstPage.isPresent()) {
                pages = firstPage.get();
            } else if (elocation.isPresent()) {
                pages = elocation.get();
            }
            journal.setPages((String)pages);
            FSArray pubTypes = new FSArray(this.nxmlDocumentParser.cas, 1);
            pubTypes.set(0, (FeatureStructure)journal);
            Date pubDate = new Date(this.nxmlDocumentParser.cas);
            pubDate.setComponentId(PMCReader.class.getName());
            day.map(Integer::parseInt).ifPresent(arg_0 -> ((Date)pubDate).setDay(arg_0));
            month.map(Integer::parseInt).ifPresent(arg_0 -> ((Date)pubDate).setMonth(arg_0));
            year.map(Integer::parseInt).ifPresent(arg_0 -> ((Date)pubDate).setYear(arg_0));
            journal.setPubDate(pubDate);
            header.setPubTypeList(pubTypes);
            this.parseXPath("/article/front/article-meta/contrib-group").map(ElementParsingResult.class::cast).ifPresent(r -> {
                List authors = r.getSubResults().stream().map(ElementParsingResult.class::cast).map(e -> e.getAnnotation()).filter(AuthorInfo.class::isInstance).map(AuthorInfo.class::cast).collect(Collectors.toList());
                FSArray aiArray = new FSArray(this.nxmlDocumentParser.cas, authors.size());
                IntStream.range(0, authors.size()).forEach(i -> aiArray.set(i, (FeatureStructure)authors.get(i)));
                if (aiArray.size() > 0) {
                    header.setAuthors(aiArray);
                }
            });
            frontResult.setAnnotation((Annotation)header);
            if (keywords.isPresent()) {
                List<String> keywordList = keywords.get();
                FSArray fsArray = new FSArray(this.nxmlDocumentParser.cas, keywordList.size());
                IntStream.range(0, keywordList.size()).forEach(i -> {
                    Keyword keyword = new Keyword(this.nxmlDocumentParser.cas);
                    keyword.setComponentId(PMCReader.class.getName());
                    keyword.setName((String)keywordList.get(i));
                    fsArray.set(i, (FeatureStructure)keyword);
                });
                ManualDescriptor manualDescriptor = new ManualDescriptor(this.nxmlDocumentParser.cas);
                manualDescriptor.setComponentId(PMCReader.class.getName());
                manualDescriptor.setKeywordList(fsArray);
                manualDescriptor.addToIndexes();
            }
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new ElementParsingException(e);
        }
    }
}

