/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc.parser;

import com.ximpleware.NavException;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.jcore.reader.pmc.PMCReader;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingResult;
import de.julielab.jcore.reader.pmc.parser.NxmlDocumentParser;
import de.julielab.jcore.reader.pmc.parser.NxmlElementParser;
import de.julielab.jcore.reader.pmc.parser.ParsingResult;
import de.julielab.jcore.types.Caption;
import de.julielab.jcore.types.Figure;
import de.julielab.jcore.types.Title;
import java.util.Optional;
import org.apache.uima.jcas.tcas.Annotation;

public class FigParser
extends NxmlElementParser {
    public FigParser(NxmlDocumentParser nxmlDocumentParser) {
        super(nxmlDocumentParser);
        this.elementName = "fig";
    }

    @Override
    protected void parseElement(ElementParsingResult figResult) throws ElementParsingException {
        try {
            Optional<String> tableWrapId = this.getXPathValue("@id");
            Optional<ParsingResult> labelResult = this.parseXPath("label");
            Optional<String> labelString = this.getXPathValue("label");
            Optional<ParsingResult> captionResult = this.parseXPath("caption");
            captionResult.ifPresent(r -> {
                ElementParsingResult result = (ElementParsingResult)r;
                Caption caption = (Caption)result.getAnnotation();
                caption.setCaptionType("table");
                figResult.addSubResult((ParsingResult)r);
            });
            labelResult.ifPresent(figResult::addSubResult);
            Figure figure = new Figure(this.nxmlDocumentParser.cas);
            figure.setComponentId(PMCReader.class.getName());
            labelResult.map(l -> ((ElementParsingResult)l).getAnnotation()).map(Title.class::cast).map(t -> {
                t.setTitleType("figure");
                return t;
            }).ifPresent(arg_0 -> ((Figure)figure).setObjectTitle(arg_0));
            labelString.ifPresent(arg_0 -> ((Figure)figure).setObjectLabel(arg_0));
            captionResult.map(r -> (Caption)((ElementParsingResult)r).getAnnotation()).ifPresent(arg_0 -> ((Figure)figure).setObjectCaption(arg_0));
            tableWrapId.ifPresent(arg_0 -> ((Figure)figure).setObjectId(arg_0));
            figResult.setAnnotation((Annotation)figure);
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new ElementParsingException(e);
        }
    }
}

