/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc.parser;

import de.julielab.jcore.reader.pmc.parser.ParsingResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.uima.jcas.tcas.Annotation;

public class ElementParsingResult
extends ParsingResult {
    private Annotation annotation;
    private String elementName;
    private boolean addAnnotationToIndexes;
    private boolean blockElement;
    private boolean textBodyElement;
    private List<ParsingResult> subResults = Collections.emptyList();
    private int lastTokenIndex;

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public ElementParsingResult(String elementName, int begin, int end) {
        super(begin, end, ParsingResult.ResultType.ELEMENT);
        this.elementName = elementName;
        this.addAnnotationToIndexes = true;
        this.blockElement = false;
        this.textBodyElement = true;
    }

    public void addSubResult(ParsingResult subResult) {
        if (this.subResults.isEmpty()) {
            this.subResults = new ArrayList<ParsingResult>();
        }
        this.subResults.add(subResult);
    }

    public String getElementName() {
        return this.elementName;
    }

    public List<ParsingResult> getSubResults() {
        return this.subResults;
    }

    public void setSubResults(List<ParsingResult> subResults) {
        this.subResults = subResults;
    }

    public <T extends Annotation> List<T> getSubResultAnnotations(Class<T> annotationClass) {
        return this.subResults.stream().filter(ElementParsingResult.class::isInstance).map(ElementParsingResult.class::cast).filter(r -> r.getAnnotation() != null).filter(r -> annotationClass.isInstance(r.getAnnotation())).map(r -> r.getAnnotation()).map(annotationClass::cast).collect(Collectors.toList());
    }

    public List<ParsingResult> getSubResults(String elementName) {
        return this.subResults.stream().filter(ElementParsingResult.class::isInstance).map(ElementParsingResult.class::cast).filter(r -> r.getElementName().equals(elementName)).collect(Collectors.toList());
    }

    @Override
    public String toString(int indentLevel) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indentLevel * 2; ++i) {
            sb.append(" ");
        }
        sb.append(this.elementName);
        sb.append(":\n");
        for (ParsingResult result : this.subResults) {
            sb.append(result.toString(indentLevel + 1));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    public void setLastTokenIndex(int lastTokenIndex) {
        this.lastTokenIndex = lastTokenIndex;
    }

    public int getLastTokenIndex() {
        return this.lastTokenIndex;
    }

    public void setAddAnnotationToIndexes(boolean addToIndexes) {
        this.addAnnotationToIndexes = addToIndexes;
    }

    public boolean addAnnotationToIndexes() {
        return this.addAnnotationToIndexes;
    }

    public boolean isBlockElement() {
        return this.blockElement;
    }

    public void setBlockElement(boolean blockElement) {
        this.blockElement = blockElement;
    }

    public boolean isTextBodyElement() {
        return this.textBodyElement;
    }

    public void setTextBodyElement(boolean textBodyElement) {
        this.textBodyElement = textBodyElement;
    }

    @Override
    public String getResultText() {
        StringBuilder sb = new StringBuilder();
        for (ParsingResult result : this.subResults) {
            sb.append(result.getResultText());
        }
        return sb.toString();
    }

    public String getDirectResultText() {
        StringBuilder sb = new StringBuilder();
        for (ParsingResult result : this.subResults) {
            if (result.getResultType() != ParsingResult.ResultType.TEXT) continue;
            sb.append(result.getResultText());
        }
        return sb.toString();
    }
}

