/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc.parser;

import com.ximpleware.NavException;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.jcore.reader.pmc.PMCReader;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingResult;
import de.julielab.jcore.reader.pmc.parser.NxmlDocumentParser;
import de.julielab.jcore.reader.pmc.parser.NxmlElementParser;
import de.julielab.jcore.types.AuthorInfo;
import java.util.Optional;
import org.apache.uima.jcas.tcas.Annotation;

public class ContribParser
extends NxmlElementParser {
    public ContribParser(NxmlDocumentParser nxmlDocumentParser) {
        super(nxmlDocumentParser);
        this.elementName = "contrib";
    }

    @Override
    protected void parseElement(ElementParsingResult result) throws ElementParsingException {
        try {
            Optional<String> givenNames = this.getXPathValue("name/given-names");
            Optional<String> surname = this.getXPathValue("name/surname");
            Optional<String> affRef = this.getXPathValue("xref[@ref-type='aff']/@rid");
            Optional<String> email = this.getXPathValue("address/email");
            Optional<String> initials = this.getXPathValue("name/given-names/@initials");
            AuthorInfo ai = new AuthorInfo(this.nxmlDocumentParser.cas);
            ai.setComponentId(PMCReader.class.getName());
            givenNames.ifPresent(arg_0 -> ((AuthorInfo)ai).setForeName(arg_0));
            surname.ifPresent(arg_0 -> ((AuthorInfo)ai).setLastName(arg_0));
            initials.ifPresent(arg_0 -> ((AuthorInfo)ai).setInitials(arg_0));
            affRef.ifPresent(arg_0 -> ((AuthorInfo)ai).setAffiliation(arg_0));
            email.ifPresent(arg_0 -> ((AuthorInfo)ai).setContact(arg_0));
            result.setAnnotation((Annotation)ai);
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new ElementParsingException(e);
        }
    }
}

