/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc;

import de.julielab.jcore.reader.pmc.UncheckedPmcReaderException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NXMLURIIterator
implements Iterator<URI> {
    private static final Logger log = LoggerFactory.getLogger(NXMLURIIterator.class);
    private static final Logger logFileSearch = LoggerFactory.getLogger((String)(NXMLURIIterator.class.getCanonicalName() + ".FileSearch"));
    private final File basePath;
    private final boolean searchRecursively;
    private final boolean searchZip;
    private BlockingQueue<URI> uris = new ArrayBlockingQueue<URI>(500);
    private URI currentUri;
    private Set<String> whitelist;
    private boolean fileSearchRunning = false;

    public NXMLURIIterator(File basePath, Set<String> whitelist, boolean searchRecursively, boolean searchZip) throws FileNotFoundException {
        HashSet<String> hashSet = this.whitelist = whitelist != null ? whitelist : new HashSet<String>(Collections.singletonList("all"));
        if (!basePath.exists()) {
            throw new FileNotFoundException("The path " + basePath.getAbsolutePath() + " does not exist.");
        }
        this.basePath = basePath;
        this.searchRecursively = searchRecursively;
        this.searchZip = searchZip;
    }

    @Override
    public boolean hasNext() {
        if (!this.fileSearchRunning) {
            log.debug("Starting background thread to search for PMC (.nxml) files at {}", (Object)this.basePath);
            CompletableFuture.runAsync(() -> this.setFilesAndSubDirectories(this.basePath, false));
            this.fileSearchRunning = true;
        }
        try {
            if (this.uris != null && this.currentUri == null) {
                log.trace("Waiting for the next URI");
                this.currentUri = this.uris.take();
                log.trace("Got URI {} from the file list. {} URIs currently remain in the queue.", (Object)this.currentUri, (Object)this.uris.size());
            }
        }
        catch (InterruptedException e) {
            log.error("Interrupted exception while waiting for the next URI from the list.");
            throw new UncheckedPmcReaderException(e);
        }
        if (this.currentUri == null || this.currentUri.toString().equals("http://nonsense.non")) {
            log.debug("Retrieved URI {}, assuming no more files available.", (Object)this.currentUri);
            this.currentUri = null;
            this.uris = null;
        }
        return this.currentUri != null;
    }

    private void setFilesAndSubDirectories(File directory, boolean recursiveCall) {
        ArrayDeque pendingSubdirs;
        block28: {
            logFileSearch.debug("Reading path {}", (Object)directory);
            pendingSubdirs = new ArrayDeque();
            logFileSearch.trace("Checking if {} is eligible for PMC file search", (Object)directory);
            if (directory.isDirectory() || this.isZipFile(directory)) {
                if ((this.searchRecursively || directory.equals(this.basePath)) && !this.isZipFile(directory)) {
                    logFileSearch.debug("Identified {} as a directory, reading files and subdirectories", (Object)directory);
                    for (File file : directory.listFiles(f -> f.isFile() && f.getName().contains(".nxml") && !this.isZipFile(f) && this.isInWhitelist(f))) {
                        URI toURI = file.toURI();
                        try {
                            this.uris.put(toURI);
                        }
                        catch (InterruptedException e) {
                            logFileSearch.error("The PMC file reading process was interrupted while trying to put the NXML file URIs of directory {} into the list", (Object)directory);
                            throw new UncheckedPmcReaderException(e);
                        }
                    }
                    Stream.of(directory.listFiles(f -> f.isDirectory())).forEach(pendingSubdirs::push);
                    if (this.searchZip) {
                        Stream.of(directory.listFiles(f -> f.isFile() && this.isZipFile(f))).forEach(pendingSubdirs::push);
                    }
                } else {
                    if (this.searchZip && this.isZipFile(directory)) {
                        logFileSearch.debug("Identified {} as a ZIP archive, retrieving its inventory", (Object)directory);
                        logFileSearch.debug("Searching ZIP archive {} for eligible documents", (Object)directory);
                        try (ZipFile zf = new ZipFile(directory);){
                            Enumeration<? extends ZipEntry> entries = zf.entries();
                            while (entries.hasMoreElements()) {
                                ZipEntry e = entries.nextElement();
                                if (e.isDirectory() || !e.getName().contains(".nxml") || !this.isInWhitelist(new File(e.getName()))) continue;
                                String urlStr = "jar:" + directory.toURI().toString() + "!/" + e.getName();
                                URL url = new URL(urlStr);
                                try {
                                    URI uri = url.toURI();
                                    logFileSearch.trace("Waiting to put URI {} into queue", (Object)uri);
                                    this.uris.put(uri);
                                    logFileSearch.trace("Successfully put URI {} into queue", (Object)uri);
                                }
                                catch (InterruptedException e1) {
                                    logFileSearch.error("Putting URI for URL {} into the queue was interrupted", (Object)url);
                                    throw new UncheckedPmcReaderException(e1);
                                }
                                catch (URISyntaxException e1) {
                                    logFileSearch.error("Could not convert URL {} to URI.", (Object)url, (Object)e);
                                }
                            }
                            break block28;
                        }
                        catch (IOException e) {
                            logFileSearch.error("Could not read from {}", (Object)directory);
                            throw new UncheckedPmcReaderException(e);
                        }
                    }
                    logFileSearch.debug("Recursive search is deactivated, skipping subdirectory {}", (Object)directory);
                }
            } else if (directory.isFile()) {
                logFileSearch.debug("Identified {} as a file, reading single file", (Object)directory);
                logFileSearch.debug("Adding file to map with key {}", (Object)directory);
                try {
                    this.uris.put(directory.toURI());
                }
                catch (InterruptedException e) {
                    logFileSearch.error("The PMC file reading process was interrupted while trying to put file URI {} into the list", (Object)directory.toURI());
                    throw new UncheckedPmcReaderException(e);
                }
            } else {
                throw new IllegalStateException("Path " + directory.getAbsolutePath() + " was identified neither a path nor a file, cannot continue. This seems to be a bug in this code.");
            }
        }
        logFileSearch.trace("Checking if subdirectories of {} are to processed for PMC file search", (Object)directory);
        while (!pendingSubdirs.isEmpty()) {
            File subdir = (File)pendingSubdirs.pop();
            logFileSearch.trace("Descending into ZIP file or directory {} in search for PMC files.", (Object)subdir);
            this.setFilesAndSubDirectories(subdir, true);
            logFileSearch.trace("Subdir or ZIP {} finished for file PMC file search.", (Object)subdir);
        }
        logFileSearch.trace("Checking whether the end signal is to be sent");
        if (!recursiveCall) {
            try {
                logFileSearch.info("Reached the end of the eligible files, background thread for file collection is giving the end-of-files signal and terminates.");
                this.uris.put(URI.create("http://nonsense.non"));
            }
            catch (InterruptedException e) {
                logFileSearch.error("The PMC file reading process was interrupted while trying to put the ending signal into the list");
                throw new UncheckedPmcReaderException(e);
            }
        }
        logFileSearch.trace("A file search method call for {} has finished. This was a {} call.", (Object)directory, (Object)(recursiveCall ? "recursive" : "non-recursive"));
    }

    private boolean isZipFile(File directory) {
        return directory.getName().toLowerCase().endsWith(".zip");
    }

    private boolean isInWhitelist(Path path) {
        return this.isInWhitelist(path.toString().substring(path.toString().lastIndexOf(47) + 1, path.toString().indexOf(46)));
    }

    private boolean isInWhitelist(File file) {
        return this.isInWhitelist(file.getName().substring(0, file.getName().indexOf(46)));
    }

    private boolean isInWhitelist(String name) {
        boolean inWhitelist;
        boolean bl = inWhitelist = this.whitelist.contains(name) || this.whitelist.size() == 1 && this.whitelist.contains("all");
        if (!inWhitelist) {
            log.trace("Skipping document with name/id {} because it is not contained in the white list.", (Object)name);
        }
        return inWhitelist;
    }

    @Override
    public URI next() {
        if (!this.hasNext()) {
            return null;
        }
        URI ret = this.currentUri;
        this.currentUri = null;
        return ret;
    }
}

