/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc.parser;

import com.ximpleware.NavException;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.jcore.reader.pmc.PMCReader;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingResult;
import de.julielab.jcore.reader.pmc.parser.NxmlDocumentParser;
import de.julielab.jcore.reader.pmc.parser.NxmlElementParser;
import de.julielab.jcore.reader.pmc.parser.ParsingResult;
import de.julielab.jcore.types.Caption;
import de.julielab.jcore.types.Table;
import de.julielab.jcore.types.Title;
import java.util.Optional;
import org.apache.uima.jcas.tcas.Annotation;

public class TableWrapParser
extends NxmlElementParser {
    public TableWrapParser(NxmlDocumentParser nxmlDocumentParser) {
        super(nxmlDocumentParser);
        this.elementName = "table-wrap";
    }

    @Override
    protected void parseElement(ElementParsingResult tableWrapResult) throws ElementParsingException {
        try {
            Optional<String> tableWrapId = this.getXPathValue("@id");
            Optional<ParsingResult> labelResult = this.parseXPath("label");
            Optional<String> labelString = this.getXPathValue("label");
            Optional<ParsingResult> captionResult = this.parseXPath("caption");
            captionResult.ifPresent(r -> {
                ElementParsingResult result = (ElementParsingResult)r;
                Caption caption = (Caption)result.getAnnotation();
                caption.setCaptionType("table");
                tableWrapResult.addSubResult((ParsingResult)r);
            });
            labelResult.ifPresent(tableWrapResult::addSubResult);
            Table table = new Table(this.nxmlDocumentParser.cas);
            table.setComponentId(PMCReader.class.getName());
            labelResult.map(l -> ((ElementParsingResult)l).getAnnotation()).map(Title.class::cast).map(t -> {
                t.setTitleType("table");
                return t;
            }).ifPresent(arg_0 -> ((Table)table).setObjectTitle(arg_0));
            labelString.ifPresent(arg_0 -> ((Table)table).setObjectLabel(arg_0));
            captionResult.map(r -> (Caption)((ElementParsingResult)r).getAnnotation()).ifPresent(arg_0 -> ((Table)table).setObjectCaption(arg_0));
            tableWrapId.ifPresent(arg_0 -> ((Table)table).setObjectId(arg_0));
            tableWrapResult.setAnnotation((Annotation)table);
        }
        catch (NavException | XPathEvalException | XPathParseException e) {
            throw new ElementParsingException(e);
        }
    }
}

