/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc.parser;

import com.ximpleware.NavException;
import de.julielab.jcore.reader.pmc.PMCReader;
import de.julielab.jcore.reader.pmc.parser.DefaultElementParser;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingResult;
import de.julielab.jcore.reader.pmc.parser.NxmlDocumentParser;
import de.julielab.jcore.reader.pmc.parser.ParsingResult;
import de.julielab.jcore.types.AbstractSection;
import de.julielab.jcore.types.AbstractSectionHeading;
import de.julielab.jcore.types.Section;
import de.julielab.jcore.types.SectionTitle;
import de.julielab.jcore.types.Title;
import java.util.List;

public class SectionParser
extends DefaultElementParser {
    private int depth = -1;

    public SectionParser(NxmlDocumentParser nxmlDocumentParser) {
        super(nxmlDocumentParser);
        this.elementName = "sec";
    }

    @Override
    protected void beforeParseElement() throws ElementParsingException {
        ++this.depth;
    }

    @Override
    protected void afterParseElement() throws ElementParsingException {
        --this.depth;
    }

    @Override
    protected void parseElement(ElementParsingResult parsingResult) throws ElementParsingException {
        try {
            String sectionId = this.getElementAttributes().get("id");
            String elementPath = this.getElementPath();
            super.parseElement(parsingResult);
            if (elementPath.contains("abstract")) {
                AbstractSectionHeading sectionHeading = null;
                List<AbstractSectionHeading> abstractSectionHeadings = parsingResult.getSubResultAnnotations(AbstractSectionHeading.class);
                if (!abstractSectionHeadings.isEmpty()) {
                    sectionHeading = abstractSectionHeadings.get(0);
                }
                if (parsingResult.getDirectResultText().trim().length() == 0 && abstractSectionHeadings.isEmpty()) {
                    parsingResult.setAnnotation(null);
                    return;
                }
                AbstractSection section = (AbstractSection)parsingResult.getAnnotation();
                section.setComponentId(PMCReader.class.getName());
                section.setAbstractSectionHeading((Title)sectionHeading);
            } else {
                SectionTitle sectionHeading = null;
                List<SectionTitle> secTitleAnnotations = parsingResult.getSubResultAnnotations(SectionTitle.class);
                if (!secTitleAnnotations.isEmpty()) {
                    sectionHeading = secTitleAnnotations.get(0);
                }
                Section section = (Section)parsingResult.getAnnotation();
                section.setComponentId(PMCReader.class.getName());
                section.setSectionHeading((Title)sectionHeading);
                section.setDepth(this.depth);
                section.setSectionId(sectionId);
                List<ParsingResult> label = parsingResult.getSubResults("label");
                if (!label.isEmpty()) {
                    ElementParsingResult labelParsingResult = (ElementParsingResult)label.get(0);
                    section.setLabel(labelParsingResult.getResultText());
                }
            }
        }
        catch (NavException e) {
            throw new ElementParsingException(e);
        }
    }

    @Override
    protected void editResult(ElementParsingResult result) {
        result.setBlockElement(true);
    }
}

