/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc.parser;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.jcore.reader.pmc.parser.DocumentParsingException;

public abstract class NxmlParser {
    protected VTDNav vn;
    private AutoPilot reusableAutoPilot;
    private boolean autoPilotInUse = false;

    protected String moveToNextStartingTag() throws DocumentParsingException {
        try {
            int i;
            int tokenType = this.vn.getTokenType(i);
            for (i = this.vn.getCurrentIndex(); tokenType != 0 && i < this.vn.getTokenCount(); ++i) {
            }
            this.vn.recoverNode(i);
            return this.vn.toString(this.vn.getCurrentIndex());
        }
        catch (NavException e) {
            throw new DocumentParsingException(e);
        }
    }

    protected AutoPilot getAutoPilot(String xpath, VTDNav vn) throws XPathParseException {
        assert (!this.autoPilotInUse) : "The reusable AutoPilot is in use and must be released before being used again.";
        if (this.reusableAutoPilot == null) {
            this.reusableAutoPilot = new AutoPilot();
        }
        this.reusableAutoPilot.bind(vn);
        this.reusableAutoPilot.selectXPath(xpath);
        return this.reusableAutoPilot;
    }

    protected void releaseAutoPilot() {
        this.reusableAutoPilot.resetXPath();
        this.autoPilotInUse = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean xPathExists(String xpath) throws XPathParseException, XPathEvalException, NavException {
        try {
            AutoPilot ap = this.getAutoPilot(xpath, this.vn);
            boolean bl = ap.evalXPath() != -1;
            return bl;
        }
        finally {
            this.releaseAutoPilot();
        }
    }
}

