/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc.parser;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingResult;
import de.julielab.jcore.reader.pmc.parser.NxmlDocumentParser;
import de.julielab.jcore.reader.pmc.parser.NxmlParser;
import de.julielab.jcore.reader.pmc.parser.ParsingResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NxmlElementParser
extends NxmlParser {
    private static final Logger log = LoggerFactory.getLogger(NxmlElementParser.class);
    protected String elementName;
    protected NxmlDocumentParser nxmlDocumentParser;

    public NxmlElementParser(NxmlDocumentParser nxmlDocumentParser) {
        this.nxmlDocumentParser = nxmlDocumentParser;
        this.vn = nxmlDocumentParser.getVn();
    }

    public final ElementParsingResult parse() throws ElementParsingException {
        try {
            this.beforeParseElement();
            this.checkCursorPosition();
            int elementDepth = this.vn.getTokenDepth(this.vn.getCurrentIndex());
            int startElementIndex = this.vn.getCurrentIndex();
            ElementParsingResult elementParsingResult = this.createParsingResult();
            this.parseElement(elementParsingResult);
            if (this.vn.getCurrentIndex() < startElementIndex) {
                this.vn.recoverNode(startElementIndex);
            }
            if (this.vn.getTokenType(this.vn.getCurrentIndex()) != 0) {
                this.vn.toElement(1);
                if (this.getElementEnd() > elementParsingResult.getEnd()) {
                    throw new IllegalStateException("Parsed element \"" + this.elementName + "\" ends at byte " + elementParsingResult.getEnd() + " but VTDNav was positioned after parsing within an element which ends at " + this.getElementEnd() + ". Each element parser must finish within its element or at a starting tag immediately following the parser's element closing tag.");
                }
            }
            int index = this.findIndexAfterElement(elementDepth, this.vn.getCurrentIndex());
            elementParsingResult.setLastTokenIndex(index);
            this.afterParseElement();
            return elementParsingResult;
        }
        catch (NavException e) {
            throw new ElementParsingException(e);
        }
    }

    private int findIndexAfterElement(int elementDepth, int startIndex) {
        int index = this.vn.getCurrentIndex();
        int tokenType = this.vn.getTokenType(index);
        if (tokenType == 0) {
            index = this.findIndexAfterStartingTag(index);
        }
        while (index < this.vn.getTokenCount() && this.tokenIndexBelongsToElement(index, elementDepth)) {
            ++index;
        }
        return index;
    }

    private int findIndexAfterStartingTag(int startIndex) {
        int index = startIndex;
        int tokenType = this.vn.getTokenType(index);
        if (tokenType == 0) {
            ++index;
        }
        while (tokenType == 2 || tokenType == 4 || tokenType == 3 || tokenType == 7 || tokenType == 8) {
            ++index;
        }
        return index;
    }

    protected void beforeParseElement() throws ElementParsingException {
    }

    protected void afterParseElement() throws ElementParsingException {
    }

    protected abstract void parseElement(ElementParsingResult var1) throws ElementParsingException;

    private ElementParsingResult createParsingResult() throws NavException {
        int begin = this.getElementStart();
        int end = this.getElementEnd();
        ElementParsingResult result = new ElementParsingResult(this.elementName, begin, end);
        return result;
    }

    protected int getElementStart() throws NavException {
        long elementFragment = this.vn.getElementFragment();
        int offset = (int)elementFragment;
        return offset;
    }

    protected int getElementEnd() throws NavException {
        long elementFragment = this.vn.getElementFragment();
        int offset = (int)elementFragment;
        int length = (int)(elementFragment >> 32);
        return offset + length;
    }

    private void checkCursorPosition() throws NavException {
        if (this.vn.getTokenType(this.vn.getCurrentIndex()) != 0) {
            throw new IllegalStateException("VTDNav is positioned incorrectly. It must point to a starting tag.");
        }
        if (!this.vn.toString(this.vn.getCurrentIndex()).equals(this.elementName)) {
            throw new IllegalStateException("VTDNav is positioned incorrectly. It is expected to be positioned at the starting tag \"" + this.elementName + "\" but it is set to \"" + this.vn.toString(this.vn.getCurrentIndex()) + "\".");
        }
    }

    protected int skipElement() {
        int i;
        int elementDepth = this.vn.getCurrentDepth();
        for (i = this.vn.getCurrentIndex() + 1; i < this.vn.getTokenCount() && this.tokenIndexBelongsToElement(i, elementDepth); ++i) {
        }
        return i;
    }

    protected boolean tokenIndexBelongsToElement(int index, int elementDepth) {
        return (this.vn.getTokenType(index) != 0 || this.vn.getTokenDepth(index) > elementDepth) && this.vn.getTokenDepth(index) >= elementDepth;
    }

    protected boolean moveToXPath(String xpath) throws XPathParseException, XPathEvalException, NavException {
        AutoPilot ap = this.getAutoPilot(xpath, this.vn);
        int index = ap.evalXPath();
        this.releaseAutoPilot();
        return index != -1;
    }

    protected Optional<ParsingResult> parseXPath(String xpath) throws XPathParseException, XPathEvalException, NavException, ElementParsingException {
        try {
            this.vn.push();
            if (this.moveToXPath(xpath)) {
                Optional<ParsingResult> optional = Optional.of(this.nxmlDocumentParser.getParser(this.vn.toString(this.vn.getCurrentIndex())).parse());
                return optional;
            }
            log.trace("XPath not found: {}", (Object)xpath);
            Optional<ParsingResult> optional = Optional.empty();
            return optional;
        }
        finally {
            this.vn.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<String> getXPathValue(String xpath) throws XPathParseException, XPathEvalException, NavException {
        try {
            this.vn.push();
            AutoPilot ap = this.getAutoPilot(xpath, this.vn);
            String xpathValue = ap.evalXPathToString().trim();
            if (xpathValue != null && xpathValue.length() > 0) {
                Optional<String> optional = Optional.of(xpathValue);
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        finally {
            this.releaseAutoPilot();
            this.vn.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<List<String>> getXPathValues(String xpath) throws XPathParseException, XPathEvalException, NavException {
        try {
            this.vn.push();
            ArrayList<String> values = new ArrayList<String>();
            AutoPilot ap = this.getAutoPilot(xpath, this.vn);
            while (ap.evalXPath() != -1) {
                int text = this.vn.getText();
                if (text == -1) continue;
                values.add(this.vn.toString(text));
            }
            if (!values.isEmpty()) {
                Optional<List<String>> optional = Optional.of(values);
                return optional;
            }
            Optional<List<String>> optional = Optional.empty();
            return optional;
        }
        finally {
            this.releaseAutoPilot();
            this.vn.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getElementPath() throws NavException {
        try {
            assert (this.vn.getTokenType(this.vn.getCurrentIndex()) == 0) : "This method only works if the VTDNav is positioned at the beginning of an element.";
            ArrayList<String> pathItems = new ArrayList<String>(this.vn.getCurrentDepth() + 1);
            this.vn.push();
            do {
                pathItems.add(this.vn.toString(this.vn.getCurrentIndex()));
            } while (this.vn.toElement(1) && this.vn.getTokenType(this.vn.getCurrentIndex()) == 0);
            int pathLength = pathItems.size() - 1;
            String string = "/" + IntStream.rangeClosed(0, pathLength).mapToObj(i -> (String)pathItems.get(pathLength - i)).collect(Collectors.joining("/"));
            return string;
        }
        finally {
            this.vn.pop();
        }
    }

    protected Map<String, String> getElementAttributes() throws NavException {
        HashMap<String, String> attributesOfElement = new HashMap<String, String>();
        int i = this.vn.getCurrentIndex();
        if (this.vn.getTokenType(i) == 0 && !this.elementName.equals(this.vn.toString(i)) || this.vn.getTokenType(i) == 2 && this.vn.getTokenType(i - 1) == 0 && !this.elementName.equals(this.vn.toString(i - 1))) {
            throw new IllegalStateException("To create the element attribute map, the VTDNav cursor must be set to the starting tag or the first attribute name.");
        }
        long tagEndOffset = this.vn.getOffsetAfterHead();
        String attrName = null;
        String attrValue = null;
        while ((long)this.vn.getTokenOffset(i) < tagEndOffset) {
            switch (this.vn.getTokenType(i)) {
                case 2: {
                    attrName = this.vn.toString(i);
                    break;
                }
                case 4: {
                    attrValue = this.vn.toString(i);
                    attributesOfElement.put(attrName, attrValue);
                }
            }
            ++i;
        }
        return attributesOfElement;
    }
}

