/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc.parser;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import de.julielab.jcore.reader.pmc.parser.ContribGroupParser;
import de.julielab.jcore.reader.pmc.parser.ContribParser;
import de.julielab.jcore.reader.pmc.parser.DefaultElementParser;
import de.julielab.jcore.reader.pmc.parser.DocTypeNotFoundException;
import de.julielab.jcore.reader.pmc.parser.DocumentParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingResult;
import de.julielab.jcore.reader.pmc.parser.FigParser;
import de.julielab.jcore.reader.pmc.parser.FrontParser;
import de.julielab.jcore.reader.pmc.parser.ListParser;
import de.julielab.jcore.reader.pmc.parser.NxmlElementParser;
import de.julielab.jcore.reader.pmc.parser.NxmlParser;
import de.julielab.jcore.reader.pmc.parser.SectionParser;
import de.julielab.jcore.reader.pmc.parser.TableWrapParser;
import de.julielab.jcore.reader.pmc.parser.XRefParser;
import de.julielab.xml.JulieXMLTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class NxmlDocumentParser
extends NxmlParser {
    private static final Logger log = LoggerFactory.getLogger(NxmlDocumentParser.class);
    protected JCas cas;
    private Map<String, NxmlElementParser> parserRegistry;
    private DefaultElementParser defaultElementParser;
    private Map<String, Map<String, Object>> tagProperties;
    private Tagset tagset;
    @Deprecated
    private File nxmlFile;
    private URI uri;

    public void reset(File nxmlFile, JCas cas) throws DocumentParsingException {
        this.reset(nxmlFile.toURI(), cas);
    }

    public void reset(URI uri, JCas cas) throws DocumentParsingException {
        this.uri = uri;
        boolean gzipped = uri.toString().endsWith(".gz") || this.uri.toString().endsWith(".gzip");
        try {
            InputStream is = uri.toURL().openStream();
            if (gzipped) {
                is = new GZIPInputStream(is);
            }
            this.reset(is, cas);
        }
        catch (IOException e) {
            throw new DocumentParsingException(e);
        }
    }

    public void reset(InputStream is, JCas cas) throws DocumentParsingException {
        this.cas = cas;
        try {
            byte[] bytes = JulieXMLTools.readStream((InputStream)is, (int)8192);
            VTDGen vg = new VTDGen();
            vg.setDoc(bytes);
            vg.enableIgnoredWhiteSpace(true);
            vg.parse(false);
            this.vn = vg.getNav();
            this.setTagset();
            this.setupParserRegistry();
        }
        catch (VTDException | IOException e) {
            throw new DocumentParsingException(e);
        }
    }

    private void setTagset() throws NavException, DocTypeNotFoundException {
        for (int i = 0; i < this.vn.getTokenCount(); ++i) {
            if (this.vn.getTokenType(i) != 12) continue;
            String docType = StringUtils.normalizeSpace((String)this.vn.toString(i)).replaceAll("'", "\"");
            if (docType.contains("JATS-archivearticle1.dtd")) {
                this.tagset = Tagset.JATS_1_0;
            } else if (docType.contains("journalpublishing.dtd") || docType.contains("archivearticle.dtd")) {
                this.tagset = Tagset.NLM_2_3;
            } else if (docType.contains("journalpublishing3.dtd") || docType.contains("archivearticle3.dtd")) {
                this.tagset = Tagset.NLM_3_0;
            } else {
                throw new IllegalArgumentException("Unsupported document type in file " + this.nxmlFile.getAbsolutePath() + ": " + docType);
            }
            return;
        }
        throw new DocTypeNotFoundException("Could not find a doctype in file " + this.nxmlFile);
    }

    private void setupParserRegistry() {
        this.defaultElementParser = new DefaultElementParser(this);
        this.parserRegistry = new HashMap<String, NxmlElementParser>();
        this.parserRegistry.put("front", new FrontParser(this));
        this.parserRegistry.put("contrib-group", new ContribGroupParser(this));
        this.parserRegistry.put("contrib", new ContribParser(this));
        this.parserRegistry.put("sec", new SectionParser(this));
        this.parserRegistry.put("table-wrap", new TableWrapParser(this));
        this.parserRegistry.put("fig", new FigParser(this));
        this.parserRegistry.put("list", new ListParser(this));
        this.parserRegistry.put("xref", new XRefParser(this));
    }

    public VTDNav getVn() {
        return this.vn;
    }

    public File getNxmlFile() {
        return this.nxmlFile;
    }

    public Tagset getTagset() {
        return this.tagset;
    }

    public Map<String, NxmlElementParser> getParserRegistry() {
        return this.parserRegistry;
    }

    public ElementParsingResult parse() throws ElementParsingException, DocumentParsingException {
        String startingElement = this.moveToNextStartingTag();
        assert (startingElement.equals("article")) : "Did not encounter an article element as first start element";
        return this.getParser(startingElement).parse();
    }

    public NxmlElementParser getParser(String tagName) {
        NxmlElementParser nxmlElementParser = this.parserRegistry.getOrDefault(tagName, this.defaultElementParser);
        return nxmlElementParser;
    }

    public Map<String, Object> getTagProperties(String tag) {
        if (this.tagProperties != null) {
            return this.tagProperties.getOrDefault(tag, Collections.emptyMap());
        }
        return Collections.emptyMap();
    }

    public void loadElementPropertyFile(String file) throws IOException {
        Yaml yaml = new Yaml();
        InputStream is = this.getClass().getResourceAsStream(file.startsWith("/") ? file : "/" + file);
        if (is == null && new File(file).exists()) {
            is = new FileInputStream(file);
        }
        if (is == null) {
            throw new IOException("Resource " + file + " could neither be found as a file nor as a classpath resource");
        }
        Iterable allProperties = yaml.loadAll(is);
        for (Object tag : allProperties) {
            this.tagProperties = (Map)tag;
        }
    }

    public static enum Tagset {
        JATS_1_0,
        NLM_2_3,
        NLM_3_0;

    }
}

