/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc.parser;

import com.ximpleware.NavException;
import de.julielab.jcore.reader.pmc.PMCReader;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingResult;
import de.julielab.jcore.reader.pmc.parser.NxmlDocumentParser;
import de.julielab.jcore.reader.pmc.parser.NxmlElementParser;
import de.julielab.jcore.reader.pmc.parser.ParsingResult;
import de.julielab.jcore.reader.pmc.parser.TextParsingResult;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.uima.cas.Feature;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class DefaultElementParser
extends NxmlElementParser {
    public DefaultElementParser(NxmlDocumentParser nxmlDocumentParser) {
        super(nxmlDocumentParser);
    }

    @Override
    protected void beforeParseElement() throws ElementParsingException {
        try {
            this.elementName = this.vn.toString(this.vn.getCurrentIndex());
        }
        catch (NavException e) {
            throw new ElementParsingException(e);
        }
    }

    @Override
    protected void parseElement(ElementParsingResult result) throws ElementParsingException {
        try {
            int elementDepth = this.vn.getCurrentDepth();
            boolean omitElement = this.getApplicableProperties().orElse(Collections.emptyMap()).getOrDefault("omit-element", false);
            if (omitElement) {
                int firstIndexAfterElement = this.skipElement();
                result.setLastTokenIndex(firstIndexAfterElement);
                result.setResultType(ParsingResult.ResultType.NONE);
                return;
            }
            result.setAnnotation(this.getParsingResultAnnotation());
            this.editResult(result);
            boolean inElementContent = false;
            block6: for (int i = this.vn.getCurrentIndex() + 1; i < this.vn.getTokenCount() && this.tokenIndexBelongsToElement(i, elementDepth); ++i) {
                int tokenType = this.vn.getTokenType(i);
                if (tokenType != 2 && tokenType != 4 && tokenType != 3 && tokenType != 7 && tokenType != 8) {
                    inElementContent = true;
                }
                if (!inElementContent) continue;
                switch (tokenType) {
                    case 0: {
                        if (this.vn.getCurrentIndex() != i) {
                            this.vn.recoverNode(i);
                        }
                        String tagName = this.vn.toString(this.vn.getCurrentIndex());
                        ElementParsingResult subResult = this.nxmlDocumentParser.getParser(tagName).parse();
                        result.addSubResult(subResult);
                        i = subResult.getLastTokenIndex() - 1;
                        continue block6;
                    }
                    case 5: 
                    case 11: {
                        result.addSubResult(new TextParsingResult(this.vn.toString(i), this.vn.getTokenOffset(i), this.vn.getTokenOffset(i) + this.vn.getTokenLength(i)));
                    }
                }
            }
        }
        catch (NavException e) {
            throw new ElementParsingException(e);
        }
    }

    protected void editResult(ElementParsingResult result) throws NavException {
        String typeName = (String)this.nxmlDocumentParser.getTagProperties(this.elementName).getOrDefault("type", "none");
        if (typeName.equals("none")) {
            return;
        }
        Map defaultFeatureValues = this.getApplicableProperties().orElse(Collections.emptyMap()).getOrDefault("default-feature-values", Collections.emptyMap());
        for (String featureName : defaultFeatureValues.keySet()) {
            Feature feature = this.nxmlDocumentParser.cas.getTypeSystem().getType(typeName).getFeatureByBaseName(featureName);
            result.getAnnotation().setFeatureValueFromString(feature, (String)defaultFeatureValues.get(featureName));
        }
    }

    private Optional<Map<String, Object>> getPathMap() throws NavException {
        List paths = this.nxmlDocumentParser.getTagProperties(this.elementName).getOrDefault("paths", Collections.emptyList());
        String currentElementPath = null;
        if (!paths.isEmpty()) {
            currentElementPath = this.getElementPath();
        }
        String longestPathFragment = "";
        int longestPathFragmentLength = 0;
        Map matchingPathMap = null;
        for (Object o : paths) {
            Map pathMap = (Map)o;
            String pathFragment = (String)pathMap.get("path");
            if (!currentElementPath.endsWith(pathFragment)) continue;
            int pathFragmentLength = pathFragment.split("/").length;
            if (pathFragmentLength > longestPathFragmentLength) {
                longestPathFragment = pathFragment;
                longestPathFragmentLength = pathFragmentLength;
                matchingPathMap = pathMap;
                continue;
            }
            if (pathFragment.length() != longestPathFragmentLength) continue;
            throw new IllegalArgumentException("The given type paths for element " + this.elementName + " are ambiguous. The given paths " + pathFragment + " as well as " + longestPathFragment + " are applicable but both are of same length and thus none is more specific than the other. At least one of the path must be made more specific.");
        }
        if (matchingPathMap != null) {
            return Optional.of(matchingPathMap);
        }
        return Optional.empty();
    }

    protected Annotation getParsingResultAnnotation() throws ElementParsingException {
        try {
            String annotationClassName = this.getApplicableProperties().orElse(Collections.emptyMap()).getOrDefault("type", "none");
            if (annotationClassName.trim().equals("none")) {
                return null;
            }
            Constructor<?> constructor = Class.forName(annotationClassName).getConstructor(JCas.class);
            Annotation annotation = (Annotation)constructor.newInstance(this.nxmlDocumentParser.cas);
            if (annotation instanceof de.julielab.jcore.types.Annotation) {
                ((de.julielab.jcore.types.Annotation)annotation).setComponentId(PMCReader.class.getName());
            }
            return annotation;
        }
        catch (NavException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ElementParsingException(e);
        }
    }

    private Optional<Map<String, Object>> getApplicableProperties() throws NavException {
        Optional<Map<String, Object>> applicableProperties = null;
        applicableProperties = this.getPathMap();
        if (!applicableProperties.isPresent() && this.nxmlDocumentParser.getTagProperties(this.elementName).get("attributes") != null) {
            List attributeList = (List)this.nxmlDocumentParser.getTagProperties(this.elementName).get("attributes");
            Map<String, String> attributesOfElement = this.getElementAttributes();
            for (Map attribute : attributeList) {
                String attributeValue = attributesOfElement.get(attribute.get("name"));
                if (attributeValue == null || !attributeValue.equals(attribute.get("value")) || !attribute.containsKey("omit-element")) continue;
                applicableProperties = Optional.of(attribute);
            }
        }
        if (!applicableProperties.isPresent()) {
            applicableProperties = Optional.ofNullable(this.nxmlDocumentParser.getTagProperties(this.elementName));
        }
        return applicableProperties;
    }
}

