/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc;

import de.julielab.jcore.reader.pmc.CasPopulator;
import de.julielab.jcore.reader.pmc.PMCReaderBase;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import java.io.IOException;
import java.net.URI;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Pubmed Central Reader", description="Reads Pubmed Central documents from the NXML format")
@TypeCapability(outputs={"de.julielab.jcore.types.TitleType", "de.julielab.jcore.types.Title", "de.julielab.jcore.types.TextObject", "de.julielab.jcore.types.Table", "de.julielab.jcore.types.SectionTitle", "de.julielab.jcore.types.Section", "de.julielab.jcore.types.PubType", "de.julielab.jcore.types.Paragraph", "de.julielab.jcore.types.OtherPub", "de.julielab.jcore.types.pubmed.OtherID", "de.julielab.jcore.types.pubmed.ManualDescriptor", "de.julielab.jcore.types.Keyword", "de.julielab.jcore.types.Journal", "de.julielab.jcore.types.pubmed.Header", "de.julielab.jcore.types.Footnote", "de.julielab.jcore.types.Figure", "uima.tcas.DocumentAnnotation", "de.julielab.jcore.types.Date", "de.julielab.jcore.types.CaptionType", "de.julielab.jcore.types.Caption", "de.julielab.jcore.types.AutoDescriptor", "de.julielab.jcore.types.AuthorInfo", "de.julielab.jcore.types.AbstractText", "de.julielab.jcore.types.AbstractSectionHeading", "de.julielab.jcore.types.AbstractSection"})
public class PMCReader
extends PMCReaderBase {
    public static final String PARAM_INPUT = "Input";
    public static final String PARAM_RECURSIVELY = "SearchRecursively";
    public static final String PARAM_SEARCH_ZIP = "SearchInZipFiles";
    public static final String PARAM_WHITELIST = "WhitelistFile";
    private static final Logger log = LoggerFactory.getLogger(PMCReader.class);
    private CasPopulator casPopulator;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.casPopulator = new CasPopulator(this.pmcFiles);
        }
        catch (IOException e) {
            log.error("Exception occurred when trying to initialize NXML parser", (Throwable)e);
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void getNext(JCas cas) throws CollectionException {
        URI next = null;
        try {
            next = (URI)this.pmcFiles.next();
            this.casPopulator.populateCas(next, cas);
        }
        catch (ElementParsingException e) {
            log.error("Exception occurred when trying to parse {}", (Object)next, (Object)e);
            throw new CollectionException((Throwable)e);
        }
        ++this.completed;
    }
}

