/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.pmc;

import de.julielab.jcore.reader.pmc.parser.DocumentParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingResult;
import de.julielab.jcore.reader.pmc.parser.NxmlDocumentParser;
import de.julielab.jcore.reader.pmc.parser.ParsingResult;
import de.julielab.jcore.reader.pmc.parser.TextParsingResult;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasPopulator {
    private static final Logger log = LoggerFactory.getLogger(CasPopulator.class);
    private NxmlDocumentParser nxmlDocumentParser;
    private Iterator<URI> nxmlIterator;

    public CasPopulator(Iterator<URI> nxmlIterator) throws IOException {
        this.nxmlIterator = nxmlIterator;
        this.nxmlDocumentParser = new NxmlDocumentParser();
        this.nxmlDocumentParser.loadElementPropertyFile("/de/julielab/jcore/reader/pmc/resources/elementproperties.yml");
    }

    public void populateCas(URI nxmlUri, JCas cas) throws ElementParsingException {
        ElementParsingResult result = null;
        URI currentUri = nxmlUri;
        while (currentUri != null && result == null) {
            try {
                this.nxmlDocumentParser.reset(currentUri, cas);
                result = this.nxmlDocumentParser.parse();
            }
            catch (DocumentParsingException e) {
                log.warn("Error occurred: {}. Skipping document.", (Object)e.getMessage());
                if (!this.nxmlIterator.hasNext()) continue;
                currentUri = this.nxmlIterator.next();
            }
        }
        StringBuilder sb = this.populateCas(result, new StringBuilder());
        cas.setDocumentText(sb.toString());
    }

    private StringBuilder populateCas(ParsingResult result, StringBuilder sb) {
        switch (result.getResultType()) {
            case ELEMENT: {
                Annotation annotation;
                boolean isBlockElement;
                ElementParsingResult elementParsingResult = (ElementParsingResult)result;
                String elementName = elementParsingResult.getElementName();
                boolean bl = isBlockElement = elementParsingResult.isBlockElement() || (Boolean)this.nxmlDocumentParser.getTagProperties(elementName).getOrDefault("block-element", false) != false;
                if (isBlockElement && sb.length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
                    sb.append("\n");
                }
                int begin = sb.length();
                for (ParsingResult subResult : elementParsingResult.getSubResults()) {
                    this.populateCas(subResult, sb);
                }
                int end = sb.length();
                if (isBlockElement && sb.length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
                    sb.append("\n");
                }
                if ((annotation = elementParsingResult.getAnnotation()) == null) break;
                annotation.setBegin(begin);
                annotation.setEnd(end);
                if (!elementParsingResult.addAnnotationToIndexes()) break;
                annotation.addToIndexes();
                break;
            }
            case TEXT: {
                TextParsingResult textParsingResult = (TextParsingResult)result;
                sb.append(textParsingResult.getText());
                break;
            }
        }
        return sb;
    }
}

