/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.multiplier.pmc;

import de.julielab.costosys.configuration.FieldConfig;
import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.jcore.reader.db.DBMultiplier;
import de.julielab.jcore.reader.db.DBReader;
import de.julielab.jcore.reader.pmc.CasPopulator;
import de.julielab.jcore.reader.pmc.NoDataAvailableException;
import de.julielab.jcore.reader.pmc.parser.ElementParsingException;
import de.julielab.jcore.types.casflow.ToVisit;
import de.julielab.jcore.types.casmultiplier.RowBatch;
import de.julielab.jcore.types.pubmed.Header;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMCDBMultiplier
extends DBMultiplier {
    public static final String PARAM_OMIT_BIB_REFERENCES = "OmitBibliographyReferences";
    public static final String PARAM_ADD_SHA_HASH = "AddShaHash";
    public static final String PARAM_TABLE_DOCUMENT = "DocumentTable";
    public static final String PARAM_TABLE_DOCUMENT_SCHEMA = "DocumentTableSchema";
    public static final String PARAM_TO_VISIT_KEYS = "ToVisitKeys";
    public static final String PARAM_TRUNCATE_AT_SIZE = "TruncateAtSize";
    private static final Logger log = LoggerFactory.getLogger(PMCDBMultiplier.class);
    @ConfigurationParameter(name="OmitBibliographyReferences", mandatory=false, defaultValue={"false"}, description="If set to true, references to the bibliography are omitted from the CAS text.")
    protected boolean omitBibReferences;
    @ConfigurationParameter(name="AddShaHash", mandatory=false, description="For use with AnnotationDefinedFlowController. Possible values: document_text, defaults to 'document_text' and thus doesn't need to be specified manually at the moment. This parameter needs to match the value for the same parameter given to the XMIDBWriter in this pipeline. Then, a comparison between the existing hash in the database and the new hash of the CAS read in this pipeline can be made. In case the hashes match, the CAS is directly routed to the components specified in the ToVisitKeys parameter, skipping all other components. Note that this only works with AAEs where the first component is an 'AnnotationControlledFlow'.")
    private String documentItemToHash;
    @ConfigurationParameter(name="DocumentTable", mandatory=false, description="For use with AnnotationDefinedFlowController. String parameter indicating the name of the table where the XMI data and, thus, the hash is stored. The name must be schema qualified. Note that in this component, only the ToVisit annotation is created that determines which components to apply to a CAS with matching (unchanged) hash. The logic to actually control the CAS flow is contained in the AnnotationDefinedFlowController.")
    private String xmiStorageDataTable;
    @ConfigurationParameter(name="DocumentTableSchema", mandatory=false, description="For use with AnnotationDefinedFlowController. The name of the schema that the document table - given with the DocumentTable parameter - adheres to. Only the primary key part is required for hash value retrieval.")
    private String xmiStorageDataTableSchema;
    @ConfigurationParameter(name="ToVisitKeys", mandatory=false, description="For use with AnnotationDefinedFlowController. The delegate AE keys of the AEs this CAS should still applied on although the hash has not changed. Can be null or empty indicating that no component should be applied to the CAS. This is, however, the task of the AnnotationDefinedFlowController.")
    private String[] toVisitKeys;
    @ConfigurationParameter(name="TruncateAtSize", mandatory=false, description="The maximum number of characters allowed in the document text. Characters exceeding this size are discarded. This can be necessary when large documents cannot be handled by subsequent components in the pipeline. Defaults to Integer.MAX_VALUE.")
    private int truncationSize;
    private CasPopulator casPopulator;
    private Map<String, String> docId2HashMap;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.xmiStorageDataTable = (String)aContext.getConfigParameterValue(PARAM_TABLE_DOCUMENT);
        this.xmiStorageDataTableSchema = (String)aContext.getConfigParameterValue(PARAM_TABLE_DOCUMENT_SCHEMA);
        this.documentItemToHash = Optional.ofNullable((String)aContext.getConfigParameterValue(PARAM_ADD_SHA_HASH)).orElse("document_text");
        this.toVisitKeys = (String[])aContext.getConfigParameterValue(PARAM_TO_VISIT_KEYS);
        this.omitBibReferences = Optional.ofNullable((Boolean)aContext.getConfigParameterValue(PARAM_OMIT_BIB_REFERENCES)).orElse(false);
        this.truncationSize = Optional.ofNullable((Integer)aContext.getConfigParameterValue(PARAM_TRUNCATE_AT_SIZE)).orElse(Integer.MAX_VALUE);
        this.initialized = false;
        if (!(this.xmiStorageDataTable == null && this.xmiStorageDataTableSchema == null || this.xmiStorageDataTable != null && this.xmiStorageDataTableSchema != null && this.documentItemToHash != null)) {
            String errorMsg = String.format("From the parameters '%s' and '%s' some are specified and some aren't. To activate hash value comparison in order to add aggregate component keys for CAS visit, specify all those parameters. Otherwise, specify none.", PARAM_TABLE_DOCUMENT, PARAM_TABLE_DOCUMENT_SCHEMA);
            log.error(errorMsg);
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException(errorMsg));
        }
        try {
            this.casPopulator = new CasPopulator(Boolean.valueOf(this.omitBibReferences), this.truncationSize);
        }
        catch (IOException e) {
            String errorMsg = "Could not initialize the PMC CasPopulator.";
            log.error(errorMsg);
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        this.docId2HashMap = this.fetchCurrentHashesFromDatabase((RowBatch)JCasUtil.selectSingle((JCas)aJCas, RowBatch.class));
        super.process(aJCas);
    }

    public AbstractCas next() throws AnalysisEngineProcessException {
        JCas jCas = this.getEmptyJCas();
        try {
            if (this.documentDataIterator.hasNext()) {
                byte[][] documentData = (byte[][])this.documentDataIterator.next();
                String pkString = DBReader.setDBProcessingMetaData((DataBaseConnector)this.dbc, (boolean)this.readDataTable, (String)this.tableName, (byte[][])documentData, (JCas)jCas);
                this.populateCas(jCas, documentData, pkString);
                this.setToVisitAnnotation(jCas, pkString);
            }
        }
        catch (Exception e) {
            log.error("Exception occurred: ", (Throwable)e);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        return jCas;
    }

    private void populateCas(JCas jCas, byte[][] documentData, String pkString) throws NoDataAvailableException, ElementParsingException {
        List pkIndices = this.dbc.getPrimaryKeyIndices();
        ArrayList<Integer> allIndices = new ArrayList<Integer>();
        for (int i = 0; i < documentData.length; ++i) {
            allIndices.add(i);
        }
        ArrayList xmlIndices = new ArrayList(allIndices);
        for (Integer pkIndex : pkIndices) {
            xmlIndices.remove(pkIndex);
        }
        int xmlIndex = (Integer)xmlIndices.get(0);
        try {
            this.casPopulator.populateCas((InputStream)new ByteArrayInputStream(documentData[xmlIndex]), jCas);
        }
        catch (Exception e) {
            log.error("Could not parse document {}.", (Object)pkString, (Object)e);
            throw e;
        }
        Header header = (Header)JCasUtil.selectSingle((JCas)jCas, Header.class);
        if (StringUtils.isBlank((CharSequence)header.getDocId())) {
            log.debug("Document has no docId set. Derived the ID {} from the primary key and setting it as the Header#docId feature.", (Object)pkString);
            header.setDocId(pkString);
        }
    }

    private Map<String, String> fetchCurrentHashesFromDatabase(RowBatch rowBatch) throws AnalysisEngineProcessException {
        if (this.dbc == null) {
            this.dbc = this.getDataBaseConnector(rowBatch.getCostosysConfiguration());
        }
        if (this.xmiStorageDataTable != null && this.dbc.tableExists(this.xmiStorageDataTable) && rowBatch.getIdentifiers() != null && rowBatch.getIdentifiers().size() > 0) {
            String hashColumn = this.documentItemToHash + "_sha256";
            ArrayList<String[]> documentIds = new ArrayList<String[]>(rowBatch.getIdentifiers().size());
            for (StringArray pkArray : rowBatch.getIdentifiers()) {
                documentIds.add(pkArray.toStringArray());
            }
            HashMap<String, String> id2hash = new HashMap<String, String>(documentIds.size());
            String sql = null;
            try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection();){
                FieldConfig xmiTableSchema = this.dbc.getFieldConfiguration(this.xmiStorageDataTableSchema);
                String idQuery = documentIds.stream().map(key -> (String[])Arrays.stream(key).map(part -> "%s='" + part + "'").toArray(String[]::new)).map(arg_0 -> ((FieldConfig)xmiTableSchema).expandPKNames(arg_0)).map(expandedKeys -> String.join((CharSequence)" AND ", expandedKeys)).collect(Collectors.joining(" OR "));
                sql = String.format("SELECT %s,%s FROM %s WHERE %s", xmiTableSchema.getPrimaryKeyString(), hashColumn, this.xmiStorageDataTable, idQuery);
                ResultSet rs = conn.createStatement().executeQuery(sql);
                while (rs.next()) {
                    StringBuilder pkSb = new StringBuilder();
                    for (int i = 0; i < xmiTableSchema.getPrimaryKey().length; ++i) {
                        pkSb.append(rs.getString(i + 1)).append(',');
                    }
                    pkSb.deleteCharAt(pkSb.length() - 1);
                    String hash = rs.getString(xmiTableSchema.getPrimaryKey().length + 1);
                    id2hash.put(pkSb.toString(), hash);
                }
            }
            catch (SQLException e) {
                log.error("Could not retrieve hashes from the database. SQL query was '{}':", sql, (Object)e);
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            return id2hash;
        }
        return null;
    }

    private void setToVisitAnnotation(JCas jCas, String pkString) {
        if (this.xmiStorageDataTable != null && this.xmiStorageDataTable != null) {
            String existingHash = this.docId2HashMap.get(pkString);
            if (existingHash != null) {
                String newHash = this.getHash(jCas);
                if (existingHash.equals(newHash)) {
                    if (log.isTraceEnabled()) {
                        log.trace("Document {} has a document text hash that equals the one present in the database. Creating a ToVisit annotation routing it only to the components with delegate keys {}.", (Object)pkString, (Object)this.toVisitKeys);
                    }
                    ToVisit toVisit = new ToVisit(jCas);
                    if (this.toVisitKeys != null && this.toVisitKeys.length != 0) {
                        StringArray keysArray = new StringArray(jCas, this.toVisitKeys.length);
                        keysArray.copyFromArray(this.toVisitKeys, 0, 0, this.toVisitKeys.length);
                        toVisit.setDelegateKeys(keysArray);
                    }
                    toVisit.addToIndexes();
                }
            } else {
                log.trace("No existing hash was found for document {}", (Object)pkString);
            }
        }
    }

    private String getHash(JCas newCas) {
        String documentText = newCas.getDocumentText();
        byte[] sha = DigestUtils.sha256((byte[])documentText.getBytes());
        return Base64.encodeBase64String((byte[])sha);
    }
}

