/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.components.sec.dispatcher.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.plexus.components.sec.dispatcher.model.Config;
import org.sonatype.plexus.components.sec.dispatcher.model.ConfigProperty;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class SecurityConfigurationXpp3Reader {
    private boolean addDefaultEntities = true;

    private boolean checkFieldWithDuplicate(XmlPullParser parser2, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser2.getName().equals(tagName) && !parser2.getName().equals(alias)) {
            return false;
        }
        if (parsed.contains(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser2, null);
        }
        parsed.add(tagName);
        return true;
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        return this.getBooleanValue(s2, attribute, parser2, null);
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser2, String defaultValue) throws XmlPullParserException {
        if (s2 != null && s2.length() != 0) {
            return Boolean.valueOf(s2);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Byte.valueOf(s2);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser2, null);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s2, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        if (s2 != null) {
            return s2.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s2, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        return this.getDateValue(s2, attribute, null, parser2);
    }

    private Date getDateValue(String s2, String attribute, String dateFormat, XmlPullParser parser2) throws XmlPullParserException {
        if (s2 != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s2));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage());
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s2);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage());
            }
        }
        return null;
    }

    private double getDoubleValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Double.valueOf(s2);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser2, null);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Float.valueOf(s2).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser2, null);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Integer.valueOf(s2);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser2, null);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Long.valueOf(s2);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser2, null);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        if (s2 == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser2, null);
        }
        return s2;
    }

    private short getShortValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Short.valueOf(s2);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser2, null);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s2) {
        if (s2 != null) {
            s2 = s2.trim();
        }
        return s2;
    }

    private Config parseConfig(String tagName, XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        Config config = new Config();
        HashSet parsed = new HashSet();
        while (parser2.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                config.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                ArrayList<ConfigProperty> properties = new ArrayList<ConfigProperty>();
                config.setProperties(properties);
                while (parser2.nextTag() == 2) {
                    if (parser2.getName().equals("property")) {
                        properties.add(this.parseConfigProperty("property", parser2, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser2.getName() + "'", parser2, null);
                    }
                    while (parser2.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser2.getName() + "'", parser2, null);
            }
            while (parser2.next() != 3) {
            }
        }
        return config;
    }

    private ConfigProperty parseConfigProperty(String tagName, XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        ConfigProperty configProperty = new ConfigProperty();
        HashSet parsed = new HashSet();
        while (parser2.nextTag() == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                configProperty.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "value", null, parsed)) {
                configProperty.setValue(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser2.getName() + "'", parser2, null);
            }
            while (parser2.next() != 3) {
            }
        }
        return configProperty;
    }

    private SettingsSecurity parseSettingsSecurity(String tagName, XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        SettingsSecurity settingsSecurity = new SettingsSecurity();
        HashSet parsed = new HashSet();
        int eventType = parser2.getEventType();
        boolean foundRoot = false;
        settingsSecurity.setModelEncoding(parser2.getInputEncoding());
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser2.getName().equals(tagName)) {
                    foundRoot = true;
                } else {
                    if (strict && !foundRoot) {
                        throw new XmlPullParserException("Expected root element '" + tagName + "' but found '" + parser2.getName() + "'", parser2, null);
                    }
                    if (this.checkFieldWithDuplicate(parser2, "master", null, parsed)) {
                        settingsSecurity.setMaster(this.getTrimmedValue(parser2.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser2, "relocation", null, parsed)) {
                        settingsSecurity.setRelocation(this.getTrimmedValue(parser2.nextText()));
                    } else if (this.checkFieldWithDuplicate(parser2, "configurations", null, parsed)) {
                        ArrayList<Config> configurations = new ArrayList<Config>();
                        settingsSecurity.setConfigurations(configurations);
                        while (parser2.nextTag() == 2) {
                            if (parser2.getName().equals("configuration")) {
                                configurations.add(this.parseConfig("configuration", parser2, strict));
                                continue;
                            }
                            if (strict) {
                                throw new XmlPullParserException("Unrecognised association: '" + parser2.getName() + "'", parser2, null);
                            }
                            while (parser2.next() != 3) {
                            }
                        }
                    } else if (strict) {
                        throw new XmlPullParserException("Unrecognised tag: '" + parser2.getName() + "'", parser2, null);
                    }
                }
            }
            eventType = parser2.next();
        }
        return settingsSecurity;
    }

    public SettingsSecurity read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser2 = new MXParser();
        parser2.setInput(reader);
        if (this.addDefaultEntities) {
            parser2.defineEntityReplacementText("nbsp", "\u00a0");
            parser2.defineEntityReplacementText("iexcl", "\u00a1");
            parser2.defineEntityReplacementText("cent", "\u00a2");
            parser2.defineEntityReplacementText("pound", "\u00a3");
            parser2.defineEntityReplacementText("curren", "\u00a4");
            parser2.defineEntityReplacementText("yen", "\u00a5");
            parser2.defineEntityReplacementText("brvbar", "\u00a6");
            parser2.defineEntityReplacementText("sect", "\u00a7");
            parser2.defineEntityReplacementText("uml", "\u00a8");
            parser2.defineEntityReplacementText("copy", "\u00a9");
            parser2.defineEntityReplacementText("ordf", "\u00aa");
            parser2.defineEntityReplacementText("laquo", "\u00ab");
            parser2.defineEntityReplacementText("not", "\u00ac");
            parser2.defineEntityReplacementText("shy", "\u00ad");
            parser2.defineEntityReplacementText("reg", "\u00ae");
            parser2.defineEntityReplacementText("macr", "\u00af");
            parser2.defineEntityReplacementText("deg", "\u00b0");
            parser2.defineEntityReplacementText("plusmn", "\u00b1");
            parser2.defineEntityReplacementText("sup2", "\u00b2");
            parser2.defineEntityReplacementText("sup3", "\u00b3");
            parser2.defineEntityReplacementText("acute", "\u00b4");
            parser2.defineEntityReplacementText("micro", "\u00b5");
            parser2.defineEntityReplacementText("para", "\u00b6");
            parser2.defineEntityReplacementText("middot", "\u00b7");
            parser2.defineEntityReplacementText("cedil", "\u00b8");
            parser2.defineEntityReplacementText("sup1", "\u00b9");
            parser2.defineEntityReplacementText("ordm", "\u00ba");
            parser2.defineEntityReplacementText("raquo", "\u00bb");
            parser2.defineEntityReplacementText("frac14", "\u00bc");
            parser2.defineEntityReplacementText("frac12", "\u00bd");
            parser2.defineEntityReplacementText("frac34", "\u00be");
            parser2.defineEntityReplacementText("iquest", "\u00bf");
            parser2.defineEntityReplacementText("Agrave", "\u00c0");
            parser2.defineEntityReplacementText("Aacute", "\u00c1");
            parser2.defineEntityReplacementText("Acirc", "\u00c2");
            parser2.defineEntityReplacementText("Atilde", "\u00c3");
            parser2.defineEntityReplacementText("Auml", "\u00c4");
            parser2.defineEntityReplacementText("Aring", "\u00c5");
            parser2.defineEntityReplacementText("AElig", "\u00c6");
            parser2.defineEntityReplacementText("Ccedil", "\u00c7");
            parser2.defineEntityReplacementText("Egrave", "\u00c8");
            parser2.defineEntityReplacementText("Eacute", "\u00c9");
            parser2.defineEntityReplacementText("Ecirc", "\u00ca");
            parser2.defineEntityReplacementText("Euml", "\u00cb");
            parser2.defineEntityReplacementText("Igrave", "\u00cc");
            parser2.defineEntityReplacementText("Iacute", "\u00cd");
            parser2.defineEntityReplacementText("Icirc", "\u00ce");
            parser2.defineEntityReplacementText("Iuml", "\u00cf");
            parser2.defineEntityReplacementText("ETH", "\u00d0");
            parser2.defineEntityReplacementText("Ntilde", "\u00d1");
            parser2.defineEntityReplacementText("Ograve", "\u00d2");
            parser2.defineEntityReplacementText("Oacute", "\u00d3");
            parser2.defineEntityReplacementText("Ocirc", "\u00d4");
            parser2.defineEntityReplacementText("Otilde", "\u00d5");
            parser2.defineEntityReplacementText("Ouml", "\u00d6");
            parser2.defineEntityReplacementText("times", "\u00d7");
            parser2.defineEntityReplacementText("Oslash", "\u00d8");
            parser2.defineEntityReplacementText("Ugrave", "\u00d9");
            parser2.defineEntityReplacementText("Uacute", "\u00da");
            parser2.defineEntityReplacementText("Ucirc", "\u00db");
            parser2.defineEntityReplacementText("Uuml", "\u00dc");
            parser2.defineEntityReplacementText("Yacute", "\u00dd");
            parser2.defineEntityReplacementText("THORN", "\u00de");
            parser2.defineEntityReplacementText("szlig", "\u00df");
            parser2.defineEntityReplacementText("agrave", "\u00e0");
            parser2.defineEntityReplacementText("aacute", "\u00e1");
            parser2.defineEntityReplacementText("acirc", "\u00e2");
            parser2.defineEntityReplacementText("atilde", "\u00e3");
            parser2.defineEntityReplacementText("auml", "\u00e4");
            parser2.defineEntityReplacementText("aring", "\u00e5");
            parser2.defineEntityReplacementText("aelig", "\u00e6");
            parser2.defineEntityReplacementText("ccedil", "\u00e7");
            parser2.defineEntityReplacementText("egrave", "\u00e8");
            parser2.defineEntityReplacementText("eacute", "\u00e9");
            parser2.defineEntityReplacementText("ecirc", "\u00ea");
            parser2.defineEntityReplacementText("euml", "\u00eb");
            parser2.defineEntityReplacementText("igrave", "\u00ec");
            parser2.defineEntityReplacementText("iacute", "\u00ed");
            parser2.defineEntityReplacementText("icirc", "\u00ee");
            parser2.defineEntityReplacementText("iuml", "\u00ef");
            parser2.defineEntityReplacementText("eth", "\u00f0");
            parser2.defineEntityReplacementText("ntilde", "\u00f1");
            parser2.defineEntityReplacementText("ograve", "\u00f2");
            parser2.defineEntityReplacementText("oacute", "\u00f3");
            parser2.defineEntityReplacementText("ocirc", "\u00f4");
            parser2.defineEntityReplacementText("otilde", "\u00f5");
            parser2.defineEntityReplacementText("ouml", "\u00f6");
            parser2.defineEntityReplacementText("divide", "\u00f7");
            parser2.defineEntityReplacementText("oslash", "\u00f8");
            parser2.defineEntityReplacementText("ugrave", "\u00f9");
            parser2.defineEntityReplacementText("uacute", "\u00fa");
            parser2.defineEntityReplacementText("ucirc", "\u00fb");
            parser2.defineEntityReplacementText("uuml", "\u00fc");
            parser2.defineEntityReplacementText("yacute", "\u00fd");
            parser2.defineEntityReplacementText("thorn", "\u00fe");
            parser2.defineEntityReplacementText("yuml", "\u00ff");
            parser2.defineEntityReplacementText("OElig", "\u0152");
            parser2.defineEntityReplacementText("oelig", "\u0153");
            parser2.defineEntityReplacementText("Scaron", "\u0160");
            parser2.defineEntityReplacementText("scaron", "\u0161");
            parser2.defineEntityReplacementText("Yuml", "\u0178");
            parser2.defineEntityReplacementText("circ", "\u02c6");
            parser2.defineEntityReplacementText("tilde", "\u02dc");
            parser2.defineEntityReplacementText("ensp", "\u2002");
            parser2.defineEntityReplacementText("emsp", "\u2003");
            parser2.defineEntityReplacementText("thinsp", "\u2009");
            parser2.defineEntityReplacementText("zwnj", "\u200c");
            parser2.defineEntityReplacementText("zwj", "\u200d");
            parser2.defineEntityReplacementText("lrm", "\u200e");
            parser2.defineEntityReplacementText("rlm", "\u200f");
            parser2.defineEntityReplacementText("ndash", "\u2013");
            parser2.defineEntityReplacementText("mdash", "\u2014");
            parser2.defineEntityReplacementText("lsquo", "\u2018");
            parser2.defineEntityReplacementText("rsquo", "\u2019");
            parser2.defineEntityReplacementText("sbquo", "\u201a");
            parser2.defineEntityReplacementText("ldquo", "\u201c");
            parser2.defineEntityReplacementText("rdquo", "\u201d");
            parser2.defineEntityReplacementText("bdquo", "\u201e");
            parser2.defineEntityReplacementText("dagger", "\u2020");
            parser2.defineEntityReplacementText("Dagger", "\u2021");
            parser2.defineEntityReplacementText("permil", "\u2030");
            parser2.defineEntityReplacementText("lsaquo", "\u2039");
            parser2.defineEntityReplacementText("rsaquo", "\u203a");
            parser2.defineEntityReplacementText("euro", "\u20ac");
            parser2.defineEntityReplacementText("fnof", "\u0192");
            parser2.defineEntityReplacementText("Alpha", "\u0391");
            parser2.defineEntityReplacementText("Beta", "\u0392");
            parser2.defineEntityReplacementText("Gamma", "\u0393");
            parser2.defineEntityReplacementText("Delta", "\u0394");
            parser2.defineEntityReplacementText("Epsilon", "\u0395");
            parser2.defineEntityReplacementText("Zeta", "\u0396");
            parser2.defineEntityReplacementText("Eta", "\u0397");
            parser2.defineEntityReplacementText("Theta", "\u0398");
            parser2.defineEntityReplacementText("Iota", "\u0399");
            parser2.defineEntityReplacementText("Kappa", "\u039a");
            parser2.defineEntityReplacementText("Lambda", "\u039b");
            parser2.defineEntityReplacementText("Mu", "\u039c");
            parser2.defineEntityReplacementText("Nu", "\u039d");
            parser2.defineEntityReplacementText("Xi", "\u039e");
            parser2.defineEntityReplacementText("Omicron", "\u039f");
            parser2.defineEntityReplacementText("Pi", "\u03a0");
            parser2.defineEntityReplacementText("Rho", "\u03a1");
            parser2.defineEntityReplacementText("Sigma", "\u03a3");
            parser2.defineEntityReplacementText("Tau", "\u03a4");
            parser2.defineEntityReplacementText("Upsilon", "\u03a5");
            parser2.defineEntityReplacementText("Phi", "\u03a6");
            parser2.defineEntityReplacementText("Chi", "\u03a7");
            parser2.defineEntityReplacementText("Psi", "\u03a8");
            parser2.defineEntityReplacementText("Omega", "\u03a9");
            parser2.defineEntityReplacementText("alpha", "\u03b1");
            parser2.defineEntityReplacementText("beta", "\u03b2");
            parser2.defineEntityReplacementText("gamma", "\u03b3");
            parser2.defineEntityReplacementText("delta", "\u03b4");
            parser2.defineEntityReplacementText("epsilon", "\u03b5");
            parser2.defineEntityReplacementText("zeta", "\u03b6");
            parser2.defineEntityReplacementText("eta", "\u03b7");
            parser2.defineEntityReplacementText("theta", "\u03b8");
            parser2.defineEntityReplacementText("iota", "\u03b9");
            parser2.defineEntityReplacementText("kappa", "\u03ba");
            parser2.defineEntityReplacementText("lambda", "\u03bb");
            parser2.defineEntityReplacementText("mu", "\u03bc");
            parser2.defineEntityReplacementText("nu", "\u03bd");
            parser2.defineEntityReplacementText("xi", "\u03be");
            parser2.defineEntityReplacementText("omicron", "\u03bf");
            parser2.defineEntityReplacementText("pi", "\u03c0");
            parser2.defineEntityReplacementText("rho", "\u03c1");
            parser2.defineEntityReplacementText("sigmaf", "\u03c2");
            parser2.defineEntityReplacementText("sigma", "\u03c3");
            parser2.defineEntityReplacementText("tau", "\u03c4");
            parser2.defineEntityReplacementText("upsilon", "\u03c5");
            parser2.defineEntityReplacementText("phi", "\u03c6");
            parser2.defineEntityReplacementText("chi", "\u03c7");
            parser2.defineEntityReplacementText("psi", "\u03c8");
            parser2.defineEntityReplacementText("omega", "\u03c9");
            parser2.defineEntityReplacementText("thetasym", "\u03d1");
            parser2.defineEntityReplacementText("upsih", "\u03d2");
            parser2.defineEntityReplacementText("piv", "\u03d6");
            parser2.defineEntityReplacementText("bull", "\u2022");
            parser2.defineEntityReplacementText("hellip", "\u2026");
            parser2.defineEntityReplacementText("prime", "\u2032");
            parser2.defineEntityReplacementText("Prime", "\u2033");
            parser2.defineEntityReplacementText("oline", "\u203e");
            parser2.defineEntityReplacementText("frasl", "\u2044");
            parser2.defineEntityReplacementText("weierp", "\u2118");
            parser2.defineEntityReplacementText("image", "\u2111");
            parser2.defineEntityReplacementText("real", "\u211c");
            parser2.defineEntityReplacementText("trade", "\u2122");
            parser2.defineEntityReplacementText("alefsym", "\u2135");
            parser2.defineEntityReplacementText("larr", "\u2190");
            parser2.defineEntityReplacementText("uarr", "\u2191");
            parser2.defineEntityReplacementText("rarr", "\u2192");
            parser2.defineEntityReplacementText("darr", "\u2193");
            parser2.defineEntityReplacementText("harr", "\u2194");
            parser2.defineEntityReplacementText("crarr", "\u21b5");
            parser2.defineEntityReplacementText("lArr", "\u21d0");
            parser2.defineEntityReplacementText("uArr", "\u21d1");
            parser2.defineEntityReplacementText("rArr", "\u21d2");
            parser2.defineEntityReplacementText("dArr", "\u21d3");
            parser2.defineEntityReplacementText("hArr", "\u21d4");
            parser2.defineEntityReplacementText("forall", "\u2200");
            parser2.defineEntityReplacementText("part", "\u2202");
            parser2.defineEntityReplacementText("exist", "\u2203");
            parser2.defineEntityReplacementText("empty", "\u2205");
            parser2.defineEntityReplacementText("nabla", "\u2207");
            parser2.defineEntityReplacementText("isin", "\u2208");
            parser2.defineEntityReplacementText("notin", "\u2209");
            parser2.defineEntityReplacementText("ni", "\u220b");
            parser2.defineEntityReplacementText("prod", "\u220f");
            parser2.defineEntityReplacementText("sum", "\u2211");
            parser2.defineEntityReplacementText("minus", "\u2212");
            parser2.defineEntityReplacementText("lowast", "\u2217");
            parser2.defineEntityReplacementText("radic", "\u221a");
            parser2.defineEntityReplacementText("prop", "\u221d");
            parser2.defineEntityReplacementText("infin", "\u221e");
            parser2.defineEntityReplacementText("ang", "\u2220");
            parser2.defineEntityReplacementText("and", "\u2227");
            parser2.defineEntityReplacementText("or", "\u2228");
            parser2.defineEntityReplacementText("cap", "\u2229");
            parser2.defineEntityReplacementText("cup", "\u222a");
            parser2.defineEntityReplacementText("int", "\u222b");
            parser2.defineEntityReplacementText("there4", "\u2234");
            parser2.defineEntityReplacementText("sim", "\u223c");
            parser2.defineEntityReplacementText("cong", "\u2245");
            parser2.defineEntityReplacementText("asymp", "\u2248");
            parser2.defineEntityReplacementText("ne", "\u2260");
            parser2.defineEntityReplacementText("equiv", "\u2261");
            parser2.defineEntityReplacementText("le", "\u2264");
            parser2.defineEntityReplacementText("ge", "\u2265");
            parser2.defineEntityReplacementText("sub", "\u2282");
            parser2.defineEntityReplacementText("sup", "\u2283");
            parser2.defineEntityReplacementText("nsub", "\u2284");
            parser2.defineEntityReplacementText("sube", "\u2286");
            parser2.defineEntityReplacementText("supe", "\u2287");
            parser2.defineEntityReplacementText("oplus", "\u2295");
            parser2.defineEntityReplacementText("otimes", "\u2297");
            parser2.defineEntityReplacementText("perp", "\u22a5");
            parser2.defineEntityReplacementText("sdot", "\u22c5");
            parser2.defineEntityReplacementText("lceil", "\u2308");
            parser2.defineEntityReplacementText("rceil", "\u2309");
            parser2.defineEntityReplacementText("lfloor", "\u230a");
            parser2.defineEntityReplacementText("rfloor", "\u230b");
            parser2.defineEntityReplacementText("lang", "\u2329");
            parser2.defineEntityReplacementText("rang", "\u232a");
            parser2.defineEntityReplacementText("loz", "\u25ca");
            parser2.defineEntityReplacementText("spades", "\u2660");
            parser2.defineEntityReplacementText("clubs", "\u2663");
            parser2.defineEntityReplacementText("hearts", "\u2665");
            parser2.defineEntityReplacementText("diams", "\u2666");
        }
        parser2.next();
        return this.parseSettingsSecurity("settingsSecurity", parser2, strict);
    }

    public SettingsSecurity read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public SettingsSecurity read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader(in);
        return this.read(reader, strict);
    }

    public SettingsSecurity read(InputStream in) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader(in);
        return this.read(reader);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

