/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.beryx.textio.AbstractTextTerminal;
import org.beryx.textio.PropertiesPrefixes;

@PropertiesPrefixes(value={"mock"})
public class MockTextTerminal
extends AbstractTextTerminal<MockTextTerminal> {
    public static final int DEFAULT_MAX_READS = 100;
    private int maxReads = 100;
    private final List<String> inputs = new ArrayList<String>();
    private int inputIndex = -1;
    private final StringBuilder outputBuilder = new StringBuilder();

    @Override
    public String read(boolean masking) {
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("No entries available in the 'inputs' list");
        }
        ++this.inputIndex;
        if (this.inputIndex >= this.maxReads) {
            throw new RuntimeException("Too many read calls");
        }
        String val = this.inputs.get(this.inputIndex < this.inputs.size() ? this.inputIndex : -1);
        this.outputBuilder.append(val).append('\n');
        return val;
    }

    @Override
    public void rawPrint(String message) {
        this.outputBuilder.append(message);
    }

    @Override
    public void println() {
        this.outputBuilder.append('\n');
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public String getOutput() {
        return MockTextTerminal.stripAll(this.outputBuilder.toString());
    }

    public int getReadCalls() {
        return this.inputIndex + 1;
    }

    public int getMaxReads() {
        return this.maxReads;
    }

    public void setMaxReads(int maxReads) {
        this.maxReads = maxReads;
    }

    public static String stripAll(String text) {
        if (text == null) {
            return null;
        }
        return Arrays.stream(text.split("\\R")).map(s2 -> s2.replaceAll("\\t", "")).map(s2 -> s2.replaceAll("^\\s+|\\s+$", "")).filter(s2 -> !s2.isEmpty()).collect(Collectors.joining("\n"));
    }
}

