/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.jline;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.internal.Configuration;
import org.beryx.awt.color.ColorFactory;
import org.beryx.textio.AbstractTextTerminal;
import org.beryx.textio.KeyCombination;
import org.beryx.textio.PropertiesPrefixes;
import org.beryx.textio.ReadHandlerData;
import org.beryx.textio.ReadInterruptionData;
import org.beryx.textio.ReadInterruptionException;
import org.beryx.textio.ReadInterruptionStrategy;
import org.beryx.textio.TerminalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PropertiesPrefixes(value={"jline"})
public class JLineTextTerminal
extends AbstractTextTerminal<JLineTextTerminal> {
    private static final Logger logger = LoggerFactory.getLogger(JLineTextTerminal.class);
    private static final Consumer<JLineTextTerminal> DEFAULT_USER_INTERRUPT_HANDLER = textTerm -> System.exit(-1);
    private static String ANSI_RESET = "\u001b[0m";
    private static String ANSI_BOLD = "\u001b[1m";
    private static String ANSI_ITALIC = "\u001b[3m";
    private static String ANSI_UNDERLINE = "\u001b[4m";
    private static Map<String, Integer> ANSI_COLOR_MAP = new LinkedHashMap<String, Integer>();
    private static Color[] STANDARD_COLORS;
    private final ConsoleReader reader;
    private Consumer<JLineTextTerminal> userInterruptHandler = DEFAULT_USER_INTERRUPT_HANDLER;
    private boolean abortRead = true;
    private AnsiColorMode ansiColorMode = AnsiColorMode.STANDARD;
    private StyleData inputStyleData = new StyleData();
    private StyleData promptStyleData = new StyleData();
    private boolean moveToLineStartRequired = false;
    private String initialReadBuffer;

    private static String getStandardColorCode(Color color) {
        double bestDist = Double.MAX_VALUE;
        int bestIndex = -1;
        for (int i = 0; i < STANDARD_COLORS.length; ++i) {
            double dist = JLineTextTerminal.getColorDistance(color, STANDARD_COLORS[i]);
            if (!(dist < bestDist)) continue;
            bestDist = dist;
            bestIndex = i;
        }
        return "" + bestIndex;
    }

    private static double getColorDistance(Color col1, Color col2) {
        double r1 = (double)col1.getRed() / 255.0;
        double g1 = (double)col1.getGreen() / 255.0;
        double b1 = (double)col1.getBlue() / 255.0;
        double r2 = (double)col2.getRed() / 255.0;
        double g2 = (double)col2.getGreen() / 255.0;
        double b2 = (double)col2.getBlue() / 255.0;
        double rmean = (r1 + r2) / 2.0;
        double dr = r1 - r2;
        double dg = g1 - g2;
        double db = b1 - b2;
        return Math.sqrt((2.0 + rmean) * dr * dr + 4.0 * dg * dg + (3.0 - rmean) * db * db);
    }

    private static String getIndexedColorCode(Color color) {
        double r = color.getRed();
        double g2 = color.getGreen();
        double b = color.getBlue();
        int val = 16 + 36 * JLineTextTerminal.mapTo6(r) + 6 * JLineTextTerminal.mapTo6(g2) + JLineTextTerminal.mapTo6(b);
        return "8;5;" + val;
    }

    private static String getRGBColorCode(Color color) {
        int r = color.getRed();
        int g2 = color.getGreen();
        int b = color.getBlue();
        return "8;2;" + r + ";" + g2 + ";" + b;
    }

    public static int getStandardColorCode(String colorName) {
        return ANSI_COLOR_MAP.getOrDefault(colorName.toLowerCase(), -1);
    }

    public Optional<String> getColorCode(String colorName) {
        if (colorName == null || colorName.isEmpty()) {
            return Optional.empty();
        }
        try {
            int code = JLineTextTerminal.getStandardColorCode(colorName);
            if (code >= 0) {
                return Optional.of("" + code);
            }
            Color color = ColorFactory.web(colorName);
            return Optional.of(this.ansiColorMode.getAnsiColorCode(color));
        }
        catch (Exception exception) {
            logger.warn("Invalid color: {}", (Object)colorName);
            return Optional.empty();
        }
    }

    private static int mapTo6(double val) {
        if (val < 0.0) {
            val = 0.0;
        }
        if (val > 255.0) {
            val = 255.0;
        }
        return (int)(val * 6.0 / 256.0);
    }

    private String getAnsiColorWithPrefix(int prefix, String colorName) {
        String ansiCode = this.getColorCode(colorName).map(col -> "\u001b[1;" + prefix + col + "m").orElse("");
        logger.debug("ansiColor({}, {}) = {}", prefix, colorName, ansiCode);
        return ansiCode;
    }

    public String getAnsiColor(String colorName) {
        return this.getAnsiColorWithPrefix(3, colorName);
    }

    public String getAnsiBackgroundColor(String colorName) {
        return this.getAnsiColorWithPrefix(4, colorName);
    }

    public static ConsoleReader createReader() {
        try {
            if (System.console() == null) {
                throw new IllegalArgumentException("Console not available.");
            }
            ConsoleReader consoleReader = new ConsoleReader();
            boolean expandEvents = Configuration.getBoolean("jline.expandevents", false);
            consoleReader.setExpandEvents(expandEvents);
            return consoleReader;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create a JLine ConsoleReader.", e);
        }
    }

    public JLineTextTerminal() {
        this(JLineTextTerminal.createReader());
    }

    public JLineTextTerminal(ConsoleReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        reader.setHandleUserInterrupt(true);
        this.reader = reader;
        TerminalProperties<JLineTextTerminal> props = this.getProperties();
        props.addStringListener("prompt.color", null, (term, newVal) -> this.setPromptColor(newVal));
        props.addStringListener("prompt.bgcolor", null, (term, newVal) -> this.setPromptBackgroundColor(newVal));
        props.addBooleanListener("prompt.bold", false, (term, newVal) -> this.setPromptBold(newVal));
        props.addBooleanListener("prompt.italic", false, (term, newVal) -> this.setPromptItalic(newVal));
        props.addBooleanListener("prompt.underline", false, (term, newVal) -> this.setPromptUnderline(newVal));
        props.addStringListener("input.color", null, (term, newVal) -> this.setInputColor(newVal));
        props.addStringListener("input.bgcolor", null, (term, newVal) -> this.setInputBackgroundColor(newVal));
        props.addBooleanListener("input.bold", false, (term, newVal) -> this.setInputBold(newVal));
        props.addBooleanListener("input.italic", false, (term, newVal) -> this.setInputItalic(newVal));
        props.addBooleanListener("input.underline", false, (term, newVal) -> this.setInputUnderline(newVal));
        props.addStringListener("ansi.color.mode", AnsiColorMode.STANDARD.toString(), (term, newVal) -> this.setAnsiColorMode(newVal));
    }

    /*
     * Exception decompiling
     */
    @Override
    public String read(boolean masking) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void rawPrint(String message) {
        String msgPrefix = "";
        if (this.moveToLineStartRequired) {
            this.moveToLineStartRequired = false;
            msgPrefix = "\r";
        }
        this.printAnsi(this.getAnsiPrefix(this.promptStyleData) + msgPrefix + message + ANSI_RESET);
    }

    public void printAnsi(String message) {
        try {
            this.reader.setPrompt(message);
            this.reader.drawLine();
            this.reader.flush();
        }
        catch (IOException e) {
            logger.error("print error.", e);
        }
        finally {
            this.reader.setPrompt(null);
        }
    }

    public String getAnsiPrefix(StyleData styleData) {
        return styleData.ansiColor + styleData.ansiBackgroundColor + (styleData.bold ? ANSI_BOLD : "") + (styleData.italic ? ANSI_ITALIC : "") + (styleData.underline ? ANSI_UNDERLINE : "");
    }

    @Override
    public void println() {
        try {
            this.reader.println();
            this.reader.flush();
        }
        catch (IOException e) {
            logger.error("println error.", e);
        }
    }

    @Override
    public boolean resetLine() {
        try {
            this.reader.resetPromptLine("", "", 0);
            return true;
        }
        catch (IOException e) {
            logger.error("resetLine error.", e);
            return false;
        }
    }

    @Override
    public boolean moveToLineStart() {
        this.moveToLineStartRequired = true;
        return true;
    }

    @Override
    public boolean registerUserInterruptHandler(Consumer<JLineTextTerminal> handler, boolean abortRead) {
        this.userInterruptHandler = handler != null ? handler : DEFAULT_USER_INTERRUPT_HANDLER;
        this.abortRead = abortRead;
        return true;
    }

    @Override
    public boolean registerHandler(String keyStroke, Function<JLineTextTerminal, ReadHandlerData> handler) {
        String keySeq = JLineTextTerminal.getKeySequence(keyStroke);
        if (keySeq == null) {
            return false;
        }
        this.reader.getKeys().bind(keySeq, new UserHandler(this, handler));
        return true;
    }

    @Override
    public void dispose(String resultData) {
        this.printAnsi(ANSI_RESET);
        this.reader.close();
    }

    @Override
    public void abort() {
        this.printAnsi(ANSI_RESET);
        this.reader.close();
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public void setPromptColor(String colorName) {
        this.promptStyleData.ansiColor = this.getAnsiColor(colorName);
    }

    public void setPromptBackgroundColor(String colorName) {
        this.promptStyleData.ansiBackgroundColor = this.getAnsiBackgroundColor(colorName);
    }

    public void setPromptBold(boolean bold) {
        this.promptStyleData.bold = bold;
    }

    public void setPromptItalic(boolean italic) {
        this.promptStyleData.italic = italic;
    }

    public void setPromptUnderline(boolean underline) {
        this.promptStyleData.underline = underline;
    }

    public void setInputColor(String colorName) {
        this.inputStyleData.ansiColor = this.getAnsiColor(colorName);
    }

    public void setInputBackgroundColor(String colorName) {
        this.inputStyleData.ansiBackgroundColor = this.getAnsiBackgroundColor(colorName);
    }

    public void setInputBold(boolean bold) {
        this.inputStyleData.bold = bold;
    }

    public void setInputItalic(boolean italic) {
        this.inputStyleData.italic = italic;
    }

    public void setInputUnderline(boolean underline) {
        this.inputStyleData.underline = underline;
    }

    public void setAnsiColorMode(String mode) {
        if (mode == null || mode.isEmpty()) {
            this.ansiColorMode = AnsiColorMode.STANDARD;
            return;
        }
        try {
            this.ansiColorMode = AnsiColorMode.valueOf(mode.toUpperCase());
            logger.debug("ansiColorMed set to: {}", (Object)this.ansiColorMode);
        }
        catch (Exception e) {
            logger.warn("Invalid value for ansiColorMode: {}", (Object)mode);
        }
    }

    public static String getKeySequence(String keyStroke) {
        KeyCombination kc = KeyCombination.of(keyStroke);
        if (kc == null) {
            return null;
        }
        if (kc.isTyped()) {
            return String.valueOf(kc.getChar());
        }
        int code = kc.getCode();
        if (code < 65 || code > 90) {
            return null;
        }
        if (kc.isCtrlDown()) {
            if (kc.isAltDown()) {
                return null;
            }
            return String.valueOf((char)(code + 1 - 65));
        }
        if (kc.isAltDown()) {
            if (!kc.isShiftDown()) {
                code += 32;
            }
            return String.format("%c%c", Character.valueOf('\u001b'), Character.valueOf((char)code));
        }
        return null;
    }

    static {
        ANSI_COLOR_MAP.put("default", -1);
        ANSI_COLOR_MAP.put("black", 0);
        ANSI_COLOR_MAP.put("red", 1);
        ANSI_COLOR_MAP.put("green", 2);
        ANSI_COLOR_MAP.put("yellow", 3);
        ANSI_COLOR_MAP.put("blue", 4);
        ANSI_COLOR_MAP.put("magenta", 5);
        ANSI_COLOR_MAP.put("cyan", 6);
        ANSI_COLOR_MAP.put("white", 7);
        STANDARD_COLORS = new Color[]{Color.BLACK, Color.RED, Color.GREEN, Color.YELLOW, Color.BLUE, Color.MAGENTA, Color.CYAN, Color.WHITE};
    }

    private static class UserHandler
    implements ActionListener {
        private final JLineTextTerminal textTerminal;
        private final Function<JLineTextTerminal, ReadHandlerData> handler;

        private UserHandler(JLineTextTerminal textTerminal, Function<JLineTextTerminal, ReadHandlerData> handler) {
            this.textTerminal = textTerminal;
            this.handler = handler;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CursorBuffer buf = this.textTerminal.reader.getCursorBuffer();
            String partialInput = buf.buffer.toString();
            buf.clear();
            ReadHandlerData handlerData = this.handler.apply(this.textTerminal);
            ReadInterruptionStrategy.Action action = handlerData.getAction();
            if (action != ReadInterruptionStrategy.Action.CONTINUE) {
                if (action == ReadInterruptionStrategy.Action.RESTART) {
                    this.textTerminal.initialReadBuffer = partialInput;
                }
                ReadInterruptionData interruptData = ReadInterruptionData.from(handlerData, partialInput);
                throw new ReadInterruptionException(interruptData, partialInput);
            }
            buf.write(partialInput);
        }
    }

    private static enum AnsiColorMode {
        STANDARD(x$0 -> JLineTextTerminal.access$300(x$0)),
        INDEXED(x$0 -> JLineTextTerminal.access$200(x$0)),
        RGB(x$0 -> JLineTextTerminal.access$100(x$0));

        private final Function<Color, String> colorCodeProvider;

        private AnsiColorMode(Function<Color, String> colorCodeProvider) {
            this.colorCodeProvider = colorCodeProvider;
        }

        String getAnsiColorCode(Color color) {
            return this.colorCodeProvider.apply(color);
        }
    }

    private static class StyleData {
        String ansiColor = "";
        String ansiBackgroundColor = "";
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;

        private StyleData() {
        }
    }
}

