/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.beryx.textio.InputReader;
import org.beryx.textio.TextTerminal;

public class BooleanInputReader
extends InputReader<Boolean, BooleanInputReader> {
    private String trueInput = "Y";
    private String falseInput = "N";

    public BooleanInputReader(Supplier<TextTerminal<?>> textTerminalSupplier) {
        super(textTerminalSupplier);
        this.valueFormatter = bVal -> bVal != false ? this.trueInput : this.falseInput;
    }

    public BooleanInputReader withTrueInput(String trueInput) {
        if (trueInput == null || trueInput.trim().isEmpty()) {
            throw new IllegalArgumentException("trueInput is empty");
        }
        this.trueInput = trueInput;
        return this;
    }

    public BooleanInputReader withFalseInput(String falseInput) {
        if (falseInput == null || falseInput.trim().isEmpty()) {
            throw new IllegalArgumentException("falseInput is empty");
        }
        this.falseInput = falseInput;
        return this;
    }

    @Override
    protected List<String> getDefaultErrorMessages(String s2) {
        List<String> errList = super.getDefaultErrorMessages(s2);
        errList.add("Expected: " + this.trueInput + " / " + this.falseInput);
        return errList;
    }

    @Override
    protected InputReader.ParseResult<Boolean> parse(String s2) {
        if (this.trueInput.equalsIgnoreCase(s2)) {
            return new InputReader.ParseResult<Boolean>(true);
        }
        if (this.falseInput.equalsIgnoreCase(s2)) {
            return new InputReader.ParseResult<Boolean>(false);
        }
        return new InputReader.ParseResult<Object>(null, this.getErrorMessages(s2));
    }

    @Override
    protected void printPrompt(List<String> prompt, TextTerminal<?> textTerminal) {
        List<String> boolPrompt = prompt;
        if (this.promptAdjustments && prompt != null && !prompt.isEmpty()) {
            String lastLine = prompt.get(prompt.size() - 1) + " (" + this.trueInput + "/" + this.falseInput + ")";
            boolPrompt = new ArrayList<String>(prompt);
            boolPrompt.set(boolPrompt.size() - 1, lastLine);
        }
        super.printPrompt(boolPrompt, textTerminal);
    }
}

