/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.impl;

import java.util.Arrays;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;
import org.apache.uima.jcas.impl.JCasHashMap;

class JCasHashMapSubMap {
    private static final boolean TUNE = false;
    private static final int PROBE_ADDR_INDEX = 0;
    private static final int PROBE_DELTA_INDEX = 1;
    static final TOP_Type RESERVE_TOP_TYPE_INSTANCE = new ReserveTopType();
    static final ThreadLocal<int[]> probeInfoGet = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[2];
        }
    };
    static final ThreadLocal<int[]> probeInfoPut = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[2];
        }
    };
    static final ThreadLocal<int[]> probeInfoPutInner = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[2];
        }
    };
    int[] histogram;
    int maxProbe = 0;
    int maxProbeAfterContinue = 0;
    int continues = 0;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition lockCondition = this.lock.newCondition();
    private int sizeWhichTriggersExpansion;
    int size;
    volatile FeatureStructureImpl[] table;
    private boolean secondTimeShrinkable = false;
    private final float loadFactor;
    private final int subMapInitialCapacity;
    private final int concurrencyLevelBits;

    JCasHashMapSubMap(float loadFactor, int subMapInitialCapacity, int concurrencyLevelBits) {
        this.loadFactor = loadFactor;
        this.subMapInitialCapacity = subMapInitialCapacity;
        this.concurrencyLevelBits = concurrencyLevelBits;
        this.newTable(subMapInitialCapacity);
    }

    private JCasHashMapSubMap newTable(int capacity) {
        this.table = this.newTableKeepSize(capacity);
        this.size = 0;
        return this;
    }

    private FeatureStructureImpl[] newTableKeepSize(int capacity) {
        assert (Integer.bitCount(capacity) == 1);
        FeatureStructureImpl[] t = new FeatureStructureImpl[capacity];
        this.sizeWhichTriggersExpansion = (int)((float)capacity * this.loadFactor);
        return t;
    }

    private void incrementSize() {
        assert (this.lock.getHoldCount() > 0);
        if (this.size >= this.sizeWhichTriggersExpansion) {
            this.increaseTableCapacity();
        }
        ++this.size;
    }

    void clear() {
        this.lock.lock();
        try {
            if (this.size < this.sizeWhichTriggersExpansion >>> 1) {
                if (this.secondTimeShrinkable) {
                    this.secondTimeShrinkable = false;
                    int newCapacity = Math.max(this.subMapInitialCapacity, this.table.length >>> 1);
                    if (newCapacity < this.table.length) {
                        this.newTable(newCapacity);
                    } else {
                        Arrays.fill(this.table, null);
                    }
                    this.size = 0;
                    return;
                }
                this.secondTimeShrinkable = true;
            } else {
                this.secondTimeShrinkable = false;
            }
            this.size = 0;
            Arrays.fill(this.table, null);
        }
        finally {
            this.lock.unlock();
        }
    }

    private FeatureStructureImpl find(FeatureStructureImpl[] localTable, int key, int hash, int[] probeInfo) {
        int bitMask = localTable.length - 1;
        int startProbe = probeInfo[0];
        int probeAddr = startProbe < 0 ? hash & bitMask : startProbe;
        FeatureStructureImpl m3 = localTable[probeAddr];
        if (m3 == null) {
            JCasHashMapSubMap.setProbeInfo(probeInfo, probeAddr, 0);
            return m3;
        }
        if (m3.getAddress() == key) {
            JCasHashMapSubMap.setProbeInfo(probeInfo, probeAddr, 0);
            return m3;
        }
        return this.find2(localTable, key, probeInfo, probeAddr);
    }

    private FeatureStructureImpl find2(FeatureStructureImpl[] localTable, int key, int[] probeInfo, int probeAddr) {
        boolean isContinue = false;
        int bitMask = localTable.length - 1;
        int probeDelta = probeInfo[1];
        int nbrProbes = 2;
        probeAddr = bitMask & probeAddr + probeDelta++;
        FeatureStructureImpl m3 = localTable[probeAddr];
        while (null != m3) {
            if (m3.getAddress() == key) {
                JCasHashMapSubMap.setProbeInfo(probeInfo, probeAddr, 0);
                return m3;
            }
            ++nbrProbes;
            probeAddr = bitMask & probeAddr + probeDelta++;
            m3 = localTable[probeAddr];
        }
        JCasHashMapSubMap.setProbeInfo(probeInfo, probeAddr, probeDelta);
        return m3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHistogram(int nbrProbes, boolean isContinue) {
        boolean needUnlock;
        if (!this.lock.isHeldByCurrentThread()) {
            this.lock.lock();
            needUnlock = true;
        } else {
            needUnlock = false;
        }
        try {
            int n = nbrProbes;
            this.histogram[n] = this.histogram[n] + 1;
            if (this.maxProbe < nbrProbes) {
                this.maxProbe = nbrProbes;
            }
            if (isContinue) {
                if (this.maxProbeAfterContinue < nbrProbes) {
                    this.maxProbeAfterContinue = nbrProbes;
                }
                ++this.continues;
            }
        }
        finally {
            if (needUnlock) {
                this.lock.unlock();
            }
        }
    }

    /*
     * Exception decompiling
     */
    FeatureStructureImpl getReserve(int key, int hash) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FeatureStructureImpl put(int key, FeatureStructureImpl value, int hash) {
        this.lock.lock();
        try {
            int[] probeInfo = probeInfoPut.get();
            JCasHashMapSubMap.resetProbeInfo(probeInfo);
            FeatureStructureImpl[] localTable = this.table;
            FeatureStructureImpl prevValue = this.find(localTable, key, hash, probeInfo);
            localTable[probeInfo[0]] = value;
            if (JCasHashMapSubMap.isReserve(prevValue)) {
                this.lockCondition.signalAll();
                FeatureStructureImpl featureStructureImpl = null;
                return featureStructureImpl;
            }
            if (prevValue == null) {
                this.incrementSize();
            }
            FeatureStructureImpl featureStructureImpl = prevValue;
            return featureStructureImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void putInner(int key, FeatureStructureImpl value, int hash) {
        assert (this.lock.getHoldCount() > 0);
        int[] probeInfo = probeInfoPutInner.get();
        JCasHashMapSubMap.resetProbeInfo(probeInfo);
        FeatureStructureImpl[] localTable = this.table;
        FeatureStructureImpl m3 = this.find(localTable, key, hash, probeInfo);
        assert (m3 == null);
        localTable[probeInfo[0]] = value;
    }

    private void increaseTableCapacity() {
        FeatureStructureImpl[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        int newCapacity = 2 * oldCapacity;
        this.table = this.newTableKeepSize(newCapacity);
        for (int i = 0; i < oldCapacity; ++i) {
            FeatureStructureImpl fs = oldTable[i];
            if (fs == null) continue;
            int key = fs.getAddress();
            int hash = JCasHashMap.hashInt(key);
            this.putInner(key, fs, hash >>> this.concurrencyLevelBits);
        }
    }

    private static boolean isReserve(FeatureStructureImpl m3) {
        return m3 != null && ((TOP)m3).jcasType == RESERVE_TOP_TYPE_INSTANCE;
    }

    private static boolean isReal(FeatureStructureImpl m3) {
        return m3 != null && ((TOP)m3).jcasType != RESERVE_TOP_TYPE_INSTANCE;
    }

    private static void resetProbeInfo(int[] probeInfo) {
        probeInfo[0] = -1;
        probeInfo[1] = 1;
    }

    private static void setProbeInfo(int[] probeInfo, int probeAddr, int probeDelta) {
        probeInfo[0] = probeAddr;
        probeInfo[1] = probeDelta;
    }

    private static class ReserveTopType
    extends TOP_Type {
    }
}

