/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public class MiscImpl {
    private static final Pattern whitespace = Pattern.compile("\\s");
    public static final String blanks = "                                                     ";
    public static final String dots = "...";

    public static String replaceWhiteSpace(String s2, String replacement) {
        return whitespace.matcher(s2).replaceAll(replacement);
    }

    public static StringBuilder getCallers(int s2, int n) {
        StackTraceElement[] e = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (int i = s2 + 2; i < s2 + n + 3 && i < e.length; ++i) {
            if (i != s2 + 2) {
                sb.append("  called_by: ");
            }
            sb.append(MiscImpl.formatcaller(e[i]));
        }
        return sb;
    }

    public static String getCaller() {
        StackTraceElement[] e = Thread.currentThread().getStackTrace();
        return MiscImpl.formatcaller(e[4]) + "called by: " + MiscImpl.formatcaller(e[5]);
    }

    private static String formatcaller(StackTraceElement e) {
        String n = e.getClassName();
        return n.substring(1 + n.lastIndexOf(46)) + "." + e.getMethodName() + "[" + e.getLineNumber() + "]";
    }

    public static String elide(String s2, int n) {
        return MiscImpl.elide(s2, n, true);
    }

    public static String elide(String s2, int n, boolean pad) {
        int ss;
        int sl;
        if (s2 == null) {
            s2 = "null";
        }
        if ((sl = s2.length()) <= n) {
            return s2 + (pad ? blanks.substring(0, n - sl) : "");
        }
        int dl = 1;
        int ss2 = ss + ((ss = (n - dl) / 2) * 2 == n - dl ? 0 : 1);
        return s2.substring(0, ss) + dots.substring(0, dl) + s2.substring(sl - ss2);
    }

    public static void timeLoops(String title, int iterations, Callable<Object> r) throws Exception {
        long shortest = Long.MAX_VALUE;
        for (int i = 0; i < iterations; ++i) {
            long startTime = System.nanoTime();
            r.call();
            long time = (System.nanoTime() - startTime) / 1000L;
            if (time >= shortest) continue;
            shortest = time;
            System.out.format("%s: speed is %,d microseconds on iteration %,d%n", title, shortest, i);
        }
    }
}

