/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class XCASParsingException
extends SAXParseException {
    private static final long serialVersionUID = -4915068920369582184L;
    private static final String resource_file = "org.apache.uima.cas.impl.xcas";
    private static final String missing_resource_error = "Could not load message catalog: org.apache.uima.cas.impl.xcas";
    private static final int MESSAGES_NOT_FOUND = -1;
    public static final int WRONG_ROOT_TAG = 0;
    public static final int TEXT_EXPECTED = 1;
    public static final int ARRAY_ELE_EXPECTED = 2;
    public static final int ARRAY_ELE_ATTRS = 3;
    public static final int UNKNOWN_TYPE = 4;
    public static final int ILLEGAL_ID = 5;
    public static final int ILLEGAL_ARRAY_SIZE = 6;
    public static final int ILLEGAL_ARRAY_ATTR = 7;
    public static final int UNKNOWN_FEATURE = 8;
    public static final int INTEGER_EXPECTED = 9;
    public static final int FLOAT_EXPECTED = 10;
    public static final int EXCESS_ARRAY_ELE = 11;
    public static final int UNKNOWN_ID = 12;
    private static final String[] identifiers = new String[]{"WRONG_ROOT_TAG", "TEXT_EXPECTED", "ARRAY_ELE_EXPECTED", "ARRAY_ELE_ATTRS", "UNKNOWN_TYPE", "ILLEGAL_ID", "ILLEGAL_ARRAY_SIZE", "ILLEGAL_ARRAY_ATTR", "UNKNOWN_FEATURE", "INTEGER_EXPECTED", "FLOAT_EXPECTED", "EXCESS_ARRAY_ELE", "UNKNOWN_ID"};
    private int error;
    private ResourceBundle resource = null;
    private Object[] arguments = new Object[9];

    public XCASParsingException(int error) {
        super((String)null, (Locator)null);
        this.error = error;
    }

    public int getError() {
        return this.error;
    }

    @Override
    public String getMessage() {
        if (this.resource == null) {
            try {
                this.resource = ResourceBundle.getBundle(resource_file);
            }
            catch (MissingResourceException e) {
                this.error = -1;
                return missing_resource_error;
            }
        }
        return new MessageFormat(this.resource.getString(identifiers[this.error])).format(this.arguments);
    }

    @Override
    public String toString() {
        return "XCASParsingException: " + this.getMessage();
    }

    public boolean addArgument(String s2) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != null) continue;
            this.arguments[i] = s2;
            return true;
        }
        return false;
    }
}

