/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.uima.cas.impl.StringHeapDeserializationHelper;

final class StringHeap {
    private static final int leastStringCode = 1;
    private List<String> stringList;

    StringHeap() {
        this.initMemory();
    }

    private final void initMemory() {
        this.stringList = new ArrayList<String>();
        this.stringList.add(null);
    }

    final void reinit(StringHeapDeserializationHelper shdh, boolean delta) {
        if (!delta) {
            this.initMemory();
        }
        String charHeapInString = new String(shdh.charHeap);
        HashMap<String, String> reuseStrings = new HashMap<String, String>(Math.min(8, shdh.refHeap.length / 3 / 2));
        for (int i = 3; i < shdh.refHeap.length; i += 3) {
            int stringOffset = shdh.refHeap[i + 0];
            int stringLength = shdh.refHeap[i + 1];
            String s2 = charHeapInString.substring(stringOffset, stringOffset + stringLength);
            String reuse = (String)reuseStrings.get(s2);
            if (reuse == null) {
                reuseStrings.put(s2, s2);
            }
            this.stringList.add(reuse != null ? reuse : s2);
        }
    }

    StringHeapDeserializationHelper serialize() {
        return this.serialize(1);
    }

    StringHeapDeserializationHelper serialize(int startPos) {
        StringHeapDeserializationHelper shdh = new StringHeapDeserializationHelper();
        shdh.refHeap = new int[(this.stringList.size() - startPos + 1) * 3];
        shdh.refHeapPos = shdh.refHeap.length;
        int charHeapSize = 0;
        for (int i = startPos; i < this.stringList.size(); ++i) {
            String s2 = this.stringList.get(i);
            if (s2 == null) continue;
            charHeapSize += s2.length();
        }
        shdh.charHeap = new char[charHeapSize];
        shdh.charHeapPos = shdh.charHeap.length;
        int charCount = 0;
        int r = 1;
        for (int i = startPos; i < this.stringList.size(); ++i) {
            String s3 = this.stringList.get(i);
            int refHeapOffset = r * 3;
            shdh.refHeap[refHeapOffset + 0] = charCount;
            shdh.refHeap[refHeapOffset + 1] = s3.length();
            System.arraycopy(s3.toCharArray(), 0, shdh.charHeap, charCount, s3.length());
            charCount += s3.length();
            ++r;
        }
        assert (charCount == shdh.charHeap.length);
        return shdh;
    }

    final void reset() {
        this.initMemory();
    }

    String getStringForCode(int stringCode) {
        if (stringCode == 0) {
            return null;
        }
        return this.stringList.get(stringCode);
    }

    int copyCharsToBuffer(int stringCode, char[] buffer, int start) {
        String str = this.stringList.get(stringCode);
        int len = str.length();
        int requestedMax = start + len;
        int max = buffer.length < requestedMax ? buffer.length - start : len;
        for (int i = 0; i < max; ++i) {
            buffer[start + i] = str.charAt(i);
        }
        return len;
    }

    int addString(String s2) {
        if (s2 == null) {
            return 0;
        }
        int addr = this.stringList.size();
        this.stringList.add(s2);
        return addr;
    }

    int cloneStringReference(int stringCode) {
        return stringCode;
    }

    int addCharBuffer(char[] buffer, int start, int length) {
        String s2 = new String(buffer, start, length);
        return this.addString(s2);
    }

    final int getCharArrayLength(int stringCode) {
        return this.stringList.get(stringCode).length();
    }

    final int getLeastStringCode() {
        return 1;
    }

    final int getLargestStringCode() {
        return this.stringList.size() - 1;
    }

    final int getSize() {
        return this.stringList.size();
    }
}

