/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CasSerializerSupport;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.util.Logger;
import org.apache.uima.util.MessageReport;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ListUtils {
    private static final List<String> EMPTY_LIST_STRING = Collections.emptyList();
    private static final AtomicInteger errorCount = new AtomicInteger(0);
    private final UpdateIntActions updateIntActions;
    private final UpdateFloatActions updateFloatActions;
    private final UpdateFsActions updateFsActions;
    private final UpdateStringActions updateStringActions;
    final CASImpl cas;
    private final int intListType;
    private final int floatListType;
    private final int stringListType;
    private final int fsListType;
    public final int neIntListType;
    public final int neFloatListType;
    public final int neStringListType;
    public final int neFsListType;
    private final int eIntListType;
    private final int eFloatListType;
    private final int eStringListType;
    private final int eFsListType;
    private final int intHeadFeat;
    private final int intTailFeat;
    private final int floatHeadFeat;
    private final int floatTailFeat;
    private int stringHeadFeat;
    private int stringTailFeat;
    final int fsHeadFeat;
    private final int fsTailFeat;
    private final Logger logger;
    private ErrorHandler eh;
    private boolean foundCycle;

    public ListUtils(CASImpl aCASImpl, Logger aLogger, ErrorHandler aErrorHandler) {
        this.cas = aCASImpl;
        this.logger = aLogger;
        this.eh = aErrorHandler;
        TypeSystemImpl ts = aCASImpl.getTypeSystemImpl();
        this.intListType = ts.ll_getCodeForTypeName("uima.cas.IntegerList");
        this.floatListType = ts.ll_getCodeForTypeName("uima.cas.FloatList");
        this.stringListType = ts.ll_getCodeForTypeName("uima.cas.StringList");
        this.fsListType = ts.ll_getCodeForTypeName("uima.cas.FSList");
        this.neIntListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyIntegerList");
        this.neFloatListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyFloatList");
        this.neStringListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyStringList");
        this.neFsListType = ts.ll_getCodeForTypeName("uima.cas.NonEmptyFSList");
        this.eIntListType = ts.ll_getCodeForTypeName("uima.cas.EmptyIntegerList");
        this.eFloatListType = ts.ll_getCodeForTypeName("uima.cas.EmptyFloatList");
        this.eStringListType = ts.ll_getCodeForTypeName("uima.cas.EmptyStringList");
        this.eFsListType = ts.ll_getCodeForTypeName("uima.cas.EmptyFSList");
        this.intHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyIntegerList:head");
        this.floatHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFloatList:head");
        this.stringHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyStringList:head");
        this.fsHeadFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFSList:head");
        this.intTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyIntegerList:tail");
        this.floatTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFloatList:tail");
        this.stringTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyStringList:tail");
        this.fsTailFeat = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFSList:tail");
        this.updateIntActions = new UpdateIntActions();
        this.updateFloatActions = new UpdateFloatActions();
        this.updateFsActions = new UpdateFsActions();
        this.updateStringActions = new UpdateStringActions();
    }

    public int getHeadFeatCode(int type) {
        return this.isIntListType(type) ? this.intHeadFeat : (this.isFloatListType(type) ? this.floatHeadFeat : (this.isStringListType(type) ? this.stringHeadFeat : (this.isFsListType(type) ? this.fsHeadFeat : -1)));
    }

    public int getTailFeatCode(int type) {
        return this.isIntListType(type) ? this.intTailFeat : (this.isFloatListType(type) ? this.floatTailFeat : (this.isStringListType(type) ? this.stringTailFeat : (this.isFsListType(type) ? this.fsTailFeat : -1)));
    }

    public int getNeListType(int type) {
        return this.isIntListType(type) ? this.neIntListType : (this.isFloatListType(type) ? this.neFloatListType : (this.isStringListType(type) ? this.neStringListType : (this.isFsListType(type) ? this.neFsListType : -1)));
    }

    public int getEListType(int type) {
        return this.isIntListType(type) ? this.eIntListType : (this.isFloatListType(type) ? this.eFloatListType : (this.isStringListType(type) ? this.eStringListType : (this.isFsListType(type) ? this.eFsListType : -1)));
    }

    public boolean isIntListType(int type) {
        return type == this.intListType || type == this.neIntListType || type == this.eIntListType;
    }

    public boolean isFloatListType(int type) {
        return type == this.floatListType || type == this.neFloatListType || type == this.eFloatListType;
    }

    public boolean isStringListType(int type) {
        return type == this.stringListType || type == this.neStringListType || type == this.eStringListType;
    }

    public boolean isFsListType(int type) {
        return type == this.fsListType || type == this.neFsListType || type == this.eFsListType;
    }

    public boolean isListType(int type) {
        return this.isIntListType(type) || this.isFloatListType(type) || this.isStringListType(type) || this.isFsListType(type);
    }

    public int getLength(int type, int addr) {
        int neListType = this.getNeListType(type);
        int tailFeat = this.getTailFeatCode(type);
        return this.getLength(type, addr, neListType, tailFeat);
    }

    public int getLength(int type, int addr, int neListType, int tailFeat) {
        PositiveIntSet_impl visited = new PositiveIntSet_impl();
        this.foundCycle = false;
        int length = 0;
        int curNode = addr;
        while (this.cas.getHeapValue(curNode) == neListType) {
            if (!visited.add(curNode)) {
                this.foundCycle = true;
                break;
            }
            ++length;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(tailFeat));
        }
        return length;
    }

    public void anyListToOutput(int curNode, XmiSerializationSharedData sharedData, CasSerializerSupport.CasDocSerializer cds, ListOutput out) {
        int curNodeType;
        if (curNode == 0) {
            return;
        }
        int type = this.cas.getHeapValue(curNode);
        int headFeat = this.getHeadFeatCode(type);
        int tailFeat = this.getTailFeatCode(type);
        int neListType = this.getNeListType(type);
        PositiveIntSet_impl visited = new PositiveIntSet_impl();
        while (curNode != 0 && (curNodeType = this.cas.getHeapValue(curNode)) == neListType && visited.add(curNode)) {
            int val = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(headFeat));
            if (curNodeType == this.neStringListType) {
                out.append(this.cas.getStringForCode(val));
            }
            if (curNodeType == this.neIntListType) {
                out.append(Integer.toString(val));
            } else if (curNodeType == this.neFloatListType) {
                out.append(Float.toString(CASImpl.int2float(val)));
            } else if (curNodeType == this.neFsListType) {
                if (val == 0) {
                    if (sharedData != null) {
                        XmiSerializationSharedData.OotsElementData oed = sharedData.getOutOfTypeSystemFeatures(curNode);
                        if (oed != null) {
                            assert (oed.attributes.size() == 1);
                            XmlAttribute attr = oed.attributes.get(0);
                            assert ("head".equals(attr.name));
                            out.append(attr.value);
                        } else {
                            out.append("0");
                        }
                    } else {
                        out.append("0");
                    }
                } else if (sharedData != null) {
                    out.append(sharedData.getXmiId(val));
                } else {
                    out.append(Integer.toString(val));
                }
            }
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(tailFeat));
        }
    }

    public String[] anyListToStringArray(int curNode, XmiSerializationSharedData sharedData) throws SAXException {
        List<String> r = this.anyListToStringList(curNode, sharedData, null);
        return r.toArray(new String[r.size()]);
    }

    public List<String> anyListToStringList(int curNode, XmiSerializationSharedData sharedData, CasSerializerSupport.CasDocSerializer cds) {
        if (curNode == 0) {
            return EMPTY_LIST_STRING;
        }
        final ArrayList<String> list = new ArrayList<String>();
        this.anyListToOutput(curNode, sharedData, cds, new ListOutput(){

            @Override
            void append(String item) {
                list.add(item);
            }
        });
        return list;
    }

    public int[] fsListToAddressArray(int curNode) throws SAXException {
        int type = this.cas.getHeapValue(curNode);
        int length = this.getLength(type, curNode, this.neFsListType, this.fsTailFeat);
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsHeadFeat));
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(this.fsTailFeat));
        }
        if (this.foundCycle) {
            this.reportWarning("Found a cycle in an FSList.  List truncated where cycle occurs.");
        }
        return array;
    }

    public int createIntList(List<String> stringValues) {
        int first = this.cas.ll_createFS(this.eIntListType);
        ListIterator<String> iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            int value = Integer.parseInt(iter.previous());
            int node = this.cas.ll_createFS(this.neIntListType);
            this.cas.setFeatureValueNotJournaled(node, this.intHeadFeat, value);
            this.cas.setFeatureValueNotJournaled(node, this.intTailFeat, first);
            first = node;
        }
        return first;
    }

    public int createFloatList(List<String> stringValues) {
        int first = this.cas.ll_createFS(this.eFloatListType);
        ListIterator<String> iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            float value = Float.parseFloat(iter.previous());
            int node = this.cas.ll_createFS(this.neFloatListType);
            this.cas.setFeatureValueNotJournaled(node, this.floatHeadFeat, CASImpl.float2int(value));
            this.cas.setFeatureValueNotJournaled(node, this.floatTailFeat, first);
            first = node;
        }
        return first;
    }

    public int createStringList(List<String> stringValues) {
        int first = this.cas.ll_createFS(this.eStringListType);
        ListIterator<String> iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            String value = iter.previous();
            int node = this.cas.ll_createFS(this.neStringListType);
            this.cas.setFeatureValueNotJournaled(node, this.stringHeadFeat, this.cas.addString(value));
            this.cas.setFeatureValueNotJournaled(node, this.stringTailFeat, first);
            first = node;
        }
        return first;
    }

    public int createFsList(List<String> stringValues, IntVector fsAddresses) {
        int first = this.cas.ll_createFS(this.eFsListType);
        ListIterator<String> iter = stringValues.listIterator(stringValues.size());
        while (iter.hasPrevious()) {
            int value = Integer.parseInt(iter.previous());
            int node = this.cas.ll_createFS(this.neFsListType);
            fsAddresses.add(node);
            this.cas.setFeatureValueNotJournaled(node, this.fsHeadFeat, value);
            this.cas.setFeatureValueNotJournaled(node, this.fsTailFeat, first);
            first = node;
        }
        return first;
    }

    public int updateIntList(int addr, List<String> stringValues) throws SAXException {
        return this.updateCommonList(addr, stringValues, this.updateIntActions);
    }

    public int updateFloatList(int addr, List<String> stringValues) throws SAXException {
        return this.updateCommonList(addr, stringValues, this.updateFloatActions);
    }

    public int updateFsList(int addr, List<String> stringValues, IntVector fsAddresses) throws SAXException {
        this.updateFsActions.fsAddresses = fsAddresses;
        return this.updateCommonList(addr, stringValues, this.updateFsActions);
    }

    public int updateStringList(int addr, List<String> stringValues) throws SAXException {
        return this.updateCommonList(addr, stringValues, this.updateStringActions);
    }

    private int updateCommonList(int addr, List<String> stringValues, UpdateTypeActions actions2) throws SAXException {
        int first = addr;
        int numberOfValues = stringValues.size();
        boolean foundCycle = false;
        PositiveIntSet_impl visited = new PositiveIntSet_impl();
        int curNode = addr;
        int prevNode = 0;
        int i = 0;
        int neListType = actions2.neType;
        int tailFeat = actions2.tailFeat;
        int currLength = this.getLength(neListType, addr);
        while (this.cas.getHeapValue(curNode) == neListType && i < numberOfValues) {
            if (!visited.add(curNode)) {
                foundCycle = true;
                break;
            }
            actions2.setNewValueInExistingNode(curNode, stringValues, i++);
            prevNode = curNode;
            curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(actions2.tailFeat));
        }
        if (!foundCycle && currLength < numberOfValues) {
            int emptyListFs = curNode;
            while (i < numberOfValues) {
                int newNode = this.cas.ll_createFS(neListType);
                actions2.setNewValueInNewNode(newNode, stringValues, i++);
                this.cas.setFeatureValueNoIndexCorruptionCheck(newNode, tailFeat, emptyListFs);
                this.cas.setFeatureValueNoIndexCorruptionCheck(prevNode, tailFeat, newNode);
                prevNode = newNode;
            }
        } else if (!foundCycle && currLength > numberOfValues) {
            int finalNode = curNode;
            while (this.cas.getHeapValue(curNode) == neListType) {
                if (!visited.add(curNode)) {
                    foundCycle = true;
                    break;
                }
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(tailFeat));
            }
            this.cas.setFeatureValueNoIndexCorruptionCheck(finalNode, tailFeat, curNode);
        }
        if (foundCycle) {
            this.reportWarning("While updating a " + actions2.listTypeName + ", a cycle was found; the list is truncated at that point.");
        }
        return first;
    }

    private void reportWarning(String message) throws SAXException {
        MessageReport.decreasingWithTrace(errorCount, message, this.logger);
        if (this.eh != null) {
            this.eh.warning(new SAXParseException(message, null));
        }
    }

    static abstract class ListOutput {
        ListOutput() {
        }

        abstract void append(String var1);
    }

    private class UpdateStringActions
    extends UpdateTypeActions {
        UpdateStringActions() {
            super(ListUtils.this.neStringListType, ListUtils.this.stringTailFeat, "StringList");
        }

        @Override
        void setNewValueInExistingNode(int curNode, List<String> stringValues, int i) {
            String newValue;
            String curValue = ListUtils.this.cas.getStringForCode(ListUtils.this.cas.getHeapValue(curNode + ListUtils.this.cas.getFeatureOffset(ListUtils.this.stringHeadFeat)));
            if (!curValue.equals(newValue = stringValues.get(i++))) {
                ListUtils.this.cas.setFeatureValueNoIndexCorruptionCheck(curNode, ListUtils.this.stringHeadFeat, ListUtils.this.cas.addString(newValue));
            }
        }

        @Override
        void setNewValueInNewNode(int newNode, List<String> stringValues, int i) {
            String newValue = stringValues.get(i++);
            ListUtils.this.cas.setFeatureValueNoIndexCorruptionCheck(newNode, ListUtils.this.stringHeadFeat, ListUtils.this.cas.addString(newValue));
        }
    }

    private class UpdateFsActions
    extends UpdateTypeActions {
        IntVector fsAddresses;

        UpdateFsActions() {
            super(ListUtils.this.neFsListType, ListUtils.this.fsTailFeat, "FsList");
        }

        @Override
        void setNewValueInExistingNode(int curNode, List<String> stringValues, int i) {
            this.setNewValueInNewNode(curNode, stringValues, i);
        }

        @Override
        void setNewValueInNewNode(int newNode, List<String> stringValues, int i) {
            int value = Integer.parseInt(stringValues.get(i));
            ListUtils.this.cas.setFeatureValueNoIndexCorruptionCheck(newNode, ListUtils.this.fsHeadFeat, value);
            this.fsAddresses.add(newNode);
        }
    }

    private class UpdateFloatActions
    extends UpdateTypeActions {
        UpdateFloatActions() {
            super(ListUtils.this.neFloatListType, ListUtils.this.floatTailFeat, "FloatList");
        }

        @Override
        void setNewValueInExistingNode(int curNode, List<String> stringValues, int i) {
            this.setNewValueInNewNode(curNode, stringValues, i);
        }

        @Override
        void setNewValueInNewNode(int newNode, List<String> stringValues, int i) {
            float value = Float.parseFloat(stringValues.get(i));
            ListUtils.this.cas.setFeatureValueNoIndexCorruptionCheck(newNode, ListUtils.this.floatHeadFeat, CASImpl.float2int(value));
        }
    }

    private class UpdateIntActions
    extends UpdateTypeActions {
        UpdateIntActions() {
            super(ListUtils.this.neIntListType, ListUtils.this.intTailFeat, "IntegerList");
        }

        @Override
        void setNewValueInExistingNode(int curNode, List<String> stringValues, int i) {
            this.setNewValueInNewNode(curNode, stringValues, i);
        }

        @Override
        void setNewValueInNewNode(int newNode, List<String> stringValues, int i) {
            int value = Integer.parseInt(stringValues.get(i));
            ListUtils.this.cas.setFeatureValueNoIndexCorruptionCheck(newNode, ListUtils.this.intHeadFeat, value);
        }
    }

    private abstract class UpdateTypeActions {
        final int neType;
        final int tailFeat;
        final String listTypeName;

        UpdateTypeActions(int neType, int tailFeat, String listTypeName) {
            this.neType = neType;
            this.tailFeat = tailFeat;
            this.listTypeName = listTypeName;
        }

        abstract void setNewValueInExistingNode(int var1, List<String> var2, int var3);

        abstract void setNewValueInNewNode(int var1, List<String> var2, int var3);
    }
}

