/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.ListUtils;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.util.Logger;
import org.apache.uima.util.MessageReport;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CasSerializerSupport {
    public static final int TYPE_CLASS_INTLIST = 101;
    public static final int TYPE_CLASS_FLOATLIST = 102;
    public static final int TYPE_CLASS_STRINGLIST = 103;
    public static final int TYPE_CLASS_FSLIST = 104;
    public static int PP_LINE_LENGTH = 120;
    public static int PP_ELEMENTS = 30;
    public static AtomicInteger errorCount = new AtomicInteger(0);
    public static final Comparator<TypeImpl> COMPARATOR_SHORT_TYPENAME = new Comparator<TypeImpl>(){

        @Override
        public int compare(TypeImpl object1, TypeImpl object2) {
            return object1.getShortName().compareTo(object2.getShortName());
        }
    };
    TypeSystemImpl filterTypeSystem;
    ErrorHandler errorHandler = null;
    Logger logger;
    public boolean isFormattedOutput;

    public CasSerializerSupport setPrettyPrint(boolean pp) {
        this.isFormattedOutput = pp;
        return this;
    }

    public CasSerializerSupport setFilterTypes(TypeSystemImpl ts) {
        this.filterTypeSystem = ts;
        return this;
    }

    public TypeSystemImpl getFilterTypes() {
        return this.filterTypeSystem;
    }

    public CasSerializerSupport setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
        return this;
    }

    public class CasDocSerializer {
        public final CASImpl cas;
        public final TypeSystemImpl tsi;
        public final PositiveIntSet_impl visited_not_yet_written;
        private final PositiveIntSet_impl enqueued_multiRef_arrays_or_lists = new PositiveIntSet_impl();
        public final PositiveIntSet multiRefFSs;
        public final boolean isDynamicMultiRef;
        public IntVector previouslySerializedFSs = null;
        public IntVector modifiedEmbeddedValueFSs = null;
        public final IntVector[] indexedFSs;
        private final IntVector queue;
        public final ListUtils listUtils;
        public XmlElementName[] typeCode2namespaceNames;
        private final BitSet typeUsed;
        public boolean needNameSpaces = true;
        public final Map<String, String> nsUriToPrefixMap = new HashMap<String, String>();
        public final Set<String> nsPrefixesUsed = new HashSet<String>();
        public final MarkerImpl marker;
        public final XmiSerializationSharedData sharedData;
        public final boolean isDelta;
        public final boolean isFiltering;
        private TypeImpl[] sortedUsedTypes;
        private final ErrorHandler errorHandler;
        public TypeSystemImpl filterTypeSystem;
        private final Map<String, String> uniqueStrings = new HashMap<String, String>();
        public final boolean isFormattedOutput;
        private final CasSerializerSupportSerialize csss;
        public final Comparator<Integer> sortFssByType = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int typeCode2;
                int typeCode1 = CasDocSerializer.this.cas.getHeapValue(o1);
                int c = CasDocSerializer.this.compareInts(typeCode1, typeCode2 = CasDocSerializer.this.cas.getHeapValue(o2));
                if (c != 0) {
                    return c;
                }
                boolean isAnnot = CasDocSerializer.this.tsi.subsumes(35, typeCode1);
                if (isAnnot) {
                    c = CasDocSerializer.this.compareFeat(o1, o2, 16);
                    return c != 0 ? c : CasDocSerializer.this.compareFeat(o2, o1, 17);
                }
                return CasDocSerializer.this.compareInts(o1, o2);
            }
        };

        public CasDocSerializer(ContentHandler ch, CASImpl cas, XmiSerializationSharedData sharedData, MarkerImpl marker, CasSerializerSupportSerialize csss) {
            this(ch, cas, sharedData, marker, csss, false);
        }

        public CasDocSerializer(ContentHandler ch, CASImpl cas, XmiSerializationSharedData sharedData, MarkerImpl marker, CasSerializerSupportSerialize csss, boolean trackMultiRefs) {
            this.cas = cas;
            this.csss = csss;
            this.sharedData = sharedData;
            this.filterTypeSystem = CasSerializerSupport.this.filterTypeSystem;
            this.isFormattedOutput = CasSerializerSupport.this.isFormattedOutput;
            this.marker = marker;
            this.errorHandler = CasSerializerSupport.this.errorHandler;
            this.tsi = cas.getTypeSystemImpl();
            this.visited_not_yet_written = new PositiveIntSet_impl();
            this.queue = new IntVector();
            this.indexedFSs = new IntVector[cas.getBaseSofaCount()];
            this.listUtils = new ListUtils(cas, CasSerializerSupport.this.logger, this.errorHandler);
            this.typeUsed = new BitSet();
            boolean bl = this.isFiltering = this.filterTypeSystem != null && this.filterTypeSystem != this.tsi;
            if (marker != null && !marker.isValid()) {
                CASRuntimeException exception = new CASRuntimeException("INVALID_MARKER", new String[]{"Invalid Marker."});
                throw exception;
            }
            this.isDelta = marker != null;
            this.multiRefFSs = new PositiveIntSet_impl();
            this.isDynamicMultiRef = trackMultiRefs;
        }

        private void reportMultiRefWarning(int featCode) throws SAXException {
            String message = String.format("Feature %s is marked multipleReferencesAllowed=false, but it has multiple references.  These will be serialized in duplicate.", this.tsi.ll_getFeatureForCode(featCode).getName());
            MessageReport.decreasingWithTrace(errorCount, message, CasSerializerSupport.this.logger);
            if (this.errorHandler != null) {
                this.errorHandler.warning(new SAXParseException(message, null));
            }
        }

        public void serialize() throws Exception {
            this.typeCode2namespaceNames = new XmlElementName[this.tsi.getLargestTypeCode() + 1];
            this.sortedUsedTypes = null;
            this.typeUsed.clear();
            Arrays.fill(this.indexedFSs, null);
            this.queue.removeAllElements();
            this.csss.initializeNamespaces();
            int iElementCount = 1;
            this.enqueueIndexed();
            this.enqueueIncoming();
            this.enqueueNonsharedMultivaluedFS();
            this.enqueueFeaturesOfIndexed();
            iElementCount += this.previouslySerializedFSs == null ? 0 : this.previouslySerializedFSs.size();
            iElementCount += this.modifiedEmbeddedValueFSs == null ? 0 : this.modifiedEmbeddedValueFSs.size();
            for (IntVector fss : this.indexedFSs) {
                iElementCount += fss == null ? 0 : fss.size();
            }
            iElementCount += this.queue.size();
            FSIndex sofaIndex = this.cas.getBaseCAS().indexRepository.getIndex("SofaIndex");
            if (!this.isDelta) {
                iElementCount += sofaIndex.size();
                iElementCount += this.getElementCountForSharedData();
            } else {
                int numViews = this.cas.getBaseSofaCount();
                for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                    FSIndexRepositoryImpl loopIR = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                    if (loopIR == null || !loopIR.isModified()) continue;
                    ++iElementCount;
                }
            }
            this.csss.writeFeatureStructures(iElementCount);
            this.csss.writeViews();
            this.csss.writeEndOfSerialization();
        }

        public int getSofaAddr(int sofaNum) {
            if (sofaNum != 1 || this.cas.isInitialSofaCreated()) {
                return ((CASImpl)this.cas.getView(sofaNum)).getSofaRef();
            }
            return 0;
        }

        public void writeViewsCommons() throws Exception {
            int numViews = this.cas.getBaseSofaCount();
            for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                int[] fsarray;
                FSIndexRepositoryImpl loopIR = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                int sofaAddr = this.getSofaAddr(sofaNum);
                if (loopIR == null) continue;
                if (!this.isDelta) {
                    fsarray = loopIR.getIndexedFSs();
                    this.csss.writeView(sofaAddr, fsarray);
                    continue;
                }
                if (sofaNum != 1 && this.marker.isNew(sofaAddr)) {
                    fsarray = loopIR.getIndexedFSs();
                    this.csss.writeView(sofaAddr, fsarray);
                    continue;
                }
                if (!loopIR.isModified()) continue;
                this.csss.writeView(sofaAddr, loopIR.getAddedFSs(), loopIR.getDeletedFSs(), loopIR.getReindexedFSs());
            }
        }

        public TypeImpl[] getSortedUsedTypes() {
            if (null == this.sortedUsedTypes) {
                this.sortedUsedTypes = new TypeImpl[this.typeUsed.cardinality()];
                int i = 0;
                for (TypeImpl ti : this.getUsedTypesIterable()) {
                    this.sortedUsedTypes[i++] = ti;
                }
                Arrays.sort(this.sortedUsedTypes, COMPARATOR_SHORT_TYPENAME);
            }
            return this.sortedUsedTypes;
        }

        private Iterable<TypeImpl> getUsedTypesIterable() {
            return new Iterable<TypeImpl>(){

                @Override
                public Iterator<TypeImpl> iterator() {
                    return new Iterator<TypeImpl>(){
                        private int i = 0;

                        @Override
                        public boolean hasNext() {
                            return CasDocSerializer.this.typeUsed.nextSetBit(this.i) >= 0;
                        }

                        @Override
                        public TypeImpl next() {
                            int next_i = CasDocSerializer.this.typeUsed.nextSetBit(this.i);
                            if (next_i < 0) {
                                throw new NoSuchElementException();
                            }
                            this.i = next_i + 1;
                            return (TypeImpl)CasDocSerializer.this.tsi.ll_getTypeForCode(next_i);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        private void enqueueIncoming() {
            if (this.sharedData == null) {
                return;
            }
            int[] fsAddrs = this.sharedData.getAllFsAddressesInIdMap();
            this.previouslySerializedFSs = new IntVector();
            for (int addr : fsAddrs) {
                int typeCode;
                if (addr == 0 || this.isDelta && !this.marker.isModified(addr) || (typeCode = this.enqueueCommon(addr)) == -1) continue;
                this.previouslySerializedFSs.add(addr);
            }
        }

        private void enqueueIndexed() {
            FSIndexRepositoryImpl ir = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getBaseIndexRepository();
            int[] fsarray = ir.getIndexedFSs();
            try {
                for (int fs : fsarray) {
                    this.enqueueFsAndMaybeFeatures(fs);
                }
            }
            catch (SAXException e) {
                throw new RuntimeException("Internal error - should never happen", e);
            }
            int numViews = this.cas.getBaseSofaCount();
            for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                FSIndexRepositoryImpl loopIR = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                if (loopIR == null) continue;
                for (int fs : fsarray = loopIR.getIndexedFSs()) {
                    this.enqueueIndexedFs_only_not_features(sofaNum, fs);
                }
            }
        }

        private void enqueueNonsharedMultivaluedFS() {
            if (this.sharedData == null || !this.isDelta) {
                return;
            }
            int[] fsAddrs = this.sharedData.getNonsharedMulitValuedFSs();
            this.modifiedEmbeddedValueFSs = new IntVector();
            for (int addr : fsAddrs) {
                int encompassingFs;
                if (!this.marker.isModified(addr) || -1 == this.enqueueCommonWithoutDeltaAndFilteringCheck(encompassingFs = this.sharedData.getEncompassingFS(addr))) continue;
                this.modifiedEmbeddedValueFSs.add(encompassingFs);
            }
        }

        private void enqueueFeaturesOfIndexed() throws SAXException {
            if (null != this.previouslySerializedFSs) {
                this.enqueueFeaturesOfFSs(this.previouslySerializedFSs);
            }
            if (null != this.modifiedEmbeddedValueFSs) {
                this.enqueueFeaturesOfFSs(this.modifiedEmbeddedValueFSs);
            }
            for (IntVector fss : this.indexedFSs) {
                if (fss == null) continue;
                this.enqueueFeaturesOfFSs(fss);
            }
        }

        private void enqueueFeaturesOfFSs(IntVector fss) throws SAXException {
            int max = fss.size();
            for (int i = 0; i < max; ++i) {
                int addr = fss.get(i);
                int heapVal = this.cas.getHeapValue(addr);
                this.enqueueFeatures(addr, heapVal);
            }
        }

        int enqueueCommon(int addr) {
            return this.enqueueCommon(addr, true);
        }

        int enqueueCommonWithoutDeltaAndFilteringCheck(int addr) {
            return this.enqueueCommon(addr, false);
        }

        private int enqueueCommon(int addr, boolean doDeltaAndFilteringCheck) {
            int typeCode = this.cas.getHeapValue(addr);
            assert (typeCode != 0);
            if (doDeltaAndFilteringCheck) {
                String typeName;
                if (this.isDelta && !this.marker.isNew(addr) && !this.marker.isModified(addr)) {
                    return -1;
                }
                if (this.isFiltering && this.filterTypeSystem.getType(typeName = this.tsi.ll_getTypeForCode(typeCode).getName()) == null) {
                    return -1;
                }
            }
            if (!this.visited_not_yet_written.add(addr)) {
                boolean wasAdded;
                if ((this.isDynamicMultiRef || this.isArrayOrList(typeCode)) && (wasAdded = this.multiRefFSs.add(addr))) {
                    this.queue.add(addr);
                }
                return -1;
            }
            boolean alreadySet = this.typeUsed.get(typeCode);
            if (!alreadySet) {
                this.typeUsed.set(typeCode);
                String typeName = this.tsi.ll_getTypeForCode(typeCode).getName();
                XmlElementName newXel = this.csss.uimaTypeName2XmiElementName(typeName);
                if (!this.needNameSpaces) {
                    this.csss.checkForNameCollision(newXel);
                }
                this.typeCode2namespaceNames[typeCode] = newXel;
            }
            return typeCode;
        }

        private void enqueueIndexedFs_only_not_features(int viewNumber, int addr) {
            if (this.enqueueCommon(addr) != -1) {
                IntVector fss = this.indexedFSs[viewNumber - 1];
                if (null == fss) {
                    this.indexedFSs[viewNumber - 1] = fss = new IntVector();
                }
                fss.add(addr);
            }
        }

        private void enqueueFsAndMaybeFeatures(int addr) throws SAXException {
            int typeCode = this.enqueueCommon(addr);
            if (typeCode == -1) {
                return;
            }
            this.queue.add(addr);
            this.enqueueFeatures(addr, typeCode);
        }

        boolean isArrayOrList(int typeCode) {
            return this.isArrayType(typeCode) || this.isListType(typeCode);
        }

        private boolean isArrayType(int typeCode) {
            return typeCode == 8 || typeCode == 7 || typeCode == 9 || typeCode == 6 || typeCode == 28 || typeCode == 29 || typeCode == 30 || typeCode == 31 || typeCode == 32;
        }

        private boolean isListType(int typeCode) {
            return this.listUtils.isIntListType(typeCode) || this.listUtils.isFloatListType(typeCode) || this.listUtils.isStringListType(typeCode) || this.listUtils.isFsListType(typeCode);
        }

        private boolean isListElementsMultiplyReferenced(int listNode, int featCode) {
            int typeCode = this.cas.getHeapValue(listNode);
            int neListType = this.listUtils.getNeListType(typeCode);
            int tailFeat = this.listUtils.getTailFeatCode(typeCode);
            boolean foundCycle = false;
            int curNode = listNode;
            while (typeCode == neListType) {
                if (!this.visited_not_yet_written.add(curNode)) {
                    foundCycle = true;
                    break;
                }
                curNode = this.cas.getHeapValue(curNode + this.cas.getFeatureOffset(tailFeat));
                typeCode = this.cas.getHeapValue(curNode);
            }
            return foundCycle;
        }

        private boolean isMultiRef_enqueue(int featCode, int featVal, boolean alreadyVisited, boolean isListNode, boolean isListFeat) throws SAXException {
            if (!this.isDynamicMultiRef) {
                boolean multiRefAllowed;
                boolean bl = multiRefAllowed = this.isStaticMultiRef(featCode) || isListNode;
                if (!multiRefAllowed) {
                    if (isListFeat && this.isListElementsMultiplyReferenced(featVal, featCode) || !isListFeat && alreadyVisited) {
                        this.reportMultiRefWarning(featCode);
                    } else if (!isListFeat) {
                        this.visited_not_yet_written.add(featVal);
                    }
                    return false;
                }
                return true;
            }
            if (alreadyVisited) {
                return !this.multiRefFSs.contains(featVal);
            }
            return true;
        }

        private void enqueueFeatures(int addr, int typeCode) throws SAXException {
            int[] feats;
            if (typeCode == 6) {
                int array_size = this.cas.ll_getArraySize(addr);
                int position = this.cas.getArrayStartAddress(addr);
                for (int j = 0; j < array_size; ++j) {
                    String typeName;
                    int fsRef = this.cas.getHeapValue(position++);
                    if (this.isFiltering && this.filterTypeSystem.getType(typeName = this.tsi.ll_getTypeForCode(this.cas.getHeapValue(fsRef)).getName()) == null || fsRef == 0) continue;
                    this.enqueueFsAndMaybeFeatures(fsRef);
                }
                return;
            }
            boolean insideListNode = this.listUtils.isListType(typeCode);
            block6: for (int feat : feats = this.tsi.ll_getAppropriateFeatures(typeCode)) {
                int featAddr;
                int featVal;
                String fullFeatName;
                if (this.isFiltering && this.filterTypeSystem.getFeatureByFullName(fullFeatName = this.tsi.ll_getFeatureForCode(feat).getName()) == null || (featVal = this.cas.getHeapValue(featAddr = addr + this.cas.getFeatureOffset(feat))) == 0) continue;
                int fsClass = this.classifyType(this.tsi.range(feat));
                switch (fsClass) {
                    case 8: {
                        this.enqueueFsAndMaybeFeatures(featVal);
                        continue block6;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        boolean alreadyVisited = this.visited_not_yet_written.contains(featVal);
                        if (this.isMultiRef_enqueue(feat, featVal, alreadyVisited, false, false)) {
                            if (this.enqueued_multiRef_arrays_or_lists.add(featVal)) {
                                this.enqueueFsAndMaybeFeatures(featVal);
                                continue block6;
                            }
                            if (!this.isDynamicMultiRef) continue block6;
                            this.multiRefFSs.add(featVal);
                            continue block6;
                        }
                        if (fsClass != 7 || alreadyVisited) continue block6;
                        this.enqueueFSArrayElements(featVal);
                        continue block6;
                    }
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: {
                        boolean alreadyVisited = this.visited_not_yet_written.contains(featVal);
                        if (this.isMultiRef_enqueue(feat, featVal, alreadyVisited, insideListNode, true)) {
                            if (this.enqueued_multiRef_arrays_or_lists.add(featVal)) {
                                this.enqueueFsAndMaybeFeatures(featVal);
                                continue block6;
                            }
                            if (!this.isDynamicMultiRef) continue block6;
                            this.multiRefFSs.add(featVal);
                            continue block6;
                        }
                        if (fsClass != 104 || alreadyVisited) continue block6;
                        this.enqueueFSListElements(featVal);
                        continue block6;
                    }
                }
            }
        }

        private void enqueueFSArrayElements(int addr) throws SAXException {
            int size = this.cas.ll_getArraySize(addr);
            int pos = this.cas.getArrayStartAddress(addr);
            for (int i = 0; i < size; ++i) {
                int val = this.cas.getHeapValue(pos);
                if (val != 0) {
                    this.enqueueFsAndMaybeFeatures(val);
                }
                ++pos;
            }
        }

        private void enqueueFSListElements(int addr) throws SAXException {
            int[] addrArray = this.listUtils.fsListToAddressArray(addr);
            for (int j = 0; j < addrArray.length; ++j) {
                if (addrArray[j] == 0) continue;
                this.enqueueFsAndMaybeFeatures(addrArray[j]);
            }
        }

        public void encodeIndexed() throws Exception {
            if (null != this.previouslySerializedFSs) {
                this.encodeFSs(this.previouslySerializedFSs);
            }
            if (null != this.modifiedEmbeddedValueFSs) {
                this.encodeFSs(this.modifiedEmbeddedValueFSs);
            }
            for (IntVector fss : this.indexedFSs) {
                if (fss == null) continue;
                this.encodeFSs(fss);
            }
        }

        private void encodeFSs(IntVector fss) throws Exception {
            int max = fss.size();
            for (int i = 0; i < max; ++i) {
                this.encodeFS(fss.get(i));
            }
        }

        public void encodeQueued() throws Exception {
            int[] queueArray;
            for (int addr : queueArray = this.queue.toArray()) {
                if (!this.visited_not_yet_written.contains(addr) || this.isDynamicMultiRef && !this.multiRefFSs.contains(addr)) continue;
                this.encodeFS(addr);
            }
        }

        private int compareInts(int i1, int i2) {
            return i1 == i2 ? 0 : (i1 > i2 ? 1 : -1);
        }

        private int compareFeat(int o1, int o2, int featCode) {
            int f1 = this.cas.ll_getIntValue(o1, featCode);
            int f2 = this.cas.ll_getIntValue(o2, featCode);
            return this.compareInts(f1, f2);
        }

        public void encodeFS(int addr) throws Exception {
            int typeCode = this.cas.getHeapValue(addr);
            int typeClass = this.classifyType(typeCode);
            boolean isIndexId = this.csss.writeFsStart(addr, typeCode);
            if (!isIndexId && this.isDynamicMultiRef && this.multiRefFSs.contains(addr)) {
                this.csss.writeFsRef(addr);
            } else {
                this.visited_not_yet_written.remove(addr);
                switch (typeClass) {
                    case 8: {
                        this.csss.writeFs(addr, typeCode);
                        break;
                    }
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: {
                        this.csss.writeListsAsIndividualFSs(addr, typeCode);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        this.csss.writeArrays(addr, typeCode, typeClass);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Error classifying FS type.");
                    }
                }
                this.csss.writeEndOfIndividualFs();
            }
        }

        int filterType(int addr) {
            String typeName;
            if (this.isFiltering && this.filterTypeSystem.getType(typeName = this.tsi.ll_getTypeForCode(this.cas.getHeapValue(addr)).getName()) == null) {
                return 0;
            }
            return addr;
        }

        public final int classifyType(int type) {
            if (this.listUtils.isIntListType(type)) {
                return 101;
            }
            if (this.listUtils.isFloatListType(type)) {
                return 102;
            }
            if (this.listUtils.isStringListType(type)) {
                return 103;
            }
            if (this.listUtils.isFsListType(type)) {
                return 104;
            }
            return this.cas.ll_getTypeClass(type);
        }

        int getElementCountForSharedData() {
            return this.sharedData == null ? 0 : this.sharedData.getOutOfTypeSystemElements().size();
        }

        public String getXmiId(int addr) {
            int v = this.getXmiIdAsInt(addr);
            return v == 0 ? null : Integer.toString(v);
        }

        public int getXmiIdAsInt(int addr) {
            String typeName;
            if (addr == 0) {
                return 0;
            }
            if (this.isFiltering && this.filterTypeSystem.getType(typeName = this.tsi.ll_getTypeForCode(this.cas.getHeapValue(addr)).getName()) == null) {
                return 0;
            }
            if (this.sharedData == null) {
                return addr;
            }
            return this.sharedData.getXmiIdAsInt(addr);
        }

        public String getNameSpacePrefix(String uimaTypeName, String nsUri, int lastDotIndex) {
            String prefix = this.nsUriToPrefixMap.get(nsUri);
            if (prefix == null) {
                if (lastDotIndex != -1) {
                    int secondLastDotIndex = uimaTypeName.lastIndexOf(46, lastDotIndex - 1);
                    prefix = uimaTypeName.substring(secondLastDotIndex + 1, lastDotIndex);
                } else {
                    prefix = "noNamespace";
                }
                if (this.nsPrefixesUsed.contains(prefix)) {
                    String basePrefix = prefix;
                    int num = 2;
                    while (this.nsPrefixesUsed.contains(basePrefix + num)) {
                        ++num;
                    }
                    prefix = basePrefix + num;
                }
                this.nsUriToPrefixMap.put(nsUri, prefix);
                this.nsPrefixesUsed.add(prefix);
            }
            return prefix;
        }

        public String getUniqueString(String s2) {
            String u = this.uniqueStrings.get(s2);
            if (null == u) {
                u = s2;
                this.uniqueStrings.put(s2, s2);
            }
            return u;
        }

        public String getTypeNameFromXmlElementName(XmlElementName xe) {
            String nsUri = xe.nsUri;
            if (nsUri == null || nsUri.length() == 0) {
                throw new UnsupportedOperationException();
            }
            int pfx = XmiCasSerializer.URIPFX.length;
            int sfx = XmiCasSerializer.URISFX.length;
            String r = nsUri.startsWith("http:///uima/noNamespace.ecore") ? "" : nsUri.substring(pfx, nsUri.length() - sfx);
            r = r.replace('/', '.');
            return r + xe.localName;
        }

        public boolean isStaticMultiRef(int featCode) {
            return this.tsi.ll_getFeatureForCode(featCode).isMultipleReferencesAllowed();
        }
    }

    public static abstract class CasSerializerSupportSerialize {
        protected abstract void initializeNamespaces();

        protected abstract void checkForNameCollision(XmlElementName var1);

        protected abstract void addNameSpace(XmlElementName var1);

        protected abstract XmlElementName uimaTypeName2XmiElementName(String var1);

        protected abstract void writeFeatureStructures(int var1) throws Exception;

        protected abstract void writeViews() throws Exception;

        protected abstract void writeView(int var1, int[] var2) throws Exception;

        protected abstract void writeView(int var1, int[] var2, int[] var3, int[] var4) throws Exception;

        protected abstract boolean writeFsStart(int var1, int var2) throws Exception;

        protected abstract void writeFs(int var1, int var2) throws Exception;

        protected abstract void writeListsAsIndividualFSs(int var1, int var2) throws Exception;

        protected abstract void writeArrays(int var1, int var2, int var3) throws Exception;

        protected abstract void writeEndOfIndividualFs() throws Exception;

        protected abstract void writeEndOfSerialization() throws Exception;

        protected abstract void writeFsRef(int var1) throws Exception;
    }
}

