/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.ActivationOS;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryBase;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.TrackableBase;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class SettingsXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public SettingsXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public SettingsXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser2, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser2.getName().equals(tagName) && !parser2.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser2, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser2, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser2, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser2, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser2.getName() + "'", parser2, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser2.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        return this.getBooleanValue(s2, attribute, parser2, null);
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser2, String defaultValue) throws XmlPullParserException {
        if (s2 != null && s2.length() != 0) {
            return Boolean.valueOf(s2);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Byte.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s2, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        if (s2 != null) {
            return s2.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s2, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        return this.getDateValue(s2, attribute, null, parser2);
    }

    private Date getDateValue(String s2, String attribute, String dateFormat, XmlPullParser parser2) throws XmlPullParserException {
        if (s2 != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s2));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser2, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s2);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser2, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Double.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser2, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Float.valueOf(s2).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser2, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Integer.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Long.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser2, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        if (s2 == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser2, null);
        }
        return s2;
    }

    private short getShortValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Short.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s2) {
        if (s2 != null) {
            s2 = s2.trim();
        }
        return s2;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser2) throws IOException, XmlPullParserException {
        int eventType = parser2.next();
        if (eventType == 4) {
            eventType = parser2.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser2, null);
        }
        return eventType;
    }

    public Settings read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser2 = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser2.setInput(reader);
        return this.read(parser2, strict);
    }

    public Settings read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Settings read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict);
    }

    public Settings read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in));
    }

    private Activation parseActivation(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Activation activation = new Activation();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "activeByDefault", null, parsed)) {
                activation.setActiveByDefault(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "activeByDefault"), "activeByDefault", parser2, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "jdk", null, parsed)) {
                activation.setJdk(this.interpolatedTrimmed(parser2.nextText(), "jdk"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "os", null, parsed)) {
                activation.setOs(this.parseActivationOS(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "property", null, parsed)) {
                activation.setProperty(this.parseActivationProperty(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "file", null, parsed)) {
                activation.setFile(this.parseActivationFile(parser2, strict));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activation;
    }

    private ActivationFile parseActivationFile(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ActivationFile activationFile = new ActivationFile();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "missing", null, parsed)) {
                activationFile.setMissing(this.interpolatedTrimmed(parser2.nextText(), "missing"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "exists", null, parsed)) {
                activationFile.setExists(this.interpolatedTrimmed(parser2.nextText(), "exists"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activationFile;
    }

    private ActivationOS parseActivationOS(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ActivationOS activationOS = new ActivationOS();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                activationOS.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "family", null, parsed)) {
                activationOS.setFamily(this.interpolatedTrimmed(parser2.nextText(), "family"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "arch", null, parsed)) {
                activationOS.setArch(this.interpolatedTrimmed(parser2.nextText(), "arch"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                activationOS.setVersion(this.interpolatedTrimmed(parser2.nextText(), "version"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activationOS;
    }

    private ActivationProperty parseActivationProperty(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ActivationProperty activationProperty = new ActivationProperty();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                activationProperty.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "value", null, parsed)) {
                activationProperty.setValue(this.interpolatedTrimmed(parser2.nextText(), "value"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activationProperty;
    }

    private IdentifiableBase parseIdentifiableBase(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        IdentifiableBase identifiableBase = new IdentifiableBase();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                identifiableBase.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return identifiableBase;
    }

    private Mirror parseMirror(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Mirror mirror = new Mirror();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "mirrorOf", null, parsed)) {
                mirror.setMirrorOf(this.interpolatedTrimmed(parser2.nextText(), "mirrorOf"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                mirror.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                mirror.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "layout", null, parsed)) {
                mirror.setLayout(this.interpolatedTrimmed(parser2.nextText(), "layout"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "mirrorOfLayouts", null, parsed)) {
                mirror.setMirrorOfLayouts(this.interpolatedTrimmed(parser2.nextText(), "mirrorOfLayouts"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                mirror.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return mirror;
    }

    private Profile parseProfile(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String value;
        String tagName = parser2.getName();
        Profile profile = new Profile();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "activation", null, parsed)) {
                profile.setActivation(this.parseActivation(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                while (parser2.nextTag() == 2) {
                    String key = parser2.getName();
                    value = parser2.nextText().trim();
                    profile.addProperty(key, value);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                profile.setRepositories(repositories);
                while (parser2.nextTag() == 2) {
                    if ("repository".equals(parser2.getName())) {
                        repositories.add(this.parseRepository(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                profile.setPluginRepositories(pluginRepositories);
                while (parser2.nextTag() == 2) {
                    if ("pluginRepository".equals(parser2.getName())) {
                        pluginRepositories.add(this.parseRepository(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                profile.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return profile;
    }

    private Proxy parseProxy(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Proxy proxy = new Proxy();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "active", null, parsed)) {
                proxy.setActive(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "active"), "active", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "protocol", null, parsed)) {
                proxy.setProtocol(this.interpolatedTrimmed(parser2.nextText(), "protocol"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "username", null, parsed)) {
                proxy.setUsername(this.interpolatedTrimmed(parser2.nextText(), "username"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "password", null, parsed)) {
                proxy.setPassword(this.interpolatedTrimmed(parser2.nextText(), "password"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "port", null, parsed)) {
                proxy.setPort(this.getIntegerValue(this.interpolatedTrimmed(parser2.nextText(), "port"), "port", parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "host", null, parsed)) {
                proxy.setHost(this.interpolatedTrimmed(parser2.nextText(), "host"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "nonProxyHosts", null, parsed)) {
                proxy.setNonProxyHosts(this.interpolatedTrimmed(parser2.nextText(), "nonProxyHosts"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                proxy.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return proxy;
    }

    private Repository parseRepository(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Repository repository = new Repository();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "releases", null, parsed)) {
                repository.setReleases(this.parseRepositoryPolicy(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "snapshots", null, parsed)) {
                repository.setSnapshots(this.parseRepositoryPolicy(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                repository.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                repository.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                repository.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "layout", null, parsed)) {
                repository.setLayout(this.interpolatedTrimmed(parser2.nextText(), "layout"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return repository;
    }

    private RepositoryBase parseRepositoryBase(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        RepositoryBase repositoryBase = new RepositoryBase();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                repositoryBase.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                repositoryBase.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                repositoryBase.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "layout", null, parsed)) {
                repositoryBase.setLayout(this.interpolatedTrimmed(parser2.nextText(), "layout"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return repositoryBase;
    }

    private RepositoryPolicy parseRepositoryPolicy(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "enabled", null, parsed)) {
                repositoryPolicy.setEnabled(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "enabled"), "enabled", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "updatePolicy", null, parsed)) {
                repositoryPolicy.setUpdatePolicy(this.interpolatedTrimmed(parser2.nextText(), "updatePolicy"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "checksumPolicy", null, parsed)) {
                repositoryPolicy.setChecksumPolicy(this.interpolatedTrimmed(parser2.nextText(), "checksumPolicy"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return repositoryPolicy;
    }

    private Server parseServer(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Server server = new Server();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "username", null, parsed)) {
                server.setUsername(this.interpolatedTrimmed(parser2.nextText(), "username"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "password", null, parsed)) {
                server.setPassword(this.interpolatedTrimmed(parser2.nextText(), "password"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "privateKey", null, parsed)) {
                server.setPrivateKey(this.interpolatedTrimmed(parser2.nextText(), "privateKey"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "passphrase", null, parsed)) {
                server.setPassphrase(this.interpolatedTrimmed(parser2.nextText(), "passphrase"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "filePermissions", null, parsed)) {
                server.setFilePermissions(this.interpolatedTrimmed(parser2.nextText(), "filePermissions"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "directoryPermissions", null, parsed)) {
                server.setDirectoryPermissions(this.interpolatedTrimmed(parser2.nextText(), "directoryPermissions"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                server.setConfiguration(Xpp3DomBuilder.build(parser2, true));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                server.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return server;
    }

    private Settings parseSettings(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Settings settings = new Settings();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "localRepository", null, parsed)) {
                settings.setLocalRepository(this.interpolatedTrimmed(parser2.nextText(), "localRepository"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "interactiveMode", null, parsed)) {
                settings.setInteractiveMode(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "interactiveMode"), "interactiveMode", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "usePluginRegistry", null, parsed)) {
                settings.setUsePluginRegistry(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "usePluginRegistry"), "usePluginRegistry", parser2, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "offline", null, parsed)) {
                settings.setOffline(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "offline"), "offline", parser2, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "proxies", null, parsed)) {
                ArrayList<Proxy> proxies = new ArrayList<Proxy>();
                settings.setProxies(proxies);
                while (parser2.nextTag() == 2) {
                    if ("proxy".equals(parser2.getName())) {
                        proxies.add(this.parseProxy(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "servers", null, parsed)) {
                ArrayList<Server> servers = new ArrayList<Server>();
                settings.setServers(servers);
                while (parser2.nextTag() == 2) {
                    if ("server".equals(parser2.getName())) {
                        servers.add(this.parseServer(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "mirrors", null, parsed)) {
                ArrayList<Mirror> mirrors = new ArrayList<Mirror>();
                settings.setMirrors(mirrors);
                while (parser2.nextTag() == 2) {
                    if ("mirror".equals(parser2.getName())) {
                        mirrors.add(this.parseMirror(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "profiles", null, parsed)) {
                ArrayList<Profile> profiles = new ArrayList<Profile>();
                settings.setProfiles(profiles);
                while (parser2.nextTag() == 2) {
                    if ("profile".equals(parser2.getName())) {
                        profiles.add(this.parseProfile(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "activeProfiles", null, parsed)) {
                ArrayList<String> activeProfiles = new ArrayList<String>();
                settings.setActiveProfiles(activeProfiles);
                while (parser2.nextTag() == 2) {
                    if ("activeProfile".equals(parser2.getName())) {
                        activeProfiles.add(this.interpolatedTrimmed(parser2.nextText(), "activeProfiles"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginGroups", null, parsed)) {
                ArrayList<String> pluginGroups = new ArrayList<String>();
                settings.setPluginGroups(pluginGroups);
                while (parser2.nextTag() == 2) {
                    if ("pluginGroup".equals(parser2.getName())) {
                        pluginGroups.add(this.interpolatedTrimmed(parser2.nextText(), "pluginGroups"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return settings;
    }

    private TrackableBase parseTrackableBase(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        TrackableBase trackableBase = new TrackableBase();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            this.checkUnknownElement(parser2, strict);
        }
        return trackableBase;
    }

    private Settings read(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        Settings settings = null;
        int eventType = parser2.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"settings".equals(parser2.getName())) {
                    throw new XmlPullParserException("Expected root element 'settings' but found '" + parser2.getName() + "'", parser2, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'settings'", parser2, null);
                }
                settings = this.parseSettings(parser2, strict);
                settings.setModelEncoding(parser2.getInputEncoding());
                parsed = true;
            }
            eventType = parser2.next();
        }
        if (parsed) {
            return settings;
        }
        throw new XmlPullParserException("Expected root element 'settings' but found no element at all: invalid XML document", parser2, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

