/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenXpp3Reader {
    private boolean addDefaultEntities = true;

    private boolean checkFieldWithDuplicate(XmlPullParser parser2, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser2.getName().equals(tagName) && !parser2.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser2, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser2, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser2, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser2, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser2.getName() + "'", parser2, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser2.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        return this.getBooleanValue(s2, attribute, parser2, null);
    }

    private boolean getBooleanValue(String s2, String attribute, XmlPullParser parser2, String defaultValue) throws XmlPullParserException {
        if (s2 != null && s2.length() != 0) {
            return Boolean.valueOf(s2);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Byte.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s2, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        if (s2 != null) {
            return s2.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s2, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        return this.getDateValue(s2, attribute, null, parser2);
    }

    private Date getDateValue(String s2, String attribute, String dateFormat, XmlPullParser parser2) throws XmlPullParserException {
        if (s2 != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s2));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser2, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s2);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser2, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Double.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser2, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Float.valueOf(s2).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser2, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Integer.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Long.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser2, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        if (s2 == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser2, null);
        }
        return s2;
    }

    private short getShortValue(String s2, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s2 != null) {
                try {
                    return Short.valueOf(s2);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s2) {
        if (s2 != null) {
            s2 = s2.trim();
        }
        return s2;
    }

    private int nextTag(XmlPullParser parser2) throws IOException, XmlPullParserException {
        int eventType = parser2.next();
        if (eventType == 4) {
            eventType = parser2.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser2, null);
        }
        return eventType;
    }

    public Model read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser2 = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser2.setInput(reader);
        return this.read(parser2, strict);
    }

    public Model read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Model read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in), strict);
    }

    public Model read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(ReaderFactory.newXmlReader(in));
    }

    private Activation parseActivation(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Activation activation = new Activation();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "activeByDefault", null, parsed)) {
                activation.setActiveByDefault(this.getBooleanValue(this.getTrimmedValue(parser2.nextText()), "activeByDefault", parser2, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "jdk", null, parsed)) {
                activation.setJdk(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "os", null, parsed)) {
                activation.setOs(this.parseActivationOS(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "property", null, parsed)) {
                activation.setProperty(this.parseActivationProperty(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "file", null, parsed)) {
                activation.setFile(this.parseActivationFile(parser2, strict));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activation;
    }

    private ActivationFile parseActivationFile(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ActivationFile activationFile = new ActivationFile();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "missing", null, parsed)) {
                activationFile.setMissing(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "exists", null, parsed)) {
                activationFile.setExists(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activationFile;
    }

    private ActivationOS parseActivationOS(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ActivationOS activationOS = new ActivationOS();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                activationOS.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "family", null, parsed)) {
                activationOS.setFamily(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "arch", null, parsed)) {
                activationOS.setArch(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                activationOS.setVersion(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activationOS;
    }

    private ActivationProperty parseActivationProperty(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ActivationProperty activationProperty = new ActivationProperty();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                activationProperty.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "value", null, parsed)) {
                activationProperty.setValue(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activationProperty;
    }

    private Build parseBuild(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Build build = new Build();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "sourceDirectory", null, parsed)) {
                build.setSourceDirectory(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "scriptSourceDirectory", null, parsed)) {
                build.setScriptSourceDirectory(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "testSourceDirectory", null, parsed)) {
                build.setTestSourceDirectory(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "outputDirectory", null, parsed)) {
                build.setOutputDirectory(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "testOutputDirectory", null, parsed)) {
                build.setTestOutputDirectory(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "extensions", null, parsed)) {
                ArrayList<Extension> extensions = new ArrayList<Extension>();
                build.setExtensions(extensions);
                while (parser2.nextTag() == 2) {
                    if ("extension".equals(parser2.getName())) {
                        extensions.add(this.parseExtension(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "defaultGoal", null, parsed)) {
                build.setDefaultGoal(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "resources", null, parsed)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                build.setResources(resources);
                while (parser2.nextTag() == 2) {
                    if ("resource".equals(parser2.getName())) {
                        resources.add(this.parseResource(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "testResources", null, parsed)) {
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                build.setTestResources(testResources);
                while (parser2.nextTag() == 2) {
                    if ("testResource".equals(parser2.getName())) {
                        testResources.add(this.parseResource(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "directory", null, parsed)) {
                build.setDirectory(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "finalName", null, parsed)) {
                build.setFinalName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "filters", null, parsed)) {
                ArrayList<String> filters = new ArrayList<String>();
                build.setFilters(filters);
                while (parser2.nextTag() == 2) {
                    if ("filter".equals(parser2.getName())) {
                        filters.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginManagement", null, parsed)) {
                build.setPluginManagement(this.parsePluginManagement(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                build.setPlugins(plugins);
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parsePlugin(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return build;
    }

    private BuildBase parseBuildBase(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        BuildBase buildBase = new BuildBase();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "defaultGoal", null, parsed)) {
                buildBase.setDefaultGoal(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "resources", null, parsed)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                buildBase.setResources(resources);
                while (parser2.nextTag() == 2) {
                    if ("resource".equals(parser2.getName())) {
                        resources.add(this.parseResource(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "testResources", null, parsed)) {
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                buildBase.setTestResources(testResources);
                while (parser2.nextTag() == 2) {
                    if ("testResource".equals(parser2.getName())) {
                        testResources.add(this.parseResource(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "directory", null, parsed)) {
                buildBase.setDirectory(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "finalName", null, parsed)) {
                buildBase.setFinalName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "filters", null, parsed)) {
                ArrayList<String> filters = new ArrayList<String>();
                buildBase.setFilters(filters);
                while (parser2.nextTag() == 2) {
                    if ("filter".equals(parser2.getName())) {
                        filters.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginManagement", null, parsed)) {
                buildBase.setPluginManagement(this.parsePluginManagement(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                buildBase.setPlugins(plugins);
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parsePlugin(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return buildBase;
    }

    private CiManagement parseCiManagement(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        CiManagement ciManagement = new CiManagement();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "system", null, parsed)) {
                ciManagement.setSystem(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                ciManagement.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "notifiers", null, parsed)) {
                ArrayList<Notifier> notifiers = new ArrayList<Notifier>();
                ciManagement.setNotifiers(notifiers);
                while (parser2.nextTag() == 2) {
                    if ("notifier".equals(parser2.getName())) {
                        notifiers.add(this.parseNotifier(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return ciManagement;
    }

    private ConfigurationContainer parseConfigurationContainer(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ConfigurationContainer configurationContainer = new ConfigurationContainer();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "inherited", null, parsed)) {
                configurationContainer.setInherited(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                configurationContainer.setConfiguration(Xpp3DomBuilder.build(parser2, true));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return configurationContainer;
    }

    private Contributor parseContributor(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String value;
        String tagName = parser2.getName();
        Contributor contributor = new Contributor();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                contributor.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "email", null, parsed)) {
                contributor.setEmail(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                contributor.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "organization", "organisation", parsed)) {
                contributor.setOrganization(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "organizationUrl", "organisationUrl", parsed)) {
                contributor.setOrganizationUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "roles", null, parsed)) {
                ArrayList<String> roles = new ArrayList<String>();
                contributor.setRoles(roles);
                while (parser2.nextTag() == 2) {
                    if ("role".equals(parser2.getName())) {
                        roles.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "timezone", null, parsed)) {
                contributor.setTimezone(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                while (parser2.nextTag() == 2) {
                    String key = parser2.getName();
                    value = parser2.nextText().trim();
                    contributor.addProperty(key, value);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return contributor;
    }

    private Dependency parseDependency(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Dependency dependency = new Dependency();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                dependency.setGroupId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                dependency.setArtifactId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                dependency.setVersion(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "type", null, parsed)) {
                dependency.setType(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "classifier", null, parsed)) {
                dependency.setClassifier(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "scope", null, parsed)) {
                dependency.setScope(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "systemPath", null, parsed)) {
                dependency.setSystemPath(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "exclusions", null, parsed)) {
                ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
                dependency.setExclusions(exclusions);
                while (parser2.nextTag() == 2) {
                    if ("exclusion".equals(parser2.getName())) {
                        exclusions.add(this.parseExclusion(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "optional", null, parsed)) {
                dependency.setOptional(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return dependency;
    }

    private DependencyManagement parseDependencyManagement(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        DependencyManagement dependencyManagement = new DependencyManagement();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                dependencyManagement.setDependencies(dependencies);
                while (parser2.nextTag() == 2) {
                    if ("dependency".equals(parser2.getName())) {
                        dependencies.add(this.parseDependency(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return dependencyManagement;
    }

    private DeploymentRepository parseDeploymentRepository(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        DeploymentRepository deploymentRepository = new DeploymentRepository();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "uniqueVersion", null, parsed)) {
                deploymentRepository.setUniqueVersion(this.getBooleanValue(this.getTrimmedValue(parser2.nextText()), "uniqueVersion", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "releases", null, parsed)) {
                deploymentRepository.setReleases(this.parseRepositoryPolicy(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "snapshots", null, parsed)) {
                deploymentRepository.setSnapshots(this.parseRepositoryPolicy(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                deploymentRepository.setId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                deploymentRepository.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                deploymentRepository.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "layout", null, parsed)) {
                deploymentRepository.setLayout(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return deploymentRepository;
    }

    private Developer parseDeveloper(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String value;
        String tagName = parser2.getName();
        Developer developer = new Developer();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                developer.setId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                developer.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "email", null, parsed)) {
                developer.setEmail(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                developer.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "organization", "organisation", parsed)) {
                developer.setOrganization(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "organizationUrl", "organisationUrl", parsed)) {
                developer.setOrganizationUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "roles", null, parsed)) {
                ArrayList<String> roles = new ArrayList<String>();
                developer.setRoles(roles);
                while (parser2.nextTag() == 2) {
                    if ("role".equals(parser2.getName())) {
                        roles.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "timezone", null, parsed)) {
                developer.setTimezone(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                while (parser2.nextTag() == 2) {
                    String key = parser2.getName();
                    value = parser2.nextText().trim();
                    developer.addProperty(key, value);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return developer;
    }

    private DistributionManagement parseDistributionManagement(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        DistributionManagement distributionManagement = new DistributionManagement();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "repository", null, parsed)) {
                distributionManagement.setRepository(this.parseDeploymentRepository(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "snapshotRepository", null, parsed)) {
                distributionManagement.setSnapshotRepository(this.parseDeploymentRepository(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "site", null, parsed)) {
                distributionManagement.setSite(this.parseSite(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "downloadUrl", null, parsed)) {
                distributionManagement.setDownloadUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "relocation", null, parsed)) {
                distributionManagement.setRelocation(this.parseRelocation(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "status", null, parsed)) {
                distributionManagement.setStatus(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return distributionManagement;
    }

    private Exclusion parseExclusion(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Exclusion exclusion = new Exclusion();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                exclusion.setArtifactId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                exclusion.setGroupId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return exclusion;
    }

    private Extension parseExtension(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Extension extension = new Extension();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                extension.setGroupId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                extension.setArtifactId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                extension.setVersion(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return extension;
    }

    private FileSet parseFileSet(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        FileSet fileSet = new FileSet();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "directory", null, parsed)) {
                fileSet.setDirectory(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                while (parser2.nextTag() == 2) {
                    if ("include".equals(parser2.getName())) {
                        includes.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                while (parser2.nextTag() == 2) {
                    if ("exclude".equals(parser2.getName())) {
                        excludes.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return fileSet;
    }

    private IssueManagement parseIssueManagement(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        IssueManagement issueManagement = new IssueManagement();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "system", null, parsed)) {
                issueManagement.setSystem(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                issueManagement.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return issueManagement;
    }

    private License parseLicense(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        License license = new License();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                license.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                license.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "distribution", null, parsed)) {
                license.setDistribution(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "comments", null, parsed)) {
                license.setComments(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return license;
    }

    private MailingList parseMailingList(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        MailingList mailingList = new MailingList();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                mailingList.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "subscribe", null, parsed)) {
                mailingList.setSubscribe(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "unsubscribe", null, parsed)) {
                mailingList.setUnsubscribe(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "post", null, parsed)) {
                mailingList.setPost(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "archive", null, parsed)) {
                mailingList.setArchive(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "otherArchives", null, parsed)) {
                ArrayList<String> otherArchives = new ArrayList<String>();
                mailingList.setOtherArchives(otherArchives);
                while (parser2.nextTag() == 2) {
                    if ("otherArchive".equals(parser2.getName())) {
                        otherArchives.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return mailingList;
    }

    private Model parseModel(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String value;
        String tagName = parser2.getName();
        Model model = new Model();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "modelVersion", null, parsed)) {
                model.setModelVersion(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "parent", null, parsed)) {
                model.setParent(this.parseParent(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                model.setGroupId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                model.setArtifactId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                model.setVersion(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "packaging", null, parsed)) {
                model.setPackaging(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                model.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "description", null, parsed)) {
                model.setDescription(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                model.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "inceptionYear", null, parsed)) {
                model.setInceptionYear(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "organization", "organisation", parsed)) {
                model.setOrganization(this.parseOrganization(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "licenses", null, parsed)) {
                ArrayList<License> licenses = new ArrayList<License>();
                model.setLicenses(licenses);
                while (parser2.nextTag() == 2) {
                    if ("license".equals(parser2.getName())) {
                        licenses.add(this.parseLicense(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "developers", null, parsed)) {
                ArrayList<Developer> developers = new ArrayList<Developer>();
                model.setDevelopers(developers);
                while (parser2.nextTag() == 2) {
                    if ("developer".equals(parser2.getName())) {
                        developers.add(this.parseDeveloper(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "contributors", null, parsed)) {
                ArrayList<Contributor> contributors = new ArrayList<Contributor>();
                model.setContributors(contributors);
                while (parser2.nextTag() == 2) {
                    if ("contributor".equals(parser2.getName())) {
                        contributors.add(this.parseContributor(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "mailingLists", null, parsed)) {
                ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
                model.setMailingLists(mailingLists);
                while (parser2.nextTag() == 2) {
                    if ("mailingList".equals(parser2.getName())) {
                        mailingLists.add(this.parseMailingList(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "prerequisites", null, parsed)) {
                model.setPrerequisites(this.parsePrerequisites(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "modules", null, parsed)) {
                ArrayList<String> modules = new ArrayList<String>();
                model.setModules(modules);
                while (parser2.nextTag() == 2) {
                    if ("module".equals(parser2.getName())) {
                        modules.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "scm", null, parsed)) {
                model.setScm(this.parseScm(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "issueManagement", null, parsed)) {
                model.setIssueManagement(this.parseIssueManagement(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "ciManagement", null, parsed)) {
                model.setCiManagement(this.parseCiManagement(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "distributionManagement", null, parsed)) {
                model.setDistributionManagement(this.parseDistributionManagement(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                while (parser2.nextTag() == 2) {
                    String key = parser2.getName();
                    value = parser2.nextText().trim();
                    model.addProperty(key, value);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencyManagement", null, parsed)) {
                model.setDependencyManagement(this.parseDependencyManagement(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                model.setDependencies(dependencies);
                while (parser2.nextTag() == 2) {
                    if ("dependency".equals(parser2.getName())) {
                        dependencies.add(this.parseDependency(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                model.setRepositories(repositories);
                while (parser2.nextTag() == 2) {
                    if ("repository".equals(parser2.getName())) {
                        repositories.add(this.parseRepository(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                model.setPluginRepositories(pluginRepositories);
                while (parser2.nextTag() == 2) {
                    if ("pluginRepository".equals(parser2.getName())) {
                        pluginRepositories.add(this.parseRepository(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "build", null, parsed)) {
                model.setBuild(this.parseBuild(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reports", null, parsed)) {
                model.setReports(Xpp3DomBuilder.build(parser2, true));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reporting", null, parsed)) {
                model.setReporting(this.parseReporting(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "profiles", null, parsed)) {
                ArrayList<Profile> profiles = new ArrayList<Profile>();
                model.setProfiles(profiles);
                while (parser2.nextTag() == 2) {
                    if ("profile".equals(parser2.getName())) {
                        profiles.add(this.parseProfile(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return model;
    }

    private ModelBase parseModelBase(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String value;
        String tagName = parser2.getName();
        ModelBase modelBase = new ModelBase();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "modules", null, parsed)) {
                ArrayList<String> modules = new ArrayList<String>();
                modelBase.setModules(modules);
                while (parser2.nextTag() == 2) {
                    if ("module".equals(parser2.getName())) {
                        modules.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "distributionManagement", null, parsed)) {
                modelBase.setDistributionManagement(this.parseDistributionManagement(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                while (parser2.nextTag() == 2) {
                    String key = parser2.getName();
                    value = parser2.nextText().trim();
                    modelBase.addProperty(key, value);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencyManagement", null, parsed)) {
                modelBase.setDependencyManagement(this.parseDependencyManagement(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                modelBase.setDependencies(dependencies);
                while (parser2.nextTag() == 2) {
                    if ("dependency".equals(parser2.getName())) {
                        dependencies.add(this.parseDependency(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                modelBase.setRepositories(repositories);
                while (parser2.nextTag() == 2) {
                    if ("repository".equals(parser2.getName())) {
                        repositories.add(this.parseRepository(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                modelBase.setPluginRepositories(pluginRepositories);
                while (parser2.nextTag() == 2) {
                    if ("pluginRepository".equals(parser2.getName())) {
                        pluginRepositories.add(this.parseRepository(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reports", null, parsed)) {
                modelBase.setReports(Xpp3DomBuilder.build(parser2, true));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reporting", null, parsed)) {
                modelBase.setReporting(this.parseReporting(parser2, strict));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return modelBase;
    }

    private Notifier parseNotifier(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String value;
        String tagName = parser2.getName();
        Notifier notifier = new Notifier();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "type", null, parsed)) {
                notifier.setType(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "sendOnError", null, parsed)) {
                notifier.setSendOnError(this.getBooleanValue(this.getTrimmedValue(parser2.nextText()), "sendOnError", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "sendOnFailure", null, parsed)) {
                notifier.setSendOnFailure(this.getBooleanValue(this.getTrimmedValue(parser2.nextText()), "sendOnFailure", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "sendOnSuccess", null, parsed)) {
                notifier.setSendOnSuccess(this.getBooleanValue(this.getTrimmedValue(parser2.nextText()), "sendOnSuccess", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "sendOnWarning", null, parsed)) {
                notifier.setSendOnWarning(this.getBooleanValue(this.getTrimmedValue(parser2.nextText()), "sendOnWarning", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "address", null, parsed)) {
                notifier.setAddress(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                while (parser2.nextTag() == 2) {
                    String key = parser2.getName();
                    value = parser2.nextText().trim();
                    notifier.addConfiguration(key, value);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return notifier;
    }

    private Organization parseOrganization(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Organization organization = new Organization();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                organization.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                organization.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return organization;
    }

    private Parent parseParent(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Parent parent = new Parent();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                parent.setGroupId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                parent.setArtifactId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                parent.setVersion(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "relativePath", null, parsed)) {
                parent.setRelativePath(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return parent;
    }

    private PatternSet parsePatternSet(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        PatternSet patternSet = new PatternSet();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                patternSet.setIncludes(includes);
                while (parser2.nextTag() == 2) {
                    if ("include".equals(parser2.getName())) {
                        includes.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                patternSet.setExcludes(excludes);
                while (parser2.nextTag() == 2) {
                    if ("exclude".equals(parser2.getName())) {
                        excludes.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return patternSet;
    }

    private Plugin parsePlugin(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Plugin plugin = new Plugin();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                plugin.setGroupId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                plugin.setArtifactId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                plugin.setVersion(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "extensions", null, parsed)) {
                plugin.setExtensions(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "executions", null, parsed)) {
                ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
                plugin.setExecutions(executions);
                while (parser2.nextTag() == 2) {
                    if ("execution".equals(parser2.getName())) {
                        executions.add(this.parsePluginExecution(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                plugin.setDependencies(dependencies);
                while (parser2.nextTag() == 2) {
                    if ("dependency".equals(parser2.getName())) {
                        dependencies.add(this.parseDependency(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "goals", null, parsed)) {
                plugin.setGoals(Xpp3DomBuilder.build(parser2, true));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "inherited", null, parsed)) {
                plugin.setInherited(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                plugin.setConfiguration(Xpp3DomBuilder.build(parser2, true));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return plugin;
    }

    private PluginConfiguration parsePluginConfiguration(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "pluginManagement", null, parsed)) {
                pluginConfiguration.setPluginManagement(this.parsePluginManagement(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginConfiguration.setPlugins(plugins);
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parsePlugin(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return pluginConfiguration;
    }

    private PluginContainer parsePluginContainer(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        PluginContainer pluginContainer = new PluginContainer();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginContainer.setPlugins(plugins);
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parsePlugin(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return pluginContainer;
    }

    private PluginExecution parsePluginExecution(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        PluginExecution pluginExecution = new PluginExecution();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                pluginExecution.setId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "phase", null, parsed)) {
                pluginExecution.setPhase(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "goals", null, parsed)) {
                ArrayList<String> goals = new ArrayList<String>();
                pluginExecution.setGoals(goals);
                while (parser2.nextTag() == 2) {
                    if ("goal".equals(parser2.getName())) {
                        goals.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "inherited", null, parsed)) {
                pluginExecution.setInherited(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                pluginExecution.setConfiguration(Xpp3DomBuilder.build(parser2, true));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return pluginExecution;
    }

    private PluginManagement parsePluginManagement(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        PluginManagement pluginManagement = new PluginManagement();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                pluginManagement.setPlugins(plugins);
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parsePlugin(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return pluginManagement;
    }

    private Prerequisites parsePrerequisites(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Prerequisites prerequisites = new Prerequisites();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "maven", null, parsed)) {
                prerequisites.setMaven(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return prerequisites;
    }

    private Profile parseProfile(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String value;
        String tagName = parser2.getName();
        Profile profile = new Profile();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                profile.setId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "activation", null, parsed)) {
                profile.setActivation(this.parseActivation(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "build", null, parsed)) {
                profile.setBuild(this.parseBuildBase(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "modules", null, parsed)) {
                ArrayList<String> modules = new ArrayList<String>();
                profile.setModules(modules);
                while (parser2.nextTag() == 2) {
                    if ("module".equals(parser2.getName())) {
                        modules.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "distributionManagement", null, parsed)) {
                profile.setDistributionManagement(this.parseDistributionManagement(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                while (parser2.nextTag() == 2) {
                    String key = parser2.getName();
                    value = parser2.nextText().trim();
                    profile.addProperty(key, value);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencyManagement", null, parsed)) {
                profile.setDependencyManagement(this.parseDependencyManagement(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                profile.setDependencies(dependencies);
                while (parser2.nextTag() == 2) {
                    if ("dependency".equals(parser2.getName())) {
                        dependencies.add(this.parseDependency(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                profile.setRepositories(repositories);
                while (parser2.nextTag() == 2) {
                    if ("repository".equals(parser2.getName())) {
                        repositories.add(this.parseRepository(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                profile.setPluginRepositories(pluginRepositories);
                while (parser2.nextTag() == 2) {
                    if ("pluginRepository".equals(parser2.getName())) {
                        pluginRepositories.add(this.parseRepository(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reports", null, parsed)) {
                profile.setReports(Xpp3DomBuilder.build(parser2, true));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reporting", null, parsed)) {
                profile.setReporting(this.parseReporting(parser2, strict));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return profile;
    }

    private Relocation parseRelocation(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Relocation relocation = new Relocation();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                relocation.setGroupId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                relocation.setArtifactId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                relocation.setVersion(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "message", null, parsed)) {
                relocation.setMessage(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return relocation;
    }

    private ReportPlugin parseReportPlugin(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ReportPlugin reportPlugin = new ReportPlugin();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                reportPlugin.setGroupId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                reportPlugin.setArtifactId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                reportPlugin.setVersion(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reportSets", null, parsed)) {
                ArrayList<ReportSet> reportSets = new ArrayList<ReportSet>();
                reportPlugin.setReportSets(reportSets);
                while (parser2.nextTag() == 2) {
                    if ("reportSet".equals(parser2.getName())) {
                        reportSets.add(this.parseReportSet(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "inherited", null, parsed)) {
                reportPlugin.setInherited(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                reportPlugin.setConfiguration(Xpp3DomBuilder.build(parser2, true));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return reportPlugin;
    }

    private ReportSet parseReportSet(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ReportSet reportSet = new ReportSet();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                reportSet.setId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reports", null, parsed)) {
                ArrayList<String> reports = new ArrayList<String>();
                reportSet.setReports(reports);
                while (parser2.nextTag() == 2) {
                    if ("report".equals(parser2.getName())) {
                        reports.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "inherited", null, parsed)) {
                reportSet.setInherited(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                reportSet.setConfiguration(Xpp3DomBuilder.build(parser2, true));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return reportSet;
    }

    private Reporting parseReporting(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Reporting reporting = new Reporting();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "excludeDefaults", null, parsed)) {
                reporting.setExcludeDefaults(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "outputDirectory", null, parsed)) {
                reporting.setOutputDirectory(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<ReportPlugin> plugins = new ArrayList<ReportPlugin>();
                reporting.setPlugins(plugins);
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parseReportPlugin(parser2, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return reporting;
    }

    private Repository parseRepository(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Repository repository = new Repository();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "releases", null, parsed)) {
                repository.setReleases(this.parseRepositoryPolicy(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "snapshots", null, parsed)) {
                repository.setSnapshots(this.parseRepositoryPolicy(parser2, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                repository.setId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                repository.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                repository.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "layout", null, parsed)) {
                repository.setLayout(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return repository;
    }

    private RepositoryBase parseRepositoryBase(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        RepositoryBase repositoryBase = new RepositoryBase();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                repositoryBase.setId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                repositoryBase.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                repositoryBase.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "layout", null, parsed)) {
                repositoryBase.setLayout(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return repositoryBase;
    }

    private RepositoryPolicy parseRepositoryPolicy(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "enabled", null, parsed)) {
                repositoryPolicy.setEnabled(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "updatePolicy", null, parsed)) {
                repositoryPolicy.setUpdatePolicy(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "checksumPolicy", null, parsed)) {
                repositoryPolicy.setChecksumPolicy(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return repositoryPolicy;
    }

    private Resource parseResource(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Resource resource = new Resource();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "targetPath", null, parsed)) {
                resource.setTargetPath(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "filtering", null, parsed)) {
                resource.setFiltering(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "directory", null, parsed)) {
                resource.setDirectory(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                resource.setIncludes(includes);
                while (parser2.nextTag() == 2) {
                    if ("include".equals(parser2.getName())) {
                        includes.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                resource.setExcludes(excludes);
                while (parser2.nextTag() == 2) {
                    if ("exclude".equals(parser2.getName())) {
                        excludes.add(this.getTrimmedValue(parser2.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return resource;
    }

    private Scm parseScm(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Scm scm = new Scm();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "connection", null, parsed)) {
                scm.setConnection(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "developerConnection", null, parsed)) {
                scm.setDeveloperConnection(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "tag", null, parsed)) {
                scm.setTag(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                scm.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return scm;
    }

    private Site parseSite(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Site site = new Site();
        for (int i = parser2.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser2.getAttributeName(i);
            String value = parser2.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                site.setId(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                site.setName(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                site.setUrl(this.getTrimmedValue(parser2.nextText()));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return site;
    }

    private Model read(XmlPullParser parser2, boolean strict) throws IOException, XmlPullParserException {
        int eventType = parser2.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"project".equals(parser2.getName())) {
                    throw new XmlPullParserException("Expected root element 'project' but found '" + parser2.getName() + "'", parser2, null);
                }
                Model model = this.parseModel(parser2, strict);
                model.setModelEncoding(parser2.getInputEncoding());
                return model;
            }
            eventType = parser2.next();
        }
        throw new XmlPullParserException("Expected root element 'project' but found no element at all: invalid XML document", parser2, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

