/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JarUtils {
    private static final String[] UNIX_NON_PATH_SEPARATORS;
    private static final int[] UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS;
    private static final List<String> JRE_PATHS;
    private static String RT_JAR_PATH;

    public static String[] smartPathSplit(String pathStr) {
        if (pathStr == null || pathStr.isEmpty()) {
            return new String[0];
        }
        if (File.pathSeparatorChar == ':') {
            HashSet<Integer> splitPoints = new HashSet<Integer>();
            int i = -1;
            do {
                boolean foundNonPathSeparator = false;
                for (int j = 0; j < UNIX_NON_PATH_SEPARATORS.length; ++j) {
                    if (!pathStr.regionMatches(true, i - UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS[j], UNIX_NON_PATH_SEPARATORS[j], 0, UNIX_NON_PATH_SEPARATORS[j].length())) continue;
                    foundNonPathSeparator = true;
                    break;
                }
                if (foundNonPathSeparator) continue;
                splitPoints.add(i);
            } while ((i = pathStr.indexOf(58, i + 1)) >= 0);
            splitPoints.add(pathStr.length());
            ArrayList splitPointsSorted = new ArrayList(splitPoints);
            Collections.sort(splitPointsSorted);
            ArrayList<String> parts = new ArrayList<String>();
            for (int i2 = 1; i2 < splitPointsSorted.size(); ++i2) {
                int idx0 = (Integer)splitPointsSorted.get(i2 - 1);
                int idx1 = (Integer)splitPointsSorted.get(i2);
                String part = pathStr.substring(idx0 + 1, idx1).trim();
                if ((part = part.replaceAll("\\\\:", ":")).isEmpty()) continue;
                parts.add(part);
            }
            return parts.toArray(new String[parts.size()]);
        }
        ArrayList<String> partsFiltered = new ArrayList<String>();
        for (String part : pathStr.split(File.pathSeparator)) {
            String partFiltered = part.trim();
            if (partFiltered.isEmpty()) continue;
            partsFiltered.add(partFiltered);
        }
        return partsFiltered.toArray(new String[partsFiltered.size()]);
    }

    private static void appendPathElt(Object pathElt, StringBuilder buf) {
        if (buf.length() > 0) {
            buf.append(File.pathSeparatorChar);
        }
        String path = File.separatorChar == '\\' ? pathElt.toString() : pathElt.toString().replaceAll(File.pathSeparator, "\\" + File.pathSeparator);
        buf.append(path);
    }

    public static String pathElementsToPathStr(Object ... pathElts) {
        StringBuilder buf = new StringBuilder();
        for (Object pathElt : pathElts) {
            JarUtils.appendPathElt(pathElt, buf);
        }
        return buf.toString();
    }

    public static String pathElementsToPathStr(Iterable<?> pathElts) {
        StringBuilder buf = new StringBuilder();
        for (Object pathElt : pathElts) {
            JarUtils.appendPathElt(pathElt, buf);
        }
        return buf.toString();
    }

    public static String leafName(String path) {
        int bangIdx = path.indexOf("!");
        int endIdx = bangIdx >= 0 ? bangIdx : path.length();
        int leafStartIdx = 1 + (File.separatorChar == '/' ? path.lastIndexOf(47, endIdx) : Math.max(path.lastIndexOf(47, endIdx), path.lastIndexOf(File.separatorChar, endIdx)));
        int sepIdx = path.indexOf("---");
        if (sepIdx >= 0) {
            sepIdx += "---".length();
        }
        leafStartIdx = Math.max(leafStartIdx, sepIdx);
        leafStartIdx = Math.min(leafStartIdx, endIdx);
        return path.substring(leafStartIdx, endIdx);
    }

    private static String getProperty(String propName) {
        try {
            return System.getProperty(propName);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static void addJREPath(File dir, Set<String> jrePathsSet) {
        if (ClasspathUtils.canRead(dir) && dir.isDirectory()) {
            String jrePath;
            String path = dir.getPath();
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (!(jrePath = FastPathResolver.resolve("", path)).isEmpty()) {
                jrePathsSet.add(jrePath);
            }
            try {
                String jreCanonicalPath;
                String canonicalPath = dir.getCanonicalPath();
                if (!canonicalPath.endsWith(File.separator)) {
                    canonicalPath = canonicalPath + File.separator;
                }
                if (!(jreCanonicalPath = FastPathResolver.resolve("", canonicalPath)).equals(jrePath) && !jreCanonicalPath.isEmpty()) {
                    jrePathsSet.add(jreCanonicalPath);
                }
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    public static String getRtJarPath() {
        return RT_JAR_PATH;
    }

    public static boolean isJREJar(String filePath, LogNode log) {
        for (String jrePathPrefix : JRE_PATHS) {
            if (!filePath.startsWith(jrePathPrefix)) continue;
            return true;
        }
        return false;
    }

    public static long countBytesBeforePKMarker(File zipfile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(zipfile));){
            int c;
            boolean readP = false;
            long fileIdx = 0L;
            while ((c = reader.read()) != -1) {
                if (!readP) {
                    if (c == 80) {
                        readP = true;
                    }
                } else {
                    if (c == 75) {
                        long l = fileIdx - 1L;
                        return l;
                    }
                    readP = false;
                }
                ++fileIdx;
            }
            long l = -1L;
            return l;
        }
    }

    public static void stripSFXHeader(File srcZipfile, long sfxHeaderBytes, File destZipfile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(srcZipfile);
             FileChannel inputChannel = inputStream.getChannel();
             FileOutputStream outputStream = new FileOutputStream(destZipfile);
             FileChannel outputChannel = outputStream.getChannel();){
            inputChannel.position(sfxHeaderBytes);
            outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
        }
    }

    public static void logJavaInfo(LogNode log) {
        if (log != null) {
            log.log("Operating system: " + JarUtils.getProperty("os.name") + " " + JarUtils.getProperty("os.version") + " " + JarUtils.getProperty("os.arch"));
            log.log("Java version: " + JarUtils.getProperty("java.version") + " (" + JarUtils.getProperty("java.vendor") + ")");
            LogNode javaLog = log.log("JRE paths:");
            for (String jrePath : JRE_PATHS) {
                javaLog.log(jrePath);
            }
            if (RT_JAR_PATH != null) {
                javaLog.log(RT_JAR_PATH);
            }
        }
    }

    static {
        String javaExtDirs;
        UNIX_NON_PATH_SEPARATORS = new String[]{"jar:", "file:", "http://", "https://", "\\:"};
        UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS = new int[UNIX_NON_PATH_SEPARATORS.length];
        for (int i = 0; i < UNIX_NON_PATH_SEPARATORS.length; ++i) {
            JarUtils.UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS[i] = UNIX_NON_PATH_SEPARATORS[i].indexOf(58);
            if (UNIX_NON_PATH_SEPARATOR_COLON_POSITIONS[i] >= 0) continue;
            throw new RuntimeException("Could not find ':' in \"" + UNIX_NON_PATH_SEPARATORS[i] + "\"");
        }
        JRE_PATHS = new ArrayList<String>();
        RT_JAR_PATH = null;
        HashSet<String> jrePathsSet = new HashSet<String>();
        String javaHome = JarUtils.getProperty("java.home");
        if (javaHome != null && !javaHome.isEmpty()) {
            File parent;
            File javaHomeFile = new File(javaHome);
            JarUtils.addJREPath(javaHomeFile, jrePathsSet);
            File libFile = new File(javaHomeFile, "lib");
            JarUtils.addJREPath(libFile, jrePathsSet);
            File extFile = new File(libFile, "ext");
            JarUtils.addJREPath(extFile, jrePathsSet);
            File rtJarFile = new File(libFile, "rt.jar");
            if (ClasspathUtils.canRead(rtJarFile)) {
                RT_JAR_PATH = rtJarFile.getPath();
            }
            if (javaHomeFile.getName().equals("jre") && (parent = javaHomeFile.getParentFile()) != null) {
                File parentLibFile = new File(parent, "lib");
                JarUtils.addJREPath(parentLibFile, jrePathsSet);
            }
        }
        if ((javaExtDirs = JarUtils.getProperty("java.ext.dirs")) != null) {
            for (String javaExtDir : JarUtils.smartPathSplit(javaExtDirs)) {
                if (javaExtDir.isEmpty()) continue;
                File javaExtDirFile = new File(javaExtDir);
                JarUtils.addJREPath(javaExtDirFile, jrePathsSet);
            }
        }
        JarUtils.addJREPath(new File("/System/Library/Java"), jrePathsSet);
        JRE_PATHS.addAll(jrePathsSet);
        Collections.sort(JRE_PATHS);
    }
}

