/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastPathResolver {
    private static final Pattern percentMatcher = Pattern.compile("([%][0-9a-fA-F][0-9a-fA-F])+");
    private static final boolean WINDOWS = File.separatorChar == '\\';

    private static void translateSeparator(String path, int startIdx, int endIdx, boolean stripFinalSeparator, StringBuilder buf) {
        for (int i = startIdx; i < endIdx; ++i) {
            char c = path.charAt(i);
            if (c == '\\' || c == '/') {
                int prevChar;
                if (i >= endIdx - 1 && stripFinalSeparator) continue;
                int n = prevChar = buf.length() == 0 ? 0 : (int)buf.charAt(buf.length() - 1);
                if (prevChar == 47) continue;
                buf.append('/');
                continue;
            }
            buf.append(c);
        }
    }

    private static void unescapePercentEncoding(String path, int startIdx, int endIdx, StringBuilder buf) {
        if (endIdx - startIdx == 3 && path.charAt(startIdx + 1) == '2' && path.charAt(startIdx + 2) == '0') {
            buf.append(' ');
        } else {
            byte[] bytes = new byte[(endIdx - startIdx) / 3];
            int i = startIdx;
            int j = 0;
            while (i < endIdx) {
                int digit1;
                char c1 = path.charAt(i + 1);
                char c2 = path.charAt(i + 2);
                int n = c1 >= '0' && c1 <= '9' ? c1 - 48 : (digit1 = c1 >= 'a' && c1 <= 'f' ? c1 - 97 + 10 : c1 - 65 + 10);
                int digit2 = c2 >= '0' && c2 <= '9' ? c2 - 48 : (c2 >= 'a' && c2 <= 'f' ? c2 - 97 + 10 : c2 - 65 + 10);
                bytes[j] = (byte)(digit1 << 4 | digit2);
                i += 3;
                ++j;
            }
            String str = new String(bytes, StandardCharsets.UTF_8);
            FastPathResolver.translateSeparator(str, 0, str.length(), false, buf);
        }
    }

    private static String normalizePath(String path, boolean isHttpURL) {
        boolean hasPercent;
        boolean bl = hasPercent = path.indexOf(37) >= 0;
        if (!hasPercent && path.indexOf(92) < 0 && !path.endsWith("/")) {
            return path;
        }
        int len = path.length();
        StringBuilder buf = new StringBuilder();
        if (!hasPercent || isHttpURL) {
            FastPathResolver.translateSeparator(path, 0, len, true, buf);
            return buf.toString();
        }
        int prevEndMatchIdx = 0;
        Matcher matcher = percentMatcher.matcher(path);
        while (matcher.find()) {
            int startMatchIdx = matcher.start();
            int endMatchIdx = matcher.end();
            FastPathResolver.translateSeparator(path, prevEndMatchIdx, startMatchIdx, false, buf);
            FastPathResolver.unescapePercentEncoding(path, startMatchIdx, endMatchIdx, buf);
            prevEndMatchIdx = endMatchIdx;
        }
        FastPathResolver.translateSeparator(path, prevEndMatchIdx, len, true, buf);
        return buf.toString();
    }

    public static String resolve(String resolveBasePath, String relativePathStr) {
        if (relativePathStr == null || relativePathStr.isEmpty()) {
            return resolveBasePath;
        }
        String prefix = "";
        boolean isAbsolutePath = false;
        boolean isHttpURL = false;
        int startIdx = 0;
        if (relativePathStr.regionMatches(true, startIdx, "jar:", 0, 4)) {
            startIdx += 4;
        }
        if (relativePathStr.regionMatches(true, startIdx, "http://", 0, 7)) {
            startIdx += 7;
            prefix = "http://";
            isAbsolutePath = true;
            isHttpURL = true;
        } else if (relativePathStr.regionMatches(true, startIdx, "https://", 0, 8)) {
            startIdx += 8;
            prefix = "https://";
            isAbsolutePath = true;
            isHttpURL = true;
        } else if (relativePathStr.regionMatches(true, startIdx, "file:", 0, 5)) {
            startIdx += 5;
            if (WINDOWS) {
                if (relativePathStr.startsWith("\\\\\\\\", startIdx) || relativePathStr.startsWith("////", startIdx)) {
                    startIdx += 4;
                    prefix = "//";
                    isAbsolutePath = true;
                } else if (relativePathStr.startsWith("\\\\", startIdx)) {
                    startIdx += 2;
                }
            }
            if (relativePathStr.startsWith("//", startIdx)) {
                startIdx += 2;
            }
        } else if (WINDOWS && (relativePathStr.startsWith("//") || relativePathStr.startsWith("\\\\"))) {
            startIdx += 2;
            prefix = "//";
            isAbsolutePath = true;
        }
        if (WINDOWS) {
            if (relativePathStr.length() - startIdx > 2 && Character.isLetter(relativePathStr.charAt(startIdx)) && relativePathStr.charAt(startIdx + 1) == ':') {
                isAbsolutePath = true;
            } else if (relativePathStr.length() - startIdx > 3 && (relativePathStr.charAt(startIdx) == '/' || relativePathStr.charAt(startIdx) == '\\') && Character.isLetter(relativePathStr.charAt(startIdx + 1)) && relativePathStr.charAt(startIdx + 2) == ':') {
                isAbsolutePath = true;
                ++startIdx;
            }
        }
        if (relativePathStr.length() - startIdx > 1 && (relativePathStr.charAt(startIdx) == '/' || relativePathStr.charAt(startIdx) == '\\')) {
            isAbsolutePath = true;
        }
        String pathStr = FastPathResolver.normalizePath(startIdx == 0 ? relativePathStr : relativePathStr.substring(startIdx), isHttpURL);
        if (!prefix.isEmpty()) {
            pathStr = prefix + pathStr;
        }
        if (resolveBasePath == null || isAbsolutePath) {
            return pathStr;
        }
        return resolveBasePath + "/" + pathStr;
    }

    public static String resolve(String pathStr) {
        return FastPathResolver.resolve(null, pathStr);
    }
}

