/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import de.julielab.xml.JulieXMLTools;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JulieXMLToolsCLI {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: " + JulieXMLToolsCLI.class.getName() + " <XML file> <XPath expression> [xml | text] [output directory] [XPath to record ID for output file names]");
            System.out.println("The option 'xml' will result whole XML fragments to be returned in contrast to only text contents.");
            System.out.println("If you specify an output directory, each result record of the first XPath expression will be written to a file.");
            System.out.println("If you specify a record ID XPath, the output file names will correspond to the value of this field. NOTE: This XPath must be given RELATIVE to the first XPath! I.e. without leading / and from the point where the first XPath ended.");
            System.exit(1);
        }
        String fileName = args[0];
        String xpath = args[1];
        String option = args.length > 2 ? args[2].toLowerCase() : null;
        String outputDir = args.length > 3 ? args[3] : null;
        String recordIdXPath = args.length > 4 ? args[4] : null;
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
        HashMap<String, String> field = new HashMap<String, String>();
        field.put("name", "value");
        field.put("xpath", ".");
        if (option != null && option.equals("xml")) {
            field.put("returnXMLFragment", "true");
        }
        fields.add(field);
        if (recordIdXPath != null) {
            field = new HashMap();
            field.put("name", "id");
            field.put("xpath", recordIdXPath);
            fields.add(field);
        }
        Iterator<Map<String, Object>> rowIterator = JulieXMLTools.constructRowIterator(fileName, 1024, xpath, fields, false, true);
        PrintStream out = null;
        if (outputDir == null) {
            try {
                out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        int idCounter = 0;
        while (rowIterator.hasNext()) {
            Map<String, Object> row = rowIterator.next();
            String fragment = (String)row.get("value");
            String id = (String)(recordIdXPath != null ? row.get("id") : String.valueOf(idCounter++));
            if (outputDir == null) {
                out.println(fragment);
                continue;
            }
            String outputFileName = outputDir + File.separator + id;
            if (option.equals("xml")) {
                outputFileName = outputFileName + ".xml";
            }
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(outputFileName));){
                bw.write(fragment);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

