/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.utilities.aether;

import de.julielab.utilities.aether.MavenArtifact;
import de.julielab.utilities.aether.MavenConstants;
import de.julielab.utilities.aether.MavenException;
import de.julielab.utilities.aether.MavenRepositoryUtilities;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.Result;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;

public class MavenProjectUtilities {
    private MavenProjectUtilities() {
    }

    public static List<String> getProjectModules(File pom, boolean recursively) {
        ArrayList<String> ret = new ArrayList<String>();
        Model model = MavenProjectUtilities.getRawPomModel(pom);
        List<String> modules = model.getModules();
        if (modules != null) {
            String basepathString = pom.getParent() != null ? pom.getParent() + File.separator : "";
            ret.addAll(modules.stream().map(m3 -> basepathString + m3).collect(Collectors.toList()));
        }
        if (recursively) {
            ret.addAll(MavenProjectUtilities.getRecursiveProjectModules(ret));
        }
        return ret;
    }

    public static List<String> getRecursiveProjectModules(List<String> modules) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String module : modules) {
            ret.addAll(MavenProjectUtilities.getProjectModules(new File(module + File.separator + "pom.xml"), true));
        }
        return ret;
    }

    public static Model getRawPomModel(File pom) {
        DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
        Result<? extends Model> result = modelBuilder.buildRawModel(pom, 0, false);
        Model model = result.get();
        if (model == null) {
            throw new IllegalArgumentException("Could not create a model from file " + pom.getAbsolutePath());
        }
        return model;
    }

    public static Model getEffectivePomModel(File pom) throws MavenException {
        try {
            DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
            modelRequest.setPomFile(pom);
            modelRequest.setModelResolver(MavenProjectUtilities.createModelResolver());
            modelRequest.setSystemProperties(System.getProperties());
            DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
            ModelBuildingResult modelBuildingResult = modelBuilder.build(modelRequest);
            return modelBuildingResult.getEffectiveModel();
        }
        catch (ModelBuildingException | SettingsBuildingException e) {
            throw new MavenException(e);
        }
    }

    public static ModelResolver createModelResolver() throws SettingsBuildingException, MavenException {
        ModelResolver modelResolver;
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        RepositorySystemSession session = MavenRepositoryUtilities.newSession(MavenRepositoryUtilities.newRepositorySystem(locator), MavenConstants.LOCAL_REPO);
        try {
            Constructor<?> constr = Class.forName("org.apache.maven.repository.internal.DefaultModelResolver").getConstructors()[0];
            constr.setAccessible(true);
            modelResolver = (ModelResolver)constr.newInstance(session, null, null, locator.getService(ArtifactResolver.class), locator.getService(VersionRangeResolver.class), locator.getService(RemoteRepositoryManager.class), MavenRepositoryUtilities.getEffectiveRepositories(session));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new MavenException(e);
        }
        return modelResolver;
    }

    public static Model addDependenciesToModel(File basePom, Stream<MavenArtifact> dependencyArtifacts) throws MavenException {
        try {
            DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
            modelRequest.setPomFile(basePom);
            modelRequest.setModelResolver(MavenProjectUtilities.createModelResolver());
            modelRequest.setSystemProperties(System.getProperties());
            DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
            ModelBuildingResult modelBuildingResult = modelBuilder.build(modelRequest);
            Model model = modelBuildingResult.getEffectiveModel();
            dependencyArtifacts.map(d -> {
                Dependency dep = new Dependency();
                dep.setArtifactId(d.getArtifactId());
                dep.setGroupId(d.getGroupId());
                dep.setVersion(d.getVersion());
                dep.setType(d.getPackaging());
                dep.setClassifier(dep.getClassifier());
                return dep;
            }).forEach(model::addDependency);
            return model;
        }
        catch (ModelBuildingException | SettingsBuildingException e) {
            throw new MavenException(e);
        }
    }

    public static void writeModel(File destination, Model model) throws IOException {
        DefaultModelWriter modelWriter = new DefaultModelWriter();
        modelWriter.write(destination, null, model);
    }
}

