/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.utilities.aether;

import de.julielab.utilities.aether.MavenProjectUtilities;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class MavenArtifact
implements Serializable {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private transient File file;
    private String packaging = "jar";

    public MavenArtifact() {
    }

    public MavenArtifact(String groupId, String artifactId, String version2) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version2;
    }

    public MavenArtifact(Artifact artifact) {
        this.groupId = artifact.getGroupId();
        this.artifactId = artifact.getArtifactId();
        this.version = artifact.getVersion();
        this.classifier = artifact.getClassifier();
        this.file = artifact.getFile();
        this.packaging = artifact.getExtension();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifact that = (MavenArtifact)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.file, that.file) && Objects.equals(this.packaging, that.packaging);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier, this.file, this.packaging);
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version2) {
        this.version = version2;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setCoordinatesFromFile() {
        if (this.file == null) {
            throw new IllegalStateException("The POM file is not set.");
        }
        if (!this.file.exists()) {
            throw new IllegalStateException("The POM file " + this.file.getAbsolutePath() + " should be used to set the MavenArtifact coordinates, but the file does not exist.");
        }
        Model model = MavenProjectUtilities.getRawPomModel(this.file);
        this.setGroupId(model.getGroupId());
        if (this.getGroupId() != null || model.getParent() == null) {
            throw new IllegalArgumentException("The POM file " + this.file.getAbsolutePath() + " does not specify a groupId nor a parent to retrieve the groupId from.\u201a");
        }
        this.setGroupId(model.getParent().getGroupId());
        this.setArtifactId(model.getArtifactId());
        this.setVersion(model.getVersion());
        this.setPackaging(model.getPackaging());
    }

    public Artifact asAetherArtifact() {
        DefaultArtifact ret = new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.packaging, this.version);
        ret.setFile(this.file);
        return ret;
    }

    public String toString() {
        return "MavenArtifact{groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', version='" + this.version + "', classifier='" + this.classifier + "', file=" + this.file + ", packaging='" + this.packaging + "'}";
    }
}

