/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.connectors.GitHubConnector;
import de.julielab.jcore.pipeline.builder.base.connectors.RepositoryBranchInformation;
import de.julielab.jcore.pipeline.builder.base.main.ComponentRepository;
import de.julielab.jcore.pipeline.builder.base.main.GitHubRepository;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.IMenuDialog;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositorySelectVersionDialog
implements IMenuDialog {
    private static final Logger log = LoggerFactory.getLogger(RepositorySelectVersionDialog.class);
    private final ComponentRepository repository;

    public RepositorySelectVersionDialog(ComponentRepository repository) {
        this.repository = repository;
    }

    @Override
    public String getName() {
        return "Select version for repository '" + this.repository.getName() + "'";
    }

    public String toString() {
        return this.getName();
    }

    public void execute(TextIO textIO, Deque<String> path) {
        this.clearTerminal(textIO);
        path.add(this.getName());
        this.printPosition(textIO, path);
        if (this.repository instanceof GitHubRepository) {
            GitHubRepository ghr = (GitHubRepository)this.repository;
            List<RepositoryBranchInformation> repositoryBranches = GitHubConnector.getRepositoryBranches(ghr);
            List branchNames = repositoryBranches.stream().map(RepositoryBranchInformation::getName).collect(Collectors.toList());
            String chosenBranchName = (String)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(branchNames)).read("Select the repository branch to retrieve the components from.");
            this.repository.setVersion(chosenBranchName);
        }
        path.pop();
    }
}

