/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.main.ComponentRepository;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.NoopMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.PayloadMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopableDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.RepositorySelectVersionDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.RepositorySelectionDialog;
import java.util.Deque;
import org.beryx.textio.TextIO;

public class RepositoryChangeVersionDialog
implements ILoopableDialog {
    @Override
    public IMenuItem executeMenuItem(TextIO textIO, Deque<String> path) {
        IMenuItem choice = new RepositorySelectionDialog().selectRepository(textIO, path);
        if (choice instanceof BackMenuItem) {
            return choice;
        }
        ComponentRepository chosenRepo = (ComponentRepository)((PayloadMenuItem)choice).getPayload();
        if (!chosenRepo.isUpdateable()) {
            textIO.getTextTerminal().executeWithPropertiesPrefix("error", t -> t.print("The repository " + chosenRepo.getName() + " cannot be updated according to its settings."));
            return new NoopMenuItem();
        }
        String oldVersion = chosenRepo.getVersion();
        new RepositorySelectVersionDialog(chosenRepo).execute(textIO, path);
        String newVersion = chosenRepo.getVersion();
        return new NoopMenuItem();
    }

    @Override
    public String getName() {
        return "Change Repository Version";
    }

    public String toString() {
        return this.getName();
    }
}

