/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.main.PipelineBuilderCLI;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.ComponentSelectionMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.MenuItemList;
import de.julielab.jcore.pipeline.builder.cli.menu.PositionMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.AbstractComponentSelectionDialog;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public abstract class ReorderComponentsDialog
extends AbstractComponentSelectionDialog {
    private final PipelineBuilderConstants.JcoreMeta.Category componentCategory;
    private final String dialogName;
    private final Function<JCoReUIMAPipeline, List<Description>> delegateSupplier;

    public ReorderComponentsDialog(PipelineBuilderConstants.JcoreMeta.Category componentCategory, String dialogName, Function<JCoReUIMAPipeline, List<Description>> delegateSupplier) {
        this.componentCategory = componentCategory;
        this.dialogName = dialogName;
        this.delegateSupplier = delegateSupplier;
    }

    @Override
    public IMenuItem executeMenuItem(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) {
        this.init(pipeline, EnumSet.of(this.componentCategory));
        this.printPosition(textIO, path);
        StatusPrinter.printPipelineStatus(pipeline, PipelineBuilderCLI.statusVerbosity, textIO);
        IMenuItem choice = (IMenuItem)((GenericInputReader)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(this.itemList)).withDefaultValue(BackMenuItem.get())).read("\nChoose a component to move.");
        if (!(choice instanceof BackMenuItem)) {
            MenuItemList positionItems = new MenuItemList();
            this.itemList.stream().filter(i -> !(i instanceof BackMenuItem)).forEach(positionItems::add);
            positionItems.add(new PositionMenuItem("<Move to back>", this.itemList.size()));
            positionItems.add(BackMenuItem.get());
            IMenuItem choice2 = (IMenuItem)((GenericInputReader)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues(positionItems)).withDefaultValue(BackMenuItem.get())).read("\nChoose the position to move the component before.");
            if (!(choice2 instanceof BackMenuItem)) {
                int index2;
                List<Description> componentDescriptions = this.delegateSupplier.apply(pipeline);
                ComponentSelectionMenuItem selection1 = (ComponentSelectionMenuItem)choice;
                ComponentSelectionMenuItem selection2 = null;
                if (!(choice2 instanceof PositionMenuItem)) {
                    selection2 = (ComponentSelectionMenuItem)choice2;
                }
                int index1 = componentDescriptions.indexOf(selection1.getDescription());
                int n = index2 = selection2 != null ? componentDescriptions.indexOf(selection2.getDescription()) : componentDescriptions.size();
                if (index1 < index2) {
                    for (int i2 = index1; i2 < index2 && i2 < componentDescriptions.size() - 1; ++i2) {
                        componentDescriptions.set(i2, componentDescriptions.get(i2 + 1));
                    }
                    componentDescriptions.set(index2 - 1, selection1.getDescription());
                } else if (index1 > index2) {
                    for (int i3 = index1; i3 > index2; --i3) {
                        componentDescriptions.set(i3, componentDescriptions.get(i3 - 1));
                    }
                    componentDescriptions.set(index2, selection1.getDescription());
                }
            } else {
                choice = choice2;
            }
        }
        this.clearTerminal(textIO);
        return choice;
    }

    @Override
    public String getName() {
        return this.dialogName;
    }
}

