/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.main.PipelineBuilderCLI;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.MenuItemList;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ActivationDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ArtifactVersionDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ComponentConfigurationSelectionDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopablePipelineManipulationDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.RemoveComponentDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ReorderAnalysisEnginesDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ReorderConsumersDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ReorderMultipliersDialog;
import de.julielab.jcore.pipeline.builder.cli.util.MenuItemExecutionException;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.util.Deque;
import java.util.List;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public class ConfigurePipelineDialog
implements ILoopablePipelineManipulationDialog {
    private MenuItemList<IMenuItem> itemList;

    @Override
    public IMenuItem executeMenuItem(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) throws MenuItemExecutionException {
        this.init();
        this.printPosition(textIO, path);
        StatusPrinter.printPipelineStatus(pipeline, PipelineBuilderCLI.statusVerbosity, textIO);
        IMenuItem choice = (IMenuItem)((GenericInputReader)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues((List<IMenuItem>)this.itemList)).withDefaultValue(BackMenuItem.get())).read("\nChoose an action to perform on your pipeline.");
        this.clearTerminal(textIO);
        if (!(choice instanceof BackMenuItem)) {
            ILoopablePipelineManipulationDialog dialog = (ILoopablePipelineManipulationDialog)choice;
            dialog.enterInputLoop(pipeline, textIO, path);
        }
        this.clearTerminal(textIO);
        return choice;
    }

    private void init() {
        this.itemList = new MenuItemList();
        this.itemList.add(new ComponentConfigurationSelectionDialog());
        this.itemList.add(new ReorderMultipliersDialog());
        this.itemList.add(new ReorderAnalysisEnginesDialog());
        this.itemList.add(new ReorderConsumersDialog());
        this.itemList.add(new RemoveComponentDialog());
        this.itemList.add(new ActivationDialog());
        this.itemList.add(new ArtifactVersionDialog());
        this.itemList.add(BackMenuItem.get());
    }

    @Override
    public String getName() {
        return "Configure Pipeline";
    }

    public String toString() {
        return this.getName();
    }
}

