/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.cli.main.PipelineBuilderCLI;
import de.julielab.jcore.pipeline.builder.cli.menu.ArtifactVersionMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.ComponentSelectionMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.MenuItemList;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.AbstractComponentSelectionDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.UpdateAllArtifactsDialog;
import de.julielab.jcore.pipeline.builder.cli.util.MenuItemExecutionException;
import java.util.Deque;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.beryx.textio.TextIO;

public class ArtifactVersionDialog
extends AbstractComponentSelectionDialog {
    @Override
    public String getName() {
        return "Adapt Component Artifact Versions";
    }

    @Override
    public IMenuItem executeMenuItem(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) throws MenuItemExecutionException {
        IMenuItem item = super.executeMenuItem(pipeline, textIO, path);
        if (item instanceof ComponentSelectionMenuItem) {
            ComponentSelectionMenuItem componentItem = (ComponentSelectionMenuItem)item;
            new ArtifactVersionMenuItem(componentItem.getDescription()).selectVersion(textIO, pipeline);
            PipelineBuilderCLI.dependenciesHaveChanged = true;
        } else if (item instanceof UpdateAllArtifactsDialog) {
            UpdateAllArtifactsDialog dialog = (UpdateAllArtifactsDialog)item;
            dialog.execute(pipeline, textIO);
            PipelineBuilderCLI.dependenciesHaveChanged = true;
        }
        return item;
    }

    @Override
    protected void init(JCoReUIMAPipeline pipeline, EnumSet<PipelineBuilderConstants.JcoreMeta.Category> categories) {
        super.init(pipeline, categories);
        this.itemList = this.itemList.stream().filter(ComponentSelectionMenuItem.class::isInstance).map(ComponentSelectionMenuItem.class::cast).filter(item -> item.getDescription().getMetaDescription().isPear() == false).collect(Collectors.toCollection(MenuItemList::new));
        MenuItemList extendedList = new MenuItemList();
        extendedList.add(new UpdateAllArtifactsDialog());
        extendedList.addAll(this.itemList);
        extendedList.add(BackMenuItem.get());
        this.itemList = extendedList;
    }
}

