/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.cli.menu.dialog;

import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.main.JCoReUIMAPipeline;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescription;
import de.julielab.jcore.pipeline.builder.cli.main.PipelineBuilderCLI;
import de.julielab.jcore.pipeline.builder.cli.menu.BackMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.IMenuItem;
import de.julielab.jcore.pipeline.builder.cli.menu.MenuItemList;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.AddComponentDialog;
import de.julielab.jcore.pipeline.builder.cli.menu.dialog.ILoopablePipelineManipulationDialog;
import de.julielab.jcore.pipeline.builder.cli.util.MenuItemExecutionException;
import de.julielab.jcore.pipeline.builder.cli.util.StatusPrinter;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;

public class AddFlowControllerDialog
implements ILoopablePipelineManipulationDialog {
    public static final String ANALYSIS_ENGINE_AGGREGATE = "Analysis Engine Aggregate";
    public static final String CAS_CONSUMER_AGGREGATE = "CAS Consumer Aggregate";
    private MenuItemList<IMenuItem> itemList;
    private Map<PipelineBuilderConstants.JcoreMeta.Category, List<MetaDescription>> categoryMap;

    public AddFlowControllerDialog(Map<PipelineBuilderConstants.JcoreMeta.Category, List<MetaDescription>> categoryMap) {
        this.categoryMap = categoryMap;
    }

    @Override
    public IMenuItem executeMenuItem(JCoReUIMAPipeline pipeline, TextIO textIO, Deque<String> path) throws MenuItemExecutionException {
        this.init();
        this.printPosition(textIO, path);
        StatusPrinter.printPipelineStatus(pipeline, PipelineBuilderCLI.statusVerbosity, textIO);
        IMenuItem choice = (IMenuItem)((GenericInputReader)((GenericInputReader)textIO.newGenericInputReader(null).withNumberedPossibleValues((List<IMenuItem>)this.itemList)).withDefaultValue(BackMenuItem.get())).read("\nChoose an action to perform on your pipeline.");
        this.clearTerminal(textIO);
        if (!(choice instanceof BackMenuItem)) {
            ILoopablePipelineManipulationDialog dialog = (ILoopablePipelineManipulationDialog)choice;
            dialog.enterInputLoop(pipeline, textIO, path);
        }
        this.clearTerminal(textIO);
        return choice;
    }

    private void init() {
        this.itemList = new MenuItemList();
        this.itemList.add(new AddComponentDialog(this.categoryMap, PipelineBuilderConstants.JcoreMeta.Category.flowcontroller){

            @Override
            public String getName() {
                return AddFlowControllerDialog.ANALYSIS_ENGINE_AGGREGATE;
            }
        });
        this.itemList.add(new AddComponentDialog(this.categoryMap, PipelineBuilderConstants.JcoreMeta.Category.flowcontroller){

            @Override
            public String getName() {
                return AddFlowControllerDialog.CAS_CONSUMER_AGGREGATE;
            }
        });
        this.itemList.add(BackMenuItem.get());
    }

    @Override
    public String getName() {
        return "Flow Controller";
    }

    public String toString() {
        return this.getName();
    }
}

